/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core;

import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.config.CliConfigKeys;
import org.apache.ignite.internal.cli.config.ConfigManager;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

@Singleton
public class JdbcUrlFactory {
    private final ConfigManagerProvider configManagerProvider;

    public JdbcUrlFactory(ConfigManagerProvider configManagerProvider) {
        this.configManagerProvider = configManagerProvider;
    }

    @Nullable
    public String constructJdbcUrl(String nodeUrl, int port) {
        try {
            String host = new URL(nodeUrl).getHost();
            return this.applyConfig("jdbc:ignite:thin://" + host + ":" + port);
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }

    private String applyConfig(String jdbcUrl) {
        ArrayList<String> queryParams = new ArrayList<String>();
        this.addIfSet(queryParams, CliConfigKeys.JDBC_TRUST_STORE_PATH, "trustStorePath");
        this.addIfSet(queryParams, CliConfigKeys.JDBC_TRUST_STORE_PASSWORD, "trustStorePassword");
        this.addIfSet(queryParams, CliConfigKeys.JDBC_KEY_STORE_PATH, "keyStorePath");
        this.addIfSet(queryParams, CliConfigKeys.JDBC_KEY_STORE_PASSWORD, "keyStorePassword");
        this.addIfSet(queryParams, CliConfigKeys.JDBC_CLIENT_AUTH, "clientAuth");
        this.addIfSet(queryParams, CliConfigKeys.JDBC_CIPHERS, "ciphers");
        this.addSslEnabledIfNeeded(queryParams);
        this.addIfSet(queryParams, CliConfigKeys.BASIC_AUTHENTICATION_USERNAME, "username");
        this.addIfSet(queryParams, CliConfigKeys.BASIC_AUTHENTICATION_PASSWORD, "password");
        if (!queryParams.isEmpty()) {
            String query = queryParams.stream().collect(Collectors.joining("&", "?", ""));
            return jdbcUrl + query;
        }
        return jdbcUrl;
    }

    private void addSslEnabledIfNeeded(List<String> queryParams) {
        String sslEnabled = this.configManagerProvider.get().getCurrentProperty(CliConfigKeys.JDBC_SSL_ENABLED.value());
        if (sslEnabled != null) {
            queryParams.add(0, "sslEnabled=" + sslEnabled);
        } else if (!queryParams.isEmpty()) {
            queryParams.add(0, "sslEnabled=true");
        }
    }

    private void addIfSet(List<String> queryParams, CliConfigKeys key, String property) {
        ConfigManager configManager = this.configManagerProvider.get();
        String value = configManager.getCurrentProperty(key.value());
        if (!StringUtils.nullOrBlank((String)value)) {
            queryParams.add(property + "=" + value);
        }
    }
}

