/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.incoming;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.message.GetLowWatermarkResponse;
import org.apache.ignite.internal.lowwatermark.message.LowWatermarkMessagesFactory;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMeta;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaResponse;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataResponse;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageRebalanceException;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionAccess;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite.internal.table.distributed.raft.snapshot.RaftSnapshotPartitionMeta;
import org.apache.ignite.internal.table.distributed.raft.snapshot.SnapshotUri;
import org.apache.ignite.internal.table.distributed.raft.snapshot.incoming.IncomingSnapshotReader;
import org.apache.ignite.internal.table.distributed.schema.CatalogVersionSufficiency;
import org.apache.ignite.internal.tx.message.TxMetaMessage;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotCopier;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.jetbrains.annotations.Nullable;

public class IncomingSnapshotCopier
extends SnapshotCopier {
    private static final IgniteLogger LOG = Loggers.forClass(IncomingSnapshotCopier.class);
    private static final PartitionReplicationMessagesFactory TABLE_MSG_FACTORY = new PartitionReplicationMessagesFactory();
    private static final LowWatermarkMessagesFactory LWM_MSG_FACTORY = new LowWatermarkMessagesFactory();
    private static final long NETWORK_TIMEOUT = Long.MAX_VALUE;
    private static final long MAX_MV_DATA_PAYLOADS_BATCH_BYTES_HINT = 102400L;
    private static final int MAX_TX_DATA_BATCH_SIZE = 1000;
    private final PartitionSnapshotStorage partitionSnapshotStorage;
    private final SnapshotUri snapshotUri;
    private final long waitForMetadataCatchupMs;
    private final AtomicBoolean cancellationGuard = new AtomicBoolean();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    @Nullable
    private volatile PartitionSnapshotMeta snapshotMeta;
    @Nullable
    private volatile CompletableFuture<Boolean> metadataSufficiencyFuture;
    @Nullable
    private volatile CompletableFuture<Void> rebalanceFuture;
    @Nullable
    private volatile CompletableFuture<?> joinFuture;

    public IncomingSnapshotCopier(PartitionSnapshotStorage partitionSnapshotStorage, SnapshotUri snapshotUri, long waitForMetadataCatchupMs) {
        this.partitionSnapshotStorage = partitionSnapshotStorage;
        this.snapshotUri = snapshotUri;
        this.waitForMetadataCatchupMs = waitForMetadataCatchupMs;
    }

    public void start() {
        Executor executor = this.partitionSnapshotStorage.getIncomingSnapshotsExecutor();
        LOG.info("Copier is started for the partition [{}]", new Object[]{this.createPartitionInfo()});
        ClusterNode snapshotSender = this.getSnapshotSender(this.snapshotUri.nodeName);
        this.metadataSufficiencyFuture = snapshotSender == null ? CompletableFuture.failedFuture((Throwable)new StorageRebalanceException("Snapshot sender not found: " + this.snapshotUri.nodeName)) : ((CompletableFuture)this.loadSnapshotMeta(snapshotSender).thenCompose(unused -> this.waitForMetadataWithTimeout())).thenApply(unused -> {
            boolean metadataIsSufficientlyComplete = this.metadataIsSufficientlyComplete();
            if (!metadataIsSufficientlyComplete) {
                this.logMetadataInsufficiencyAndSetError();
            }
            return metadataIsSufficientlyComplete;
        });
        this.rebalanceFuture = this.metadataSufficiencyFuture.thenComposeAsync(metadataSufficient -> {
            if (metadataSufficient.booleanValue()) {
                return this.partitionSnapshotStorage.partition().startRebalance().thenCompose(unused -> {
                    assert (snapshotSender != null) : this.createPartitionInfo();
                    return ((CompletableFuture)this.loadSnapshotMvData(snapshotSender, executor).thenCompose(unused1 -> this.loadSnapshotTxData(snapshotSender, executor))).thenRunAsync(this::setNextRowIdToBuildIndexes, executor);
                });
            }
            return CompletableFutures.nullCompletedFuture();
        }, executor);
        this.joinFuture = this.metadataSufficiencyFuture.thenCompose(metadataSufficient -> {
            if (metadataSufficient.booleanValue()) {
                return ((CompletableFuture)((CompletableFuture)this.rebalanceFuture.handleAsync((unused, throwable) -> this.completeRebalance((Throwable)throwable), executor)).thenCompose(Function.identity())).thenCompose(unused -> {
                    assert (snapshotSender != null) : this.createPartitionInfo();
                    return this.tryUpdateLowWatermark(snapshotSender, executor);
                });
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private CompletableFuture<?> waitForMetadataWithTimeout() {
        CompletableFuture metadataReadyFuture = this.partitionSnapshotStorage.catalogService().catalogReadyFuture(this.snapshotMeta.requiredCatalogVersion());
        CompletableFuture<?> readinessTimeoutFuture = this.completeOnMetadataReadinessTimeout();
        return CompletableFuture.anyOf(metadataReadyFuture, readinessTimeoutFuture);
    }

    private CompletableFuture<?> completeOnMetadataReadinessTimeout() {
        return new CompletableFuture().orTimeout(this.waitForMetadataCatchupMs, TimeUnit.MILLISECONDS).exceptionally(ex -> {
            assert (ex instanceof TimeoutException);
            return null;
        });
    }

    public void join() throws InterruptedException {
        block5: {
            CompletableFuture<?> fut = this.joinFuture;
            if (fut != null) {
                try {
                    fut.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CancellationException) break block5;
                    LOG.error("Error when completing the copier", cause);
                    if (this.isOk()) {
                        this.setError(RaftError.UNKNOWN, "Unknown error on completion the copier", new Object[0]);
                    }
                    throw new IllegalStateException(cause);
                }
            }
        }
    }

    public void cancel() {
        if (!this.cancellationGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        LOG.info("Copier is canceled for partition [{}]", new Object[]{this.createPartitionInfo()});
        List<CompletableFuture> futuresToCancel = Stream.of(this.metadataSufficiencyFuture, this.rebalanceFuture).filter(Objects::nonNull).collect(Collectors.toList());
        futuresToCancel.forEach(future -> future.cancel(false));
        if (!futuresToCancel.isEmpty()) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void close() {
    }

    public SnapshotReader getReader() {
        return new IncomingSnapshotReader(this.snapshotMeta);
    }

    @Nullable
    private ClusterNode getSnapshotSender(String nodeName) {
        return this.partitionSnapshotStorage.topologyService().getByConsistentId(nodeName);
    }

    private CompletableFuture<?> loadSnapshotMeta(ClusterNode snapshotSender) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            CompletionStage completionStage = this.partitionSnapshotStorage.outgoingSnapshotsManager().messagingService().invoke(snapshotSender, (NetworkMessage)TABLE_MSG_FACTORY.snapshotMetaRequest().id(this.snapshotUri.snapshotId).build(), Long.MAX_VALUE).thenAccept(response -> {
                this.snapshotMeta = ((SnapshotMetaResponse)response).meta();
                LOG.info("Copier has loaded the snapshot meta for the partition [{}, meta={}]", new Object[]{this.createPartitionInfo(), this.snapshotMeta});
            });
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private boolean metadataIsSufficientlyComplete() {
        PartitionSnapshotMeta meta = this.snapshotMeta;
        assert (meta != null);
        return CatalogVersionSufficiency.isMetadataAvailableFor(meta.requiredCatalogVersion(), this.partitionSnapshotStorage.catalogService());
    }

    private void logMetadataInsufficiencyAndSetError() {
        LOG.warn("Metadata not yet available, rejecting snapshot installation [uri={}, requiredVersion={}].", new Object[]{this.snapshotUri, this.snapshotMeta.requiredCatalogVersion()});
        String errorMessage = String.format("Metadata not yet available, URI '%s', required level %s; rejecting snapshot installation.", this.snapshotUri, this.snapshotMeta.requiredCatalogVersion());
        if (this.isOk()) {
            this.setError(RaftError.EBUSY, errorMessage, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> loadSnapshotMvData(ClusterNode snapshotSender, Executor executor) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            CompletionStage completionStage = this.partitionSnapshotStorage.outgoingSnapshotsManager().messagingService().invoke(snapshotSender, (NetworkMessage)TABLE_MSG_FACTORY.snapshotMvDataRequest().id(this.snapshotUri.snapshotId).batchSizeHint(102400L).build(), Long.MAX_VALUE).thenComposeAsync(response -> {
                SnapshotMvDataResponse snapshotMvDataResponse = (SnapshotMvDataResponse)response;
                for (SnapshotMvDataResponse.ResponseEntry entry : snapshotMvDataResponse.rows()) {
                    for (int i = 0; i < entry.rowVersions().size(); ++i) {
                        if (!this.busyLock.enterBusy()) {
                            return CompletableFutures.nullCompletedFuture();
                        }
                        try {
                            this.writeVersion(entry, i);
                            continue;
                        }
                        finally {
                            this.busyLock.leaveBusy();
                        }
                    }
                }
                if (snapshotMvDataResponse.finish()) {
                    LOG.info("Copier has finished loading multi-versioned data [{}, rows={}]", new Object[]{this.createPartitionInfo(), snapshotMvDataResponse.rows().size()});
                    return CompletableFutures.nullCompletedFuture();
                }
                LOG.info("Copier has loaded a portion of multi-versioned data [{}, rows={}]", new Object[]{this.createPartitionInfo(), snapshotMvDataResponse.rows().size()});
                return this.loadSnapshotMvData(snapshotSender, executor);
            }, executor);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> loadSnapshotTxData(ClusterNode snapshotSender, Executor executor) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            CompletionStage completionStage = this.partitionSnapshotStorage.outgoingSnapshotsManager().messagingService().invoke(snapshotSender, (NetworkMessage)TABLE_MSG_FACTORY.snapshotTxDataRequest().id(this.snapshotUri.snapshotId).maxTransactionsInBatch(1000).build(), Long.MAX_VALUE).thenComposeAsync(response -> {
                SnapshotTxDataResponse snapshotTxDataResponse = (SnapshotTxDataResponse)response;
                assert (snapshotTxDataResponse.txMeta().size() == snapshotTxDataResponse.txIds().size()) : this.createPartitionInfo();
                for (int i = 0; i < snapshotTxDataResponse.txMeta().size(); ++i) {
                    if (!this.busyLock.enterBusy()) {
                        return CompletableFutures.nullCompletedFuture();
                    }
                    try {
                        this.partitionSnapshotStorage.partition().addTxMeta((UUID)snapshotTxDataResponse.txIds().get(i), ((TxMetaMessage)snapshotTxDataResponse.txMeta().get(i)).asTxMeta());
                        continue;
                    }
                    finally {
                        this.busyLock.leaveBusy();
                    }
                }
                if (snapshotTxDataResponse.finish()) {
                    LOG.info("Copier has finished loading transaction meta [{}, metas={}]", new Object[]{this.createPartitionInfo(), snapshotTxDataResponse.txMeta().size()});
                    return CompletableFutures.nullCompletedFuture();
                }
                LOG.info("Copier has loaded a portion of transaction meta [{}, metas={}]", new Object[]{this.createPartitionInfo(), snapshotTxDataResponse.txMeta().size()});
                return this.loadSnapshotTxData(snapshotSender, executor);
            }, executor);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> completeRebalance(@Nullable Throwable throwable) {
        if (!this.busyLock.enterBusy()) {
            if (this.isOk()) {
                this.setError(RaftError.ECANCELED, "Copier is cancelled", new Object[0]);
            }
            return this.partitionSnapshotStorage.partition().abortRebalance();
        }
        try {
            if (throwable != null) {
                LOG.error("Partition rebalancing error [{}]", throwable, new Object[]{this.createPartitionInfo()});
                if (this.isOk()) {
                    this.setError(RaftError.UNKNOWN, throwable.getMessage(), new Object[0]);
                }
                CompletionStage completionStage = this.partitionSnapshotStorage.partition().abortRebalance().thenCompose(unused -> CompletableFuture.failedFuture(throwable));
                return completionStage;
            }
            PartitionSnapshotMeta meta = this.snapshotMeta;
            RaftGroupConfiguration raftGroupConfig = new RaftGroupConfiguration(meta.peersList(), meta.learnersList(), meta.oldPeersList(), meta.oldLearnersList());
            LOG.info("Copier completes the rebalancing of the partition: [{}, lastAppliedIndex={}, lastAppliedTerm={}, raftGroupConfig={}]", new Object[]{this.createPartitionInfo(), meta.lastIncludedIndex(), meta.lastIncludedTerm(), raftGroupConfig});
            CompletableFuture<Void> completableFuture = this.partitionSnapshotStorage.partition().finishRebalance(RaftSnapshotPartitionMeta.fromSnapshotMeta(meta, raftGroupConfig));
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private int partId() {
        return this.partitionSnapshotStorage.partition().partitionKey().partitionId();
    }

    private String createPartitionInfo() {
        return "tableId=" + this.partitionSnapshotStorage.partition().partitionKey().tableId() + ", partitionId=" + this.partId();
    }

    private void writeVersion(SnapshotMvDataResponse.ResponseEntry entry, int i) {
        RowId rowId = new RowId(this.partId(), entry.rowId());
        BinaryRowMessage rowVersion = (BinaryRowMessage)entry.rowVersions().get(i);
        BinaryRow binaryRow = rowVersion == null ? null : rowVersion.asBinaryRow();
        PartitionAccess partition = this.partitionSnapshotStorage.partition();
        int snapshotCatalogVersion = this.snapshotMeta.requiredCatalogVersion();
        if (i == entry.timestamps().length) {
            assert (entry.txId() != null);
            assert (entry.commitTableId() != null);
            assert (entry.commitPartitionId() != -1);
            partition.addWrite(rowId, binaryRow, entry.txId(), entry.commitTableId(), entry.commitPartitionId(), snapshotCatalogVersion);
        } else {
            partition.addWriteCommitted(rowId, binaryRow, HybridTimestamp.hybridTimestamp((long)entry.timestamps()[i]), snapshotCatalogVersion);
        }
    }

    private void setNextRowIdToBuildIndexes() {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            Map nextRowIdToBuildByIndexId = this.snapshotMeta.nextRowIdToBuildByIndexId();
            if (!CollectionUtils.nullOrEmpty((Map)nextRowIdToBuildByIndexId)) {
                Map<Integer, RowId> nextRowIdToBuildByIndexId0 = nextRowIdToBuildByIndexId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new RowId(this.partId(), (UUID)e.getValue())));
                this.partitionSnapshotStorage.partition().setNextRowIdToBuildIndex(nextRowIdToBuildByIndexId0);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> tryUpdateLowWatermark(ClusterNode snapshotSender, Executor executor) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            CompletionStage completionStage = this.partitionSnapshotStorage.outgoingSnapshotsManager().messagingService().invoke(snapshotSender, (NetworkMessage)LWM_MSG_FACTORY.getLowWatermarkRequest().build(), Long.MAX_VALUE).thenAcceptAsync(response -> {
                GetLowWatermarkResponse getLowWatermarkResponse = (GetLowWatermarkResponse)response;
                HybridTimestamp senderLowWatermark = HybridTimestamp.nullableHybridTimestamp((long)getLowWatermarkResponse.lowWatermark());
                if (senderLowWatermark != null) {
                    this.partitionSnapshotStorage.partition().updateLowWatermark(senderLowWatermark);
                }
            }, executor);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }
}

