/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import java.util.Arrays;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.shaded.io.netty.buffer.ByteBuf;
import org.apache.ignite.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.ignite.shaded.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.ignite.shaded.io.netty.util.CharsetUtil;

public class ClientMessageDecoder
extends LengthFieldBasedFrameDecoder {
    private boolean magicDecoded;
    private boolean magicFailed;

    public ClientMessageDecoder() {
        super(0x7FFFFFFB, 0, 4, 0, 4, true);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (!this.readMagic(in)) {
            return null;
        }
        return super.decode(ctx, in);
    }

    private boolean readMagic(ByteBuf byteBuf) {
        if (this.magicFailed) {
            return false;
        }
        if (this.magicDecoded) {
            return true;
        }
        if (byteBuf.readableBytes() < ClientMessageCommon.MAGIC_BYTES.length) {
            return false;
        }
        byte[] data = new byte[ClientMessageCommon.MAGIC_BYTES.length];
        byteBuf.readBytes(data);
        this.magicDecoded = true;
        if (Arrays.equals(data, ClientMessageCommon.MAGIC_BYTES)) {
            return true;
        }
        this.magicFailed = true;
        throw new IgniteException(ErrorGroups.Client.HANDSHAKE_HEADER_ERR, "Invalid magic header in thin client connection. Expected 'IGNI', but was '" + new String(data, CharsetUtil.US_ASCII) + "'.");
    }
}

