/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.rest;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite.internal.cluster.management.ClusterInitializer;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.rest.exception.InvalidArgumentClusterInitializationException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.api.cluster.ClusterManagementApi;
import org.apache.ignite.internal.rest.api.cluster.ClusterStateDto;
import org.apache.ignite.internal.rest.api.cluster.ClusterTagDto;
import org.apache.ignite.internal.rest.api.cluster.InitCommand;
import org.apache.ignite.internal.rest.exception.ClusterNotInitializedException;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalException;

@Controller(value="/management/v1/cluster")
public class ClusterManagementController
implements ClusterManagementApi {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterManagementController.class);
    private final ClusterInitializer clusterInitializer;
    private final ClusterManagementGroupManager clusterManagementGroupManager;

    public ClusterManagementController(ClusterInitializer clusterInitializer, ClusterManagementGroupManager clusterManagementGroupManager) {
        this.clusterInitializer = clusterInitializer;
        this.clusterManagementGroupManager = clusterManagementGroupManager;
    }

    public CompletableFuture<ClusterStateDto> clusterState() {
        return this.clusterManagementGroupManager.clusterState().thenApply(this::mapClusterState);
    }

    public CompletableFuture<Void> init(@Body InitCommand initCommand) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Received init command [metaStorageNodes={}, cmgNodes={}]", new Object[]{initCommand.metaStorageNodes(), initCommand.cmgNodes()});
        }
        return this.clusterInitializer.initCluster(initCommand.metaStorageNodes(), initCommand.cmgNodes(), initCommand.clusterName()).exceptionally(ex -> {
            throw this.mapException((Throwable)ex);
        });
    }

    private ClusterStateDto mapClusterState(ClusterState clusterState) {
        if (clusterState == null) {
            throw new ClusterNotInitializedException();
        }
        return new ClusterStateDto(clusterState.cmgNodes(), clusterState.metaStorageNodes(), clusterState.igniteVersion().toString(), new ClusterTagDto(clusterState.clusterTag().clusterName(), clusterState.clusterTag().clusterId()));
    }

    private RuntimeException mapException(Throwable ex) {
        Throwable cause;
        if (ex instanceof CompletionException && (cause = ex.getCause()) instanceof IgniteInternalException) {
            return (IgniteInternalException)cause;
        }
        if (ex instanceof IllegalArgumentException) {
            return new InvalidArgumentClusterInitializationException(ex);
        }
        return new IgniteException(ex);
    }
}

