/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.util.Objects;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessage;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessageBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class AcknowledgementMessageImpl
implements AcknowledgementMessage {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 6;
    @IgniteToStringInclude
    private final long receivedMessages;

    private AcknowledgementMessageImpl(long receivedMessages) {
        this.receivedMessages = receivedMessages;
    }

    @Override
    public long receivedMessages() {
        return this.receivedMessages;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(AcknowledgementMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 6;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AcknowledgementMessageImpl otherMessage = (AcknowledgementMessageImpl)other;
        return this.receivedMessages == otherMessage.receivedMessages;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.receivedMessages);
        return result;
    }

    public static AcknowledgementMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements AcknowledgementMessageBuilder {
        private long receivedMessages;

        private Builder() {
        }

        @Override
        public AcknowledgementMessageBuilder receivedMessages(long receivedMessages) {
            this.receivedMessages = receivedMessages;
            return this;
        }

        @Override
        public long receivedMessages() {
            return this.receivedMessages;
        }

        @Override
        public AcknowledgementMessage build() {
            return new AcknowledgementMessageImpl(this.receivedMessages);
        }
    }
}

