#!/usr/bin/env bash
#
# ignite3 Bash Completion
# =======================
#
# Bash completion support for the `ignite3` command,
# generated by [picocli](http://picocli.info/) version 4.6.2.
#
# Installation
# ------------
#
# 1. Source all completion scripts in your .bash_profile
#
#   cd $YOUR_APP_HOME/bin
#   for f in $(find . -name "*_completion"); do line=". $(pwd)/$f"; grep "$line" ~/.bash_profile || echo "$line" >> ~/.bash_profile; done
#
# 2. Open a new bash console, and type `ignite3 [TAB][TAB]`
#
# 1a. Alternatively, if you have [bash-completion](https://github.com/scop/bash-completion) installed:
#     Place this file in a `bash-completion.d` folder:
#
#   * /etc/bash-completion.d
#   * /usr/local/etc/bash-completion.d
#   * ~/bash-completion.d
#
# Documentation
# -------------
# The script is called by bash whenever [TAB] or [TAB][TAB] is pressed after
# 'ignite3 (..)'. By reading entered command line parameters,
# it determines possible bash completions and writes them to the COMPREPLY variable.
# Bash then completes the user input if only one entry is listed in the variable or
# shows the options if more than one is listed in COMPREPLY.
#
# References
# ----------
# [1] http://stackoverflow.com/a/12495480/1440785
# [2] http://tiswww.case.edu/php/chet/bash/FAQ
# [3] https://www.gnu.org/software/bash/manual/html_node/The-Shopt-Builtin.html
# [4] http://zsh.sourceforge.net/Doc/Release/Options.html#index-COMPLETE_005fALIASES
# [5] https://stackoverflow.com/questions/17042057/bash-check-element-in-array-for-elements-in-another-array/17042655#17042655
# [6] https://www.gnu.org/software/bash/manual/html_node/Programmable-Completion.html#Programmable-Completion
# [7] https://stackoverflow.com/questions/3249432/can-a-bash-tab-completion-script-be-used-in-zsh/27853970#27853970
#

if [ -n "$BASH_VERSION" ]; then
  # Enable programmable completion facilities when using bash (see [3])
  shopt -s progcomp
elif [ -n "$ZSH_VERSION" ]; then
  # Make alias a distinct command for completion purposes when using zsh (see [4])
  setopt COMPLETE_ALIASES
  alias compopt=complete

  # Enable bash completion in zsh (see [7])
  autoload -U +X compinit && compinit
  autoload -U +X bashcompinit && bashcompinit
fi

# CompWordsContainsArray takes an array and then checks
# if all elements of this array are in the global COMP_WORDS array.
#
# Returns zero (no error) if all elements of the array are in the COMP_WORDS array,
# otherwise returns 1 (error).
function CompWordsContainsArray() {
  declare -a localArray
  localArray=("$@")
  local findme
  for findme in "${localArray[@]}"; do
    if ElementNotInCompWords "$findme"; then return 1; fi
  done
  return 0
}
function ElementNotInCompWords() {
  local findme="$1"
  local element
  for element in "${COMP_WORDS[@]}"; do
    if [[ "$findme" = "$element" ]]; then return 1; fi
  done
  return 0
}

# The `currentPositionalIndex` function calculates the index of the current positional parameter.
#
# currentPositionalIndex takes three parameters:
# the command name,
# a space-separated string with the names of options that take a parameter, and
# a space-separated string with the names of boolean options (that don't take any params).
# When done, this function echos the current positional index to std_out.
#
# Example usage:
# local currIndex=$(currentPositionalIndex "mysubcommand" "$ARG_OPTS" "$FLAG_OPTS")
function currentPositionalIndex() {
  local commandName="$1"
  local optionsWithArgs="$2"
  local booleanOptions="$3"
  local previousWord
  local result=0

  for i in $(seq $((COMP_CWORD - 1)) -1 0); do
    previousWord=${COMP_WORDS[i]}
    if [ "${previousWord}" = "$commandName" ]; then
      break
    fi
    if [[ "${optionsWithArgs}" =~ ${previousWord} ]]; then
      ((result-=2)) # Arg option and its value not counted as positional param
    elif [[ "${booleanOptions}" =~ ${previousWord} ]]; then
      ((result-=1)) # Flag option itself not counted as positional param
    fi
    ((result++))
  done
  echo "$result"
}

# Bash completion entry point function.
# _complete_ignite3 finds which commands and subcommands have been specified
# on the command line and delegates to the appropriate function
# to generate possible options and subcommands for the last specified subcommand.
function _complete_ignite3() {
  local cmds0=(sql)
  local cmds1=(help)
  local cmds2=(cli)
  local cmds3=(node)
  local cmds4=(cluster)
  local cmds5=(cli config)
  local cmds6=(cli config get)
  local cmds7=(cli config set)
  local cmds8=(cli config show)
  local cmds9=(cli config profile)
  local cmds10=(cli config profile create)
  local cmds11=(cli config profile activate)
  local cmds12=(cli config profile list)
  local cmds13=(cli config profile show)
  local cmds14=(node config)
  local cmds15=(node status)
  local cmds16=(node version)
  local cmds17=(node metric)
  local cmds18=(node config show)
  local cmds19=(node config update)
  local cmds20=(node metric enable)
  local cmds21=(node metric disable)
  local cmds22=(node metric list)
  local cmds23=(cluster config)
  local cmds24=(cluster init)
  local cmds25=(cluster status)
  local cmds26=(cluster cluster show)
  local cmds27=(cluster topology)
  local cmds28=(cluster config show)
  local cmds29=(cluster config update)
  local cmds30=(cluster topology physical)
  local cmds31=(cluster topology logical)

  if CompWordsContainsArray "${cmds31[@]}"; then _picocli_ignite3_cluster_topology_logical; return $?; fi
  if CompWordsContainsArray "${cmds30[@]}"; then _picocli_ignite3_cluster_topology_physical; return $?; fi
  if CompWordsContainsArray "${cmds29[@]}"; then _picocli_ignite3_cluster_config_update; return $?; fi
  if CompWordsContainsArray "${cmds28[@]}"; then _picocli_ignite3_cluster_config_show; return $?; fi
  if CompWordsContainsArray "${cmds27[@]}"; then _picocli_ignite3_cluster_topology; return $?; fi
  if CompWordsContainsArray "${cmds26[@]}"; then _picocli_ignite3_cluster_cluster_show; return $?; fi
  if CompWordsContainsArray "${cmds25[@]}"; then _picocli_ignite3_cluster_status; return $?; fi
  if CompWordsContainsArray "${cmds24[@]}"; then _picocli_ignite3_cluster_init; return $?; fi
  if CompWordsContainsArray "${cmds23[@]}"; then _picocli_ignite3_cluster_config; return $?; fi
  if CompWordsContainsArray "${cmds22[@]}"; then _picocli_ignite3_node_metric_list; return $?; fi
  if CompWordsContainsArray "${cmds21[@]}"; then _picocli_ignite3_node_metric_disable; return $?; fi
  if CompWordsContainsArray "${cmds20[@]}"; then _picocli_ignite3_node_metric_enable; return $?; fi
  if CompWordsContainsArray "${cmds19[@]}"; then _picocli_ignite3_node_config_update; return $?; fi
  if CompWordsContainsArray "${cmds18[@]}"; then _picocli_ignite3_node_config_show; return $?; fi
  if CompWordsContainsArray "${cmds17[@]}"; then _picocli_ignite3_node_metric; return $?; fi
  if CompWordsContainsArray "${cmds16[@]}"; then _picocli_ignite3_node_version; return $?; fi
  if CompWordsContainsArray "${cmds15[@]}"; then _picocli_ignite3_node_status; return $?; fi
  if CompWordsContainsArray "${cmds14[@]}"; then _picocli_ignite3_node_config; return $?; fi
  if CompWordsContainsArray "${cmds13[@]}"; then _picocli_ignite3_cli_config_profile_show; return $?; fi
  if CompWordsContainsArray "${cmds12[@]}"; then _picocli_ignite3_cli_config_profile_list; return $?; fi
  if CompWordsContainsArray "${cmds11[@]}"; then _picocli_ignite3_cli_config_profile_activate; return $?; fi
  if CompWordsContainsArray "${cmds10[@]}"; then _picocli_ignite3_cli_config_profile_create; return $?; fi
  if CompWordsContainsArray "${cmds9[@]}"; then _picocli_ignite3_cli_config_profile; return $?; fi
  if CompWordsContainsArray "${cmds8[@]}"; then _picocli_ignite3_cli_config_show; return $?; fi
  if CompWordsContainsArray "${cmds7[@]}"; then _picocli_ignite3_cli_config_set; return $?; fi
  if CompWordsContainsArray "${cmds6[@]}"; then _picocli_ignite3_cli_config_get; return $?; fi
  if CompWordsContainsArray "${cmds5[@]}"; then _picocli_ignite3_cli_config; return $?; fi
  if CompWordsContainsArray "${cmds4[@]}"; then _picocli_ignite3_cluster; return $?; fi
  if CompWordsContainsArray "${cmds3[@]}"; then _picocli_ignite3_node; return $?; fi
  if CompWordsContainsArray "${cmds2[@]}"; then _picocli_ignite3_cli; return $?; fi
  if CompWordsContainsArray "${cmds1[@]}"; then _picocli_ignite3_help; return $?; fi
  if CompWordsContainsArray "${cmds0[@]}"; then _picocli_ignite3_sql; return $?; fi

  # No subcommands were specified; generate completions for the top-level command.
  _picocli_ignite3; return $?;
}

# Generates completions for the options and subcommands of the `ignite3` command.
function _picocli_ignite3() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="sql help cli node cluster"
  local flag_opts="-h --help -v --verbose --version"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `sql` subcommand.
function _picocli_ignite3_sql() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose --plain"
  local arg_opts="-u --jdbc-url -f --script-file"

  compopt +o default

  case ${prev_word} in
    -u|--jdbc-url)
      return
      ;;
    -f|--script-file)
      compopt -o filenames
      COMPREPLY=( $( compgen -f -- "${curr_word}" ) ) # files
      return $?
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `help` subcommand.
function _picocli_ignite3_help() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="sql cli node cluster"
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `cli` subcommand.
function _picocli_ignite3_cli() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="config"
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `node` subcommand.
function _picocli_ignite3_node() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="config status version metric"
  local flag_opts=""
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `cluster` subcommand.
function _picocli_ignite3_cluster() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="config init status cluster show topology"
  local flag_opts=""
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `config` subcommand.
function _picocli_ignite3_cli_config() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="get set show profile"
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `get` subcommand.
function _picocli_ignite3_cli_config_get() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-p --profile"

  compopt +o default

  case ${prev_word} in
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `set` subcommand.
function _picocli_ignite3_cli_config_set() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-p --profile"

  compopt +o default

  case ${prev_word} in
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `show` subcommand.
function _picocli_ignite3_cli_config_show() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-p --profile"

  compopt +o default

  case ${prev_word} in
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `profile` subcommand.
function _picocli_ignite3_cli_config_profile() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="create activate list show"
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `create` subcommand.
function _picocli_ignite3_cli_config_profile_create() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose --activate -a"
  local arg_opts="--copy-from -c"

  compopt +o default

  case ${prev_word} in
    --copy-from|-c)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `activate` subcommand.
function _picocli_ignite3_cli_config_profile_activate() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `list` subcommand.
function _picocli_ignite3_cli_config_profile_list() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `show` subcommand.
function _picocli_ignite3_cli_config_profile_show() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `config` subcommand.
function _picocli_ignite3_node_config() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="show update"
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `status` subcommand.
function _picocli_ignite3_node_status() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --node-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--node-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `version` subcommand.
function _picocli_ignite3_node_version() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --node-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--node-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `metric` subcommand.
function _picocli_ignite3_node_metric() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="enable disable list"
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `show` subcommand.
function _picocli_ignite3_node_config_show() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --node-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--node-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `update` subcommand.
function _picocli_ignite3_node_config_update() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --node-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--node-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `enable` subcommand.
function _picocli_ignite3_node_metric_enable() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --node-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--node-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `disable` subcommand.
function _picocli_ignite3_node_metric_disable() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --node-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--node-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `list` subcommand.
function _picocli_ignite3_node_metric_list() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --node-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--node-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `config` subcommand.
function _picocli_ignite3_cluster_config() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="show update"
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `init` subcommand.
function _picocli_ignite3_cluster_init() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --cluster-endpoint-url -p --profile -m --meta-storage-node -c --cmg-node -n --cluster-name"

  compopt +o default

  case ${prev_word} in
    -u|--cluster-endpoint-url)
      return
      ;;
    -p|--profile)
      return
      ;;
    -m|--meta-storage-node)
      return
      ;;
    -c|--cmg-node)
      return
      ;;
    -n|--cluster-name)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `status` subcommand.
function _picocli_ignite3_cluster_status() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --cluster-endpoint-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--cluster-endpoint-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `cluster show` subcommand.
function _picocli_ignite3_cluster_cluster_show() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --cluster-endpoint-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--cluster-endpoint-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `topology` subcommand.
function _picocli_ignite3_cluster_topology() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="physical logical"
  local flag_opts="-h --help -v --verbose"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `show` subcommand.
function _picocli_ignite3_cluster_config_show() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --cluster-endpoint-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--cluster-endpoint-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `update` subcommand.
function _picocli_ignite3_cluster_config_update() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose"
  local arg_opts="-u --cluster-endpoint-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--cluster-endpoint-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `physical` subcommand.
function _picocli_ignite3_cluster_topology_physical() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose --plain"
  local arg_opts="-u --cluster-endpoint-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--cluster-endpoint-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `logical` subcommand.
function _picocli_ignite3_cluster_topology_logical() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help -v --verbose --plain"
  local arg_opts="-u --cluster-endpoint-url -p --profile"

  compopt +o default

  case ${prev_word} in
    -u|--cluster-endpoint-url)
      return
      ;;
    -p|--profile)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Define a completion specification (a compspec) for the
# `ignite3`, `ignite3.sh`, and `ignite3.bash` commands.
# Uses the bash `complete` builtin (see [6]) to specify that shell function
# `_complete_ignite3` is responsible for generating possible completions for the
# current word on the command line.
# The `-o default` option means that if the function generated no matches, the
# default Bash completions and the Readline default filename completions are performed.
complete -F _complete_ignite3 -o default ignite3 ignite3.sh ignite3.bash
