/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.util.IgniteNameUtils;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.NotNull;

class TupleImpl
implements Tuple,
Serializable {
    private static final long serialVersionUID = 0L;
    private transient Map<String, Integer> colMapping;
    private final List<String> colNames;
    private final List<Object> colValues;

    TupleImpl() {
        this(new HashMap<String, Integer>(), new ArrayList<String>(), new ArrayList<Object>());
    }

    TupleImpl(int capacity) {
        this(new HashMap<String, Integer>(capacity), new ArrayList<String>(capacity), new ArrayList<Object>(capacity));
    }

    TupleImpl(@NotNull Tuple tuple) {
        this(tuple.columnCount());
        int len = tuple.columnCount();
        for (int i = 0; i < len; ++i) {
            this.set(tuple.columnName(i), tuple.value(i));
        }
    }

    private TupleImpl(Map<String, Integer> columnMapping, List<String> columnNames, List<Object> columnValues) {
        this.colMapping = columnMapping;
        this.colNames = columnNames;
        this.colValues = columnValues;
    }

    @Override
    public Tuple set(@NotNull String columnName, Object val) {
        String columnName0 = IgniteNameUtils.parseSimpleName((String)columnName);
        int idx = this.colMapping.computeIfAbsent(Objects.requireNonNull(columnName0), name -> this.colMapping.size());
        if (idx == this.colNames.size()) {
            this.colNames.add(idx, columnName0);
            this.colValues.add(idx, val);
        } else {
            this.colNames.set(idx, columnName0);
            this.colValues.set(idx, val);
        }
        return this;
    }

    @Override
    public String columnName(int columnIndex) {
        Objects.checkIndex(columnIndex, this.colValues.size());
        return this.colNames.get(columnIndex);
    }

    @Override
    public int columnIndex(@NotNull String columnName) {
        Objects.requireNonNull(columnName);
        Integer idx = this.colMapping.get(IgniteNameUtils.parseSimpleName((String)columnName));
        return idx == null ? -1 : idx;
    }

    @Override
    public int columnCount() {
        return this.colNames.size();
    }

    @Override
    public <T> T valueOrDefault(@NotNull String columnName, T def) {
        int idx = this.columnIndex(columnName);
        return (T)(idx == -1 ? def : this.colValues.get(idx));
    }

    @Override
    public <T> T value(@NotNull String columnName) {
        int idx = this.columnIndex(columnName);
        if (idx == -1) {
            throw new IllegalArgumentException("Column not found: columnName=" + columnName);
        }
        return (T)this.colValues.get(idx);
    }

    @Override
    public <T> T value(int columnIndex) {
        Objects.checkIndex(columnIndex, this.colValues.size());
        return (T)this.colValues.get(columnIndex);
    }

    @Override
    public BinaryObject binaryObjectValue(@NotNull String columnName) {
        return (BinaryObject)this.value(columnName);
    }

    @Override
    public BinaryObject binaryObjectValue(int columnIndex) {
        return (BinaryObject)this.value(columnIndex);
    }

    @Override
    public byte byteValue(@NotNull String columnName) {
        return (Byte)this.value(columnName);
    }

    @Override
    public byte byteValue(int columnIndex) {
        return (Byte)this.value(columnIndex);
    }

    @Override
    public short shortValue(@NotNull String columnName) {
        return (Short)this.value(columnName);
    }

    @Override
    public short shortValue(int columnIndex) {
        return (Short)this.value(columnIndex);
    }

    @Override
    public int intValue(@NotNull String columnName) {
        return (Integer)this.value(columnName);
    }

    @Override
    public int intValue(int columnIndex) {
        return (Integer)this.value(columnIndex);
    }

    @Override
    public long longValue(@NotNull String columnName) {
        return (Long)this.value(columnName);
    }

    @Override
    public long longValue(int columnIndex) {
        return (Long)this.value(columnIndex);
    }

    @Override
    public float floatValue(@NotNull String columnName) {
        return ((Float)this.value(columnName)).floatValue();
    }

    @Override
    public float floatValue(int columnIndex) {
        return ((Float)this.value(columnIndex)).floatValue();
    }

    @Override
    public double doubleValue(@NotNull String columnName) {
        return (Double)this.value(columnName);
    }

    @Override
    public double doubleValue(int columnIndex) {
        return (Double)this.value(columnIndex);
    }

    @Override
    public String stringValue(@NotNull String columnName) {
        return (String)this.value(columnName);
    }

    @Override
    public String stringValue(int columnIndex) {
        return (String)this.value(columnIndex);
    }

    @Override
    public UUID uuidValue(@NotNull String columnName) {
        return (UUID)this.value(columnName);
    }

    @Override
    public UUID uuidValue(int columnIndex) {
        return (UUID)this.value(columnIndex);
    }

    @Override
    public BitSet bitmaskValue(@NotNull String columnName) {
        return (BitSet)this.value(columnName);
    }

    @Override
    public BitSet bitmaskValue(int columnIndex) {
        return (BitSet)this.value(columnIndex);
    }

    @Override
    public LocalDate dateValue(String columnName) {
        return (LocalDate)this.value(columnName);
    }

    @Override
    public LocalDate dateValue(int columnIndex) {
        return (LocalDate)this.value(columnIndex);
    }

    @Override
    public LocalTime timeValue(String columnName) {
        return (LocalTime)this.value(columnName);
    }

    @Override
    public LocalTime timeValue(int columnIndex) {
        return (LocalTime)this.value(columnIndex);
    }

    @Override
    public LocalDateTime datetimeValue(String columnName) {
        return (LocalDateTime)this.value(columnName);
    }

    @Override
    public LocalDateTime datetimeValue(int columnIndex) {
        return (LocalDateTime)this.value(columnIndex);
    }

    @Override
    public Instant timestampValue(String columnName) {
        return (Instant)this.value(columnName);
    }

    @Override
    public Instant timestampValue(int columnIndex) {
        return (Instant)this.value(columnIndex);
    }

    @Override
    @NotNull
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int cur = 0;

            @Override
            public boolean hasNext() {
                return this.cur < TupleImpl.this.colValues.size();
            }

            @Override
            public Object next() {
                return this.hasNext() ? TupleImpl.this.colValues.get(this.cur++) : null;
            }
        };
    }

    @Override
    public int hashCode() {
        return Tuple.hashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tuple) {
            return Tuple.equals(this, (Tuple)obj);
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.colMapping = new HashMap<String, Integer>(this.colNames.size());
        for (int i = 0; i < this.colNames.size(); ++i) {
            this.colMapping.put(this.colNames.get(i), i);
        }
    }
}

