/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.lang.IgniteException;

public interface MarshallerWriter {
    public void writeNull();

    public void writeAbsentValue();

    public void writeByte(byte var1);

    public void writeShort(short var1);

    public void writeInt(int var1);

    public void writeLong(long var1);

    public void writeFloat(float var1);

    public void writeDouble(double var1);

    public void writeString(String var1);

    public void writeUuid(UUID var1);

    public void writeBytes(byte[] var1);

    public void writeBitSet(BitSet var1);

    public void writeBigInt(BigInteger var1);

    public void writeBigDecimal(BigDecimal var1, int var2);

    public void writeDate(LocalDate var1);

    public void writeTime(LocalTime var1);

    public void writeTimestamp(Instant var1);

    public void writeDateTime(LocalDateTime var1);

    default public void writeValue(MarshallerColumn col, Object val) {
        if (val == null) {
            this.writeNull();
            return;
        }
        switch (col.type()) {
            case BYTE: {
                this.writeByte((Byte)val);
                break;
            }
            case SHORT: {
                this.writeShort((Short)val);
                break;
            }
            case INT: {
                this.writeInt((Integer)val);
                break;
            }
            case LONG: {
                this.writeLong((Long)val);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)val);
                break;
            }
            case UUID: {
                this.writeUuid((UUID)val);
                break;
            }
            case TIME: {
                this.writeTime((LocalTime)val);
                break;
            }
            case DATE: {
                this.writeDate((LocalDate)val);
                break;
            }
            case DATETIME: {
                this.writeDateTime((LocalDateTime)val);
                break;
            }
            case TIMESTAMP: {
                this.writeTimestamp((Instant)val);
                break;
            }
            case STRING: {
                this.writeString((String)val);
                break;
            }
            case BYTE_ARR: {
                this.writeBytes((byte[])val);
                break;
            }
            case BITSET: {
                this.writeBitSet((BitSet)val);
                break;
            }
            case NUMBER: {
                this.writeBigInt((BigInteger)val);
                break;
            }
            case DECIMAL: {
                this.writeBigDecimal((BigDecimal)val, col.scale());
                break;
            }
            default: {
                throw new IgniteException("Unexpected value: " + col.type());
            }
        }
    }
}

