/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.deprecated.ui;

import java.io.PrintWriter;
import java.time.Duration;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import picocli.CommandLine;

public class ProgressBar
implements AutoCloseable {
    private final IgniteLogger log = Loggers.forClass(this.getClass());
    private final PrintWriter out;
    private int curr;
    private int max;
    private final int targetBarWidth;

    public ProgressBar(PrintWriter out, int initMax, int terminalWidth) {
        this.out = out;
        assert (initMax > 0);
        this.max = initMax;
        this.targetBarWidth = Math.min(100, terminalWidth);
    }

    public void setMax(int newMax) {
        assert (newMax > 0);
        this.max = newMax;
    }

    public void step() {
        if (this.curr < this.max) {
            ++this.curr;
        }
        this.out.print("\r" + this.render());
        this.out.flush();
    }

    @Override
    public void close() {
        while (this.curr < this.max) {
            LockSupport.parkNanos(Duration.ofMillis(10L).toNanos());
            this.step();
        }
        this.out.println();
    }

    private String render() {
        assert (this.curr <= this.max);
        double completedPart = (double)this.curr / (double)this.max;
        int reservedSpace = 7;
        if (this.targetBarWidth < reservedSpace) {
            this.log.warn("Terminal width is too small to show the progress bar", new Object[0]);
            return "";
        }
        int numOfCompletedSymbols = (int)(completedPart * (double)(this.targetBarWidth - reservedSpace));
        StringBuilder sb = new StringBuilder("|");
        sb.append("=".repeat(numOfCompletedSymbols));
        if (completedPart < 1.0) {
            sb.append('>').append(" ".repeat(this.targetBarWidth - reservedSpace - numOfCompletedSymbols));
            String percentage = (int)(completedPart * 100.0) + "%";
            int percentageLen = percentage.length();
            sb.append("|").append(" ".repeat(4 - percentageLen)).append(percentage);
        } else {
            sb.append("=|@|green,bold Done|@");
        }
        return CommandLine.Help.Ansi.AUTO.string(sb.toString());
    }
}

