/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.sql;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.call.sql.SqlQueryCall;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.call.StringCallInput;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.exception.handler.SqlExceptionHandler;
import org.apache.ignite.internal.cli.decorators.PlainTableDecorator;
import org.apache.ignite.internal.cli.decorators.SqlQueryResultDecorator;
import org.apache.ignite.internal.cli.decorators.TableDecorator;
import org.apache.ignite.internal.cli.deprecated.IgniteCliException;
import org.apache.ignite.internal.cli.sql.SqlManager;
import picocli.CommandLine;

@CommandLine.Command(name="sql", description={"Executes SQL query"})
public class SqlCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-u", "--jdbc-url"}, required=true, descriptionKey="ignite.jdbc-url", description={"JDBC url to ignite cluster"})
    private String jdbc;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting"})
    private boolean plain;
    @CommandLine.ArgGroup(multiplicity="1")
    private ExecOptions execOptions;

    private static String extract(File file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file.toPath(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IgniteCliException("File with command not found");
        }
    }

    @Override
    public Integer call() {
        Integer n;
        SqlManager sqlManager = new SqlManager(this.jdbc);
        try {
            String executeCommand = this.execOptions.file != null ? SqlCommand.extract(this.execOptions.file) : this.execOptions.command;
            TableDecorator tableDecorator = this.plain ? new PlainTableDecorator() : new TableDecorator();
            n = CallExecutionPipeline.builder(new SqlQueryCall(sqlManager)).inputProvider(() -> new StringCallInput(executeCommand)).output(this.spec.commandLine().getOut()).errOutput(this.spec.commandLine().getErr()).decorator(new SqlQueryResultDecorator(tableDecorator)).verbose(this.verbose).build().runPipeline();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sqlManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                return new SqlExceptionHandler().handle(ExceptionWriter.fromPrintWriter(this.spec.commandLine().getErr()), e);
            }
        }
        sqlManager.close();
        return n;
    }

    private static class ExecOptions {
        @CommandLine.Parameters(index="0", description={"SQL query to execute"})
        private String command;
        @CommandLine.Option(names={"-f", "--script-file"}, description={"Path to file with SQL commands to execute"})
        private File file;

        private ExecOptions() {
        }
    }
}

