/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster.status;

import java.util.List;

public class ClusterStatus {
    private final int nodeCount;
    private final boolean initialized;
    private final String name;
    private final boolean connected;
    private final String nodeUrl;
    private final List<String> cmgNodes;
    private final List<String> metadataStorageNodes;

    private ClusterStatus(int nodeCount, boolean initialized, String name, boolean connected, String nodeUrl, List<String> cmgNodes, List<String> metadataStorageNodes) {
        this.nodeCount = nodeCount;
        this.initialized = initialized;
        this.name = name;
        this.connected = connected;
        this.nodeUrl = nodeUrl;
        this.cmgNodes = cmgNodes;
        this.metadataStorageNodes = metadataStorageNodes;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getNodeUrl() {
        return this.nodeUrl;
    }

    public List<String> getCmgNodes() {
        return this.cmgNodes;
    }

    public List<String> getMsNodes() {
        return this.metadataStorageNodes;
    }

    public static ClusterStatusBuilder builder() {
        return new ClusterStatusBuilder();
    }

    public static class ClusterStatusBuilder {
        private int nodeCount;
        private boolean initialized;
        private String name;
        private boolean connected;
        private String connectedNodeUrl;
        private List<String> cmgNodes;
        private List<String> metadataStorageNodes;

        private ClusterStatusBuilder() {
        }

        public ClusterStatusBuilder nodeCount(int nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public ClusterStatusBuilder initialized(boolean initialized) {
            this.initialized = initialized;
            return this;
        }

        public ClusterStatusBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ClusterStatusBuilder connected(boolean connected) {
            this.connected = connected;
            return this;
        }

        public ClusterStatusBuilder connectedNodeUrl(String connectedNodeUrl) {
            this.connectedNodeUrl = connectedNodeUrl;
            return this;
        }

        public ClusterStatusBuilder cmgNodes(List<String> cmgNodes) {
            this.cmgNodes = cmgNodes;
            return this;
        }

        public ClusterStatusBuilder metadataStorageNodes(List<String> metadataStorageNodes) {
            this.metadataStorageNodes = metadataStorageNodes;
            return this;
        }

        public ClusterStatus build() {
            return new ClusterStatus(this.nodeCount, this.initialized, this.name, this.connected, this.connectedNodeUrl, this.cmgNodes, this.metadataStorageNodes);
        }
    }
}

