/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteTetraFunction;
import org.apache.ignite.lang.IgniteTriFunction;
import org.jetbrains.annotations.Nullable;

public final class ExceptionUtils {
    private static final String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String mtdName) {
        Method mtd = null;
        try {
            mtd = throwable.getClass().getMethod(mtdName, null);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (mtd != null && Throwable.class.isAssignableFrom(mtd.getReturnType())) {
            try {
                return (Throwable)mtd.invoke((Object)throwable, ArrayUtils.OBJECT_EMPTY_ARRAY);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException || throwable instanceof InvocationTargetException) {
            return true;
        }
        if (ExceptionUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        for (String methodName : CAUSE_METHOD_NAMES) {
            try {
                Method mtd = cls.getMethod(methodName, null);
                if (mtd == null || !Throwable.class.isAssignableFrom(mtd.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] mtdNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = ExceptionUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            if (mtdNames == null) {
                mtdNames = CAUSE_METHOD_NAMES;
            }
            for (String mtdName : mtdNames) {
                if (mtdName != null && (cause = ExceptionUtils.getCauseUsingMethodName(throwable, mtdName)) != null) break;
            }
            if (cause == null) {
                cause = ExceptionUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return list;
    }

    public static List<Throwable> getSuppressedList(@Nullable Throwable t) {
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        if (t == null) {
            return result;
        }
        do {
            for (Throwable suppressed : t.getSuppressed()) {
                result.add(suppressed);
                result.addAll(ExceptionUtils.getSuppressedList(suppressed));
            }
        } while ((t = t.getCause()) != null);
        return result;
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        List<Throwable> ts = ExceptionUtils.getThrowableList(throwable);
        for (Throwable t : ts) {
            t.printStackTrace(pw);
            if (!ExceptionUtils.isNestedThrowable(t)) continue;
            break;
        }
        return sw.getBuffer().toString();
    }

    public static Throwable unwrapCause(Throwable e) {
        while ((e instanceof CompletionException || e instanceof ExecutionException) && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static <T extends Exception> T withCause(IgniteTriFunction<UUID, Integer, Throwable, T> supplier, int defaultCode, Throwable t) {
        return (T)ExceptionUtils.withCauseInternal((traceId, code, message, cause) -> (Exception)supplier.apply((UUID)traceId, (Integer)code, t), defaultCode, t);
    }

    public static <T extends Exception> T withCause(IgniteTetraFunction<UUID, Integer, String, Throwable, T> supplier, int defaultCode, String message, Throwable t) {
        return (T)ExceptionUtils.withCauseInternal((traceId, code, m, cause) -> (Exception)supplier.apply((UUID)traceId, (Integer)code, message, t), defaultCode, t);
    }

    public static <T extends Exception> T withCauseAndCode(IgniteTriFunction<UUID, Integer, Throwable, T> supplier, int code, Throwable t) {
        return (T)ExceptionUtils.withCauseInternal((traceId, c, message, cause) -> (Exception)supplier.apply((UUID)traceId, code, t), code, t);
    }

    public static <T extends Exception> T withCauseAndCode(IgniteTetraFunction<UUID, Integer, String, Throwable, T> supplier, int code, String message, Throwable t) {
        return (T)ExceptionUtils.withCauseInternal((traceId, c, m, cause) -> (Exception)supplier.apply((UUID)traceId, code, message, t), code, t);
    }

    private static <T extends Exception> T withCauseInternal(IgniteTetraFunction<UUID, Integer, String, Throwable, T> supplier, int defaultCode, Throwable t) {
        Throwable unwrapped = ExceptionUtils.unwrapCause(t);
        if (unwrapped instanceof IgniteInternalException) {
            IgniteInternalException iie = (IgniteInternalException)unwrapped;
            return (T)((Exception)supplier.apply(iie.traceId(), iie.code(), iie.getMessage(), t));
        }
        if (unwrapped instanceof IgniteInternalCheckedException) {
            IgniteInternalCheckedException iice = (IgniteInternalCheckedException)unwrapped;
            return (T)((Exception)supplier.apply(iice.traceId(), iice.code(), iice.getMessage(), t));
        }
        return (T)((Exception)supplier.apply(UUID.randomUUID(), defaultCode, t.getMessage(), t));
    }

    static {
        Method causeMtd;
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            causeMtd = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception ignored) {
            causeMtd = null;
        }
        THROWABLE_CAUSE_METHOD = causeMtd;
    }
}

