/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.freelist;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.Storable;
import org.apache.ignite.internal.pagememory.evict.PageEvictionTracker;
import org.apache.ignite.internal.pagememory.freelist.CorruptedFreeListException;
import org.apache.ignite.internal.pagememory.freelist.FreeList;
import org.apache.ignite.internal.pagememory.freelist.PagesList;
import org.apache.ignite.internal.pagememory.io.AbstractDataPageIo;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.reuse.LongListReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageHandler;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFreeList<T extends Storable>
extends PagesList
implements FreeList<T>,
ReuseList {
    private static final int BUCKETS = 256;
    private static final int REUSE_BUCKET = 255;
    private static final Integer COMPLETE = Integer.MAX_VALUE;
    private static final Integer FAIL_I = Integer.MIN_VALUE;
    private static final Long FAIL_L = Long.MAX_VALUE;
    private static final int MIN_PAGE_FREE_SPACE = 8;
    private final int shift;
    private final AtomicReferenceArray<PagesList.Stripe[]> buckets = new AtomicReferenceArray(256);
    private final AtomicReferenceArray<PagesList.PagesCache> bucketCaches = new AtomicReferenceArray(256);
    private final int minSizeForDataPage;
    @Nullable
    private final AtomicLong pageListCacheLimit;
    protected final PageEvictionTracker evictionTracker;
    private final WriteRowHandler writeRowHnd = new WriteRowHandler();
    private final WriteRowsHandler writeRowsHnd = new WriteRowsHandler();
    private final PageHandler<ReuseBag, Long> rmvRow;

    public AbstractFreeList(int grpId, int partId, String name, PageMemory pageMem, @Nullable ReuseList reuseList, PageLockListener lockLsnr, IgniteLogger log, long metaPageId, boolean initNew, @Nullable AtomicLong pageListCacheLimit, PageEvictionTracker evictionTracker) throws IgniteInternalCheckedException {
        super(name, grpId, partId, pageMem, lockLsnr, log, 256, metaPageId);
        int pageSize;
        this.evictionTracker = evictionTracker;
        this.pageListCacheLimit = pageListCacheLimit;
        this.reuseList = reuseList == null ? this : reuseList;
        this.rmvRow = new RemoveRowHandler(grpId == 0);
        assert (IgniteUtils.isPow2((int)pageSize)) : "Page size must be a power of 2: " + pageSize;
        assert (IgniteUtils.isPow2((int)256));
        assert (256 <= pageSize) : pageSize;
        this.minSizeForDataPage = pageSize - 66;
        int shift = 0;
        for (pageSize = pageMem.pageSize(); pageSize > 256; pageSize >>>= 1) {
            ++shift;
        }
        this.shift = shift;
        this.init(metaPageId, initNew);
    }

    public long freeSpace() {
        long freeSpace = 0L;
        for (int b = 254; b > 0; --b) {
            long perPageFreeSpace = b << this.shift;
            long pages = this.bucketsSize.get(b);
            freeSpace += pages * perPageFreeSpace;
        }
        return freeSpace;
    }

    @Override
    public void dumpStatistics(IgniteLogger log) {
        long dataPages = 0L;
        boolean dumpBucketsInfo = false;
        for (int b = 0; b < 256; ++b) {
            long size = this.bucketsSize.get(b);
            if (this.isReuseBucket(b)) continue;
            dataPages += size;
        }
        if (dataPages > 0L && log.isInfoEnabled()) {
            log.info("FreeList [name={}, buckets={}, dataPages={}, reusePages={}]", new Object[]{this.name(), 256, dataPages, this.bucketsSize.get(255)});
        }
    }

    private int bucket(int freeSpace, boolean allowReuse) {
        assert (freeSpace > 0) : freeSpace;
        int bucket = freeSpace >>> this.shift;
        assert (bucket >= 0 && bucket < 256) : bucket;
        if (!allowReuse && this.isReuseBucket(bucket)) {
            --bucket;
        }
        return bucket;
    }

    @Override
    protected int getBucketIndex(int freeSpace) {
        return freeSpace > 8 ? this.bucket(freeSpace, false) : -1;
    }

    private long allocateDataPage(int part) throws IgniteInternalCheckedException {
        assert (part <= 65500);
        return this.pageMem.allocatePage(this.grpId, part, (byte)1);
    }

    @Override
    public void insertDataRow(T row, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        int written = 0;
        try {
            while ((written = this.writeSinglePage(row, written, statHolder)) != COMPLETE) {
            }
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to insert data row", t, this.grpId, new long[0]);
        }
    }

    @Override
    public void insertDataRows(Collection<T> rows, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        try {
            CachedIterator<T> it = new CachedIterator<T>(rows.iterator());
            int written = COMPLETE;
            while (written != COMPLETE || it.hasNext()) {
                while (this.evictionTracker.evictionRequired()) {
                    this.evictionTracker.evictDataPage();
                }
                if (written == COMPLETE) {
                    written = this.writeWholePages((Storable)it.next(), statHolder);
                    continue;
                }
                Storable row = (Storable)it.get();
                AbstractDataPageIo<?> initIo = null;
                long pageId = this.takePage(row.size() - written, row, statHolder);
                if (pageId == 0L) {
                    pageId = this.allocateDataPage(row.partition());
                    initIo = row.ioVersions().latest();
                }
                written = this.write(pageId, this.writeRowsHnd, initIo, it, written, FAIL_I, statHolder);
                assert (written != FAIL_I);
            }
        }
        catch (RuntimeException e) {
            throw new CorruptedFreeListException("Failed to insert data rows", e, this.grpId, new long[0]);
        }
    }

    private int writeWholePages(T row, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        assert (row.link() == 0L) : row.link();
        int written = 0;
        int rowSize = row.size();
        while (rowSize - written >= this.minSizeForDataPage) {
            written = this.writeSinglePage(row, written, statHolder);
        }
        return written;
    }

    private int writeSinglePage(T row, int written, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        AbstractDataPageIo<?> initIo = null;
        long pageId = this.takePage(row.size() - written, row, statHolder);
        if (pageId == 0L) {
            pageId = this.allocateDataPage(row.partition());
            initIo = row.ioVersions().latest();
        }
        written = this.write(pageId, this.writeRowHnd, initIo, row, written, FAIL_I, statHolder);
        assert (written != FAIL_I);
        return written;
    }

    private long takePage(int size, T row, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long pageId = 0L;
        if (size < this.minSizeForDataPage) {
            for (int b = this.bucket(size, false) + 1; b < 255 && (pageId = this.takeEmptyPage(b, row.ioVersions(), statHolder)) == 0L; ++b) {
            }
        }
        if (pageId == 0L) {
            if (this.reuseList == this) {
                pageId = this.takeEmptyPage(255, row.ioVersions(), statHolder);
            } else {
                pageId = this.reuseList.takeRecycledPage();
                if (pageId != 0L) {
                    pageId = this.reuseList.initRecycledPage(pageId, (byte)1, row.ioVersions().latest());
                }
            }
        }
        if (pageId == 0L) {
            return 0L;
        }
        assert (PageIdUtils.flag(pageId) == 1) : "rowVersions=" + row.ioVersions() + ", pageId=" + PageIdUtils.toDetailString(pageId);
        return PageIdUtils.changePartitionId(pageId, row.partition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long initReusedPage(T row, long reusedPageId, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long reusedPage = this.acquirePage(reusedPageId, statHolder);
        try {
            long l;
            long reusedPageAddr = this.writeLock(reusedPageId, reusedPage);
            assert (reusedPageAddr != 0L);
            try {
                l = this.initReusedPage(reusedPageId, reusedPageAddr, row.partition(), (byte)1, row.ioVersions().latest());
            }
            catch (Throwable throwable) {
                this.writeUnlock(reusedPageId, reusedPage, reusedPageAddr, true);
                throw throwable;
            }
            this.writeUnlock(reusedPageId, reusedPage, reusedPageAddr, true);
            return l;
        }
        finally {
            this.releasePage(reusedPageId, reusedPage);
        }
    }

    @Override
    public <S, R> R updateDataRow(long link, PageHandler<S, R> pageHnd, S arg, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        assert (link != 0L);
        try {
            long pageId = PageIdUtils.pageId(link);
            int itemId = PageIdUtils.itemId(link);
            R updRes = this.write(pageId, pageHnd, arg, itemId, null, statHolder);
            assert (updRes != null);
            return updRes;
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to update data row", t, this.grpId, new long[0]);
        }
    }

    @Override
    public void removeDataRowByLink(long link, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        assert (link != 0L);
        try {
            long pageId = PageIdUtils.pageId(link);
            int itemId = PageIdUtils.itemId(link);
            LongListReuseBag bag = new LongListReuseBag();
            long nextLink = this.write(pageId, this.rmvRow, bag, itemId, FAIL_L, statHolder);
            assert (nextLink != FAIL_L);
            while (nextLink != 0L) {
                itemId = PageIdUtils.itemId(nextLink);
                pageId = PageIdUtils.pageId(nextLink);
                nextLink = this.write(pageId, this.rmvRow, bag, itemId, FAIL_L, statHolder);
                assert (nextLink != FAIL_L);
            }
            this.reuseList.addForRecycle(bag);
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to remove data by link", t, this.grpId, new long[0]);
        }
    }

    @Override
    protected PagesList.Stripe[] getBucket(int bucket) {
        return this.buckets.get(bucket);
    }

    @Override
    protected boolean casBucket(int bucket, PagesList.Stripe[] exp, PagesList.Stripe[] upd) {
        boolean res = this.buckets.compareAndSet(bucket, exp, upd);
        if (this.log.isDebugEnabled()) {
            this.log.debug("CAS bucket [list=" + this.name() + ", bucket=" + bucket + ", old=" + Arrays.toString(exp) + ", new=" + Arrays.toString(upd) + ", res=" + res + "]", new Object[0]);
        }
        return res;
    }

    @Override
    protected boolean isReuseBucket(int bucket) {
        return bucket == 255;
    }

    @Override
    protected PagesList.PagesCache getBucketCache(int bucket, boolean create) {
        PagesList.PagesCache pagesCache = this.bucketCaches.get(bucket);
        if (pagesCache == null && create && !this.bucketCaches.compareAndSet(bucket, null, pagesCache = new PagesList.PagesCache(this.pageListCacheLimit))) {
            pagesCache = this.bucketCaches.get(bucket);
        }
        return pagesCache;
    }

    public int emptyDataPages() {
        return (int)this.bucketsSize.get(255);
    }

    @Override
    public void addForRecycle(ReuseBag bag) throws IgniteInternalCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            this.put(bag, 0L, 0L, 255, IoStatisticsHolderNoOp.INSTANCE);
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to add page for recycle", t, this.grpId, new long[0]);
        }
    }

    @Override
    public long takeRecycledPage() throws IgniteInternalCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            return this.takeEmptyPage(255, null, IoStatisticsHolderNoOp.INSTANCE);
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to take recycled page", t, this.grpId, new long[0]);
        }
    }

    @Override
    public long initRecycledPage(long pageId, byte flag, PageIo initIo) throws IgniteInternalCheckedException {
        return this.initRecycledPage0(pageId, flag, initIo);
    }

    @Override
    public long recycledPagesCount() throws IgniteInternalCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            return this.storedPagesCount(255);
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to count recycled pages", t, this.grpId, new long[0]);
        }
    }

    public String toString() {
        return "FreeList [name=" + this.name() + "]";
    }

    private static class CachedIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;
        private T next;

        CachedIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.next = this.it.next();
            return this.next;
        }

        T get() {
            return this.next;
        }
    }

    private final class RemoveRowHandler
    implements PageHandler<ReuseBag, Long> {
        private final boolean maskPartId;

        RemoveRowHandler(boolean maskPartId) {
            this.maskPartId = maskPartId;
        }

        @Override
        public Long run(int cacheId, long pageId, long page, long pageAddr, PageIo iox, ReuseBag reuseBag, int itemId, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
            AbstractDataPageIo io = (AbstractDataPageIo)iox;
            int oldFreeSpace = io.getFreeSpace(pageAddr);
            assert (oldFreeSpace >= 0) : oldFreeSpace;
            long nextLink = io.removeRow(pageAddr, itemId, AbstractFreeList.this.pageSize());
            int newFreeSpace = io.getFreeSpace(pageAddr);
            if (newFreeSpace > 8) {
                int oldBucket;
                boolean putIsNeeded;
                int newBucket = AbstractFreeList.this.bucket(newFreeSpace, false);
                boolean bl = putIsNeeded = oldFreeSpace <= 8;
                if (!putIsNeeded && (oldBucket = AbstractFreeList.this.bucket(oldFreeSpace, false)) != newBucket) {
                    pageId = this.maskPartId ? PageIdUtils.maskPartitionId(pageId) : pageId;
                    putIsNeeded = AbstractFreeList.this.removeDataPage(pageId, pageAddr, io, oldBucket, statHolder);
                }
                if (io.isEmpty(pageAddr)) {
                    AbstractFreeList.this.evictionTracker.forgetPage(pageId);
                    if (putIsNeeded) {
                        reuseBag.addFreePage(AbstractFreeList.this.recyclePage(pageId, pageAddr));
                    }
                } else if (putIsNeeded) {
                    AbstractFreeList.this.put(null, pageId, pageAddr, newBucket, statHolder);
                }
            }
            return nextLink;
        }
    }

    private final class WriteRowsHandler
    implements PageHandler<CachedIterator<T>, Integer> {
        private WriteRowsHandler() {
        }

        @Override
        public Integer run(int cacheId, long pageId, long page, long pageAddr, PageIo iox, CachedIterator<T> it, int written, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
            AbstractDataPageIo io = (AbstractDataPageIo)iox;
            while (written != COMPLETE || !AbstractFreeList.this.evictionTracker.evictionRequired() && it.hasNext()) {
                Storable row = (Storable)it.get();
                if (written == COMPLETE) {
                    row = (Storable)it.next();
                    written = AbstractFreeList.this.writeWholePages(row, statHolder);
                    if (written == COMPLETE) continue;
                    if (io.getFreeSpace(pageAddr) < row.size() - written) break;
                }
                written = AbstractFreeList.this.writeRowHnd.addRow(pageId, pageAddr, io, row, written);
                assert (written == COMPLETE);
                AbstractFreeList.this.evictionTracker.touchPage(pageId);
            }
            AbstractFreeList.this.writeRowHnd.putPage(io.getFreeSpace(pageAddr), pageId, pageAddr, statHolder);
            return written;
        }
    }

    private class WriteRowHandler
    implements PageHandler<T, Integer> {
        private WriteRowHandler() {
        }

        @Override
        public Integer run(int cacheId, long pageId, long page, long pageAddr, PageIo iox, T row, int written, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
            written = this.addRow(pageId, pageAddr, iox, row, written);
            this.putPage(((AbstractDataPageIo)iox).getFreeSpace(pageAddr), pageId, pageAddr, statHolder);
            return written;
        }

        protected Integer addRow(long pageId, long pageAddr, PageIo iox, T row, int written) throws IgniteInternalCheckedException {
            AbstractDataPageIo io = (AbstractDataPageIo)iox;
            int rowSize = row.size();
            int oldFreeSpace = io.getFreeSpace(pageAddr);
            assert (oldFreeSpace > 0) : oldFreeSpace;
            int n = written = written == 0 && oldFreeSpace >= rowSize ? this.addRowFull(pageId, pageAddr, io, row, rowSize) : this.addRowFragment(pageId, pageAddr, io, row, written, rowSize);
            if (written == rowSize) {
                AbstractFreeList.this.evictionTracker.touchPage(pageId);
            }
            return written == rowSize ? COMPLETE : written;
        }

        protected int addRowFull(long pageId, long pageAddr, AbstractDataPageIo<T> io, T row, int rowSize) throws IgniteInternalCheckedException {
            io.addRow(pageId, pageAddr, row, rowSize, AbstractFreeList.this.pageSize());
            return rowSize;
        }

        protected int addRowFragment(long pageId, long pageAddr, AbstractDataPageIo<T> io, T row, int written, int rowSize) throws IgniteInternalCheckedException {
            int payloadSize = io.addRowFragment(AbstractFreeList.this.pageMem, pageId, pageAddr, row, written, rowSize, AbstractFreeList.this.pageSize());
            assert (payloadSize > 0) : payloadSize;
            return written + payloadSize;
        }

        protected void putPage(int freeSpace, long pageId, long pageAddr, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
            if (freeSpace > 8) {
                int bucket = AbstractFreeList.this.bucket(freeSpace, false);
                AbstractFreeList.this.put(null, pageId, pageAddr, bucket, statHolder);
            }
        }
    }
}

