/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.direct;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.network.direct.state.DirectMessageState;
import org.apache.ignite.internal.network.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.serialization.MessageWriter;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.jetbrains.annotations.Nullable;

public class DirectMessageWriter
implements MessageWriter {
    private final DirectMessageState<StateItem> state = new DirectMessageState<StateItem>(StateItem.class, () -> new StateItem(serializationService, protoVer));

    public DirectMessageWriter(PerSessionSerializationService serializationService, byte protoVer) {
    }

    public void setBuffer(ByteBuffer buf) {
        this.state.item().stream.setBuffer(buf);
    }

    public void setCurrentWriteClass(Class<? extends NetworkMessage> msgCls) {
    }

    public boolean writeHeader(short groupType, short messageType, byte fieldCnt) {
        DirectByteBufferStream stream = this.state.item().stream;
        if (!this.state.item().partialHdrWritten) {
            stream.writeShort(groupType);
            if (stream.lastFinished()) {
                this.state.item().partialHdrWritten = true;
            } else {
                return false;
            }
        }
        stream.writeShort(messageType);
        return stream.lastFinished();
    }

    public boolean writeByte(String name, byte val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByte(val);
        return stream.lastFinished();
    }

    public boolean writeShort(String name, short val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeShort(val);
        return stream.lastFinished();
    }

    public boolean writeInt(String name, int val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeInt(val);
        return stream.lastFinished();
    }

    public boolean writeLong(String name, long val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLong(val);
        return stream.lastFinished();
    }

    public boolean writeFloat(String name, float val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeFloat(val);
        return stream.lastFinished();
    }

    public boolean writeDouble(String name, double val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeDouble(val);
        return stream.lastFinished();
    }

    public boolean writeChar(String name, char val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeChar(val);
        return stream.lastFinished();
    }

    public boolean writeBoolean(String name, boolean val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoolean(val);
        return stream.lastFinished();
    }

    public boolean writeByteArray(String name, @Nullable byte[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByteArray(val);
        return stream.lastFinished();
    }

    public boolean writeByteArray(String name, byte[] val, long off, int len) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByteArray(val, off, len);
        return stream.lastFinished();
    }

    public boolean writeShortArray(String name, @Nullable short[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeShortArray(val);
        return stream.lastFinished();
    }

    public boolean writeIntArray(String name, @Nullable int[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeIntArray(val);
        return stream.lastFinished();
    }

    public boolean writeLongArray(String name, @Nullable long[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLongArray(val);
        return stream.lastFinished();
    }

    public boolean writeLongArray(String name, long[] val, int len) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLongArray(val, len);
        return stream.lastFinished();
    }

    public boolean writeFloatArray(String name, @Nullable float[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeFloatArray(val);
        return stream.lastFinished();
    }

    public boolean writeDoubleArray(String name, @Nullable double[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeDoubleArray(val);
        return stream.lastFinished();
    }

    public boolean writeCharArray(String name, @Nullable char[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeCharArray(val);
        return stream.lastFinished();
    }

    public boolean writeBooleanArray(String name, @Nullable boolean[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBooleanArray(val);
        return stream.lastFinished();
    }

    public boolean writeString(String name, String val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeString(val);
        return stream.lastFinished();
    }

    public boolean writeBitSet(String name, BitSet val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBitSet(val);
        return stream.lastFinished();
    }

    public boolean writeByteBuffer(String name, ByteBuffer val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByteBuffer(val);
        return stream.lastFinished();
    }

    public boolean writeUuid(String name, UUID val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeUuid(val);
        return stream.lastFinished();
    }

    public boolean writeIgniteUuid(String name, IgniteUuid val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeIgniteUuid(val);
        return stream.lastFinished();
    }

    public boolean writeMessage(String name, @Nullable NetworkMessage msg) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeMessage(msg, this);
        return stream.lastFinished();
    }

    public <T> boolean writeObjectArray(String name, T[] arr, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeObjectArray(arr, itemType, this);
        return stream.lastFinished();
    }

    public <T> boolean writeCollection(String name, Collection<T> col, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeCollection(col, itemType, this);
        return stream.lastFinished();
    }

    public <T> boolean writeList(String name, List<T> col, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeCollection(col, itemType, this);
        return stream.lastFinished();
    }

    public <T> boolean writeSet(String name, Set<T> col, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeSet(col, itemType, this);
        return stream.lastFinished();
    }

    public <K, V> boolean writeMap(String name, Map<K, V> map, MessageCollectionItemType keyType, MessageCollectionItemType valType) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeMap(map, keyType, valType, this);
        return stream.lastFinished();
    }

    public boolean isHeaderWritten() {
        return this.state.item().hdrWritten;
    }

    public void onHeaderWritten() {
        this.state.item().hdrWritten = true;
    }

    public int state() {
        return this.state.item().state;
    }

    public void incrementState() {
        ++this.state.item().state;
    }

    public void beforeInnerMessageWrite() {
        this.state.forward();
    }

    public void afterInnerMessageWrite(boolean finished) {
        this.state.backward(finished);
    }

    public void reset() {
        this.state.reset();
    }

    private static class StateItem
    implements DirectMessageStateItem {
        private final DirectByteBufferStream stream;
        private int state;
        private boolean partialHdrWritten;
        private boolean hdrWritten;

        StateItem(PerSessionSerializationService serializationService, byte protoVer) {
            switch (protoVer) {
                case 1: {
                    this.stream = new DirectByteBufferStreamImplV1(serializationService);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid protocol version: " + protoVer);
                }
            }
        }

        @Override
        public void reset() {
            this.state = 0;
            this.partialHdrWritten = false;
            this.hdrWritten = false;
        }
    }
}

