/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleFormatException;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.jetbrains.annotations.Nullable;

public class BinaryConverter {
    private final SchemaDescriptor descriptor;
    private final BinaryTupleSchema tupleSchema;
    private final boolean skipKey;

    public BinaryConverter(SchemaDescriptor descriptor, BinaryTupleSchema tupleSchema, boolean skipKey) {
        this.descriptor = descriptor;
        this.tupleSchema = tupleSchema;
        this.skipKey = skipKey;
    }

    public static BinaryConverter forRow(SchemaDescriptor descriptor) {
        return new BinaryConverter(descriptor, BinaryTupleSchema.createRowSchema(descriptor), false);
    }

    public static BinaryConverter forKey(SchemaDescriptor descriptor) {
        return new BinaryConverter(descriptor, BinaryTupleSchema.createKeySchema(descriptor), false);
    }

    public static BinaryConverter forValue(SchemaDescriptor descriptor) {
        return new BinaryConverter(descriptor, BinaryTupleSchema.createValueSchema(descriptor), true);
    }

    public BinaryTuple toTuple(BinaryRow binaryRow) {
        RowHelper row = new RowHelper(this.descriptor, binaryRow);
        boolean hasNulls = false;
        int estimatedValueSize = 0;
        for (int elementIndex = 0; elementIndex < this.tupleSchema.elementCount(); ++elementIndex) {
            BinaryTupleSchema.Element elt = this.tupleSchema.element(elementIndex);
            NativeTypeSpec typeSpec = elt.typeSpec;
            int columnIndex = this.tupleSchema.columnIndex(elementIndex);
            if (this.skipKey) {
                columnIndex += this.descriptor.keyColumns().length();
            }
            if (row.hasNullValue(columnIndex, typeSpec)) {
                hasNulls = true;
                continue;
            }
            if (typeSpec.fixedLength()) {
                estimatedValueSize += this.descriptor.column(columnIndex).type().sizeInBytes();
                continue;
            }
            estimatedValueSize += row.getLength(columnIndex, typeSpec);
        }
        BinaryTupleBuilder builder = new BinaryTupleBuilder(this.tupleSchema.elementCount(), hasNulls, estimatedValueSize);
        block17: for (int elementIndex = 0; elementIndex < this.tupleSchema.elementCount(); ++elementIndex) {
            BinaryTupleSchema.Element elt = this.tupleSchema.element(elementIndex);
            NativeTypeSpec typeSpec = elt.typeSpec;
            int columnIndex = this.tupleSchema.columnIndex(elementIndex);
            if (this.skipKey) {
                columnIndex += this.descriptor.keyColumns().length();
            }
            if (row.hasNullValue(columnIndex, typeSpec)) {
                builder.appendNull();
                continue;
            }
            switch (typeSpec) {
                case INT8: {
                    builder.appendByte(row.byteValue(columnIndex));
                    continue block17;
                }
                case INT16: {
                    builder.appendShort(row.shortValue(columnIndex));
                    continue block17;
                }
                case INT32: {
                    builder.appendInt(row.intValue(columnIndex));
                    continue block17;
                }
                case INT64: {
                    builder.appendLong(row.longValue(columnIndex));
                    continue block17;
                }
                case FLOAT: {
                    builder.appendFloat(row.floatValue(columnIndex));
                    continue block17;
                }
                case DOUBLE: {
                    builder.appendDouble(row.doubleValue(columnIndex));
                    continue block17;
                }
                case NUMBER: {
                    builder.appendNumberNotNull(row.numberValue(columnIndex));
                    continue block17;
                }
                case DECIMAL: {
                    builder.appendDecimalNotNull(row.decimalValue(columnIndex), elt.decimalScale);
                    continue block17;
                }
                case STRING: 
                case BYTES: 
                case BITMASK: {
                    row.copyData(builder, columnIndex, typeSpec);
                    continue block17;
                }
                case UUID: {
                    builder.appendUuidNotNull(row.uuidValue(columnIndex));
                    continue block17;
                }
                case DATE: {
                    builder.appendDateNotNull(row.dateValue(columnIndex));
                    continue block17;
                }
                case TIME: {
                    builder.appendTimeNotNull(row.timeValue(columnIndex));
                    continue block17;
                }
                case DATETIME: {
                    builder.appendDateTimeNotNull(row.dateTimeValue(columnIndex));
                    continue block17;
                }
                case TIMESTAMP: {
                    builder.appendTimestampNotNull(row.timestampValue(columnIndex));
                    continue block17;
                }
                default: {
                    throw new InvalidTypeException("Unexpected type value: " + typeSpec);
                }
            }
        }
        return new BinaryTuple(this.tupleSchema, builder.build());
    }

    @Nullable
    public BinaryRow fromTuple(@Nullable byte[] bytes) {
        assert (this.tupleSchema.convertible());
        if (bytes == null) {
            return null;
        }
        return this.fromTuple(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
    }

    @Nullable
    public BinaryRow fromTuple(@Nullable ByteBuffer buffer) {
        assert (this.tupleSchema.convertible());
        if (buffer == null) {
            return null;
        }
        final BinaryTupleParser parser = new BinaryTupleParser(this.tupleSchema.elementCount(), buffer);
        var stats = new BinaryTupleParser.Sink(){
            int nonNullVarLenKeyCols = 0;
            int nonNullVarLenValCols = 0;
            int nonNullVarLenKeySize = 0;
            int nonNullVarLenValSize = 0;

            public void nextElement(int index, int begin, int end) {
                if (begin == 0) {
                    return;
                }
                if (BinaryConverter.this.tupleSchema.element((int)index).typeSpec.fixedLength()) {
                    return;
                }
                int size = end - begin;
                if (BinaryConverter.this.descriptor.isKeyColumn(index)) {
                    ++this.nonNullVarLenKeyCols;
                    this.nonNullVarLenKeySize += size;
                } else {
                    ++this.nonNullVarLenValCols;
                    this.nonNullVarLenValSize += size;
                }
            }
        };
        parser.parse(stats);
        final RowAssembler asm = new RowAssembler(this.descriptor, stats.nonNullVarLenKeySize, stats.nonNullVarLenKeyCols, stats.nonNullVarLenValSize, stats.nonNullVarLenValCols);
        parser.parse(new BinaryTupleParser.Sink(){

            public void nextElement(int index, int begin, int end) {
                if (begin == 0) {
                    asm.appendNull();
                    return;
                }
                BinaryTupleSchema.Element elt = BinaryConverter.this.tupleSchema.element(index);
                switch (elt.typeSpec) {
                    case INT8: {
                        asm.appendByte(parser.byteValue(begin, end));
                        break;
                    }
                    case INT16: {
                        asm.appendShort(parser.shortValue(begin, end));
                        break;
                    }
                    case INT32: {
                        asm.appendInt(parser.intValue(begin, end));
                        break;
                    }
                    case INT64: {
                        asm.appendLong(parser.longValue(begin, end));
                        break;
                    }
                    case FLOAT: {
                        asm.appendFloat(parser.floatValue(begin, end));
                        break;
                    }
                    case DOUBLE: {
                        asm.appendDouble(parser.doubleValue(begin, end));
                        break;
                    }
                    case NUMBER: {
                        asm.appendNumber(parser.numberValue(begin, end));
                        break;
                    }
                    case DECIMAL: {
                        asm.appendDecimal(new BigDecimal(parser.numberValue(begin, end), elt.decimalScale));
                        break;
                    }
                    case STRING: {
                        asm.appendString(parser.stringValue(begin, end));
                        break;
                    }
                    case BYTES: {
                        asm.appendBytes(parser.bytesValue(begin, end));
                        break;
                    }
                    case UUID: {
                        asm.appendUuid(parser.uuidValue(begin, end));
                        break;
                    }
                    case BITMASK: {
                        asm.appendBitmask(parser.bitmaskValue(begin, end));
                        break;
                    }
                    case DATE: {
                        asm.appendDate(parser.dateValue(begin, end));
                        break;
                    }
                    case TIME: {
                        asm.appendTime(parser.timeValue(begin, end));
                        break;
                    }
                    case DATETIME: {
                        asm.appendDateTime(parser.dateTimeValue(begin, end));
                        break;
                    }
                    case TIMESTAMP: {
                        asm.appendTimestamp(parser.timestampValue(begin, end));
                        break;
                    }
                    default: {
                        throw new InvalidTypeException("Unexpected type value: " + elt.typeSpec);
                    }
                }
            }
        });
        return asm.build();
    }

    public static BinaryTupleBuilder appendValue(BinaryTupleBuilder builder, BinaryTupleSchema.Element element, @Nullable Object value) {
        if (value == null) {
            if (!element.nullable()) {
                throw new BinaryTupleFormatException("NULL value for non-nullable column in binary tuple builder.");
            }
            return builder.appendNull();
        }
        switch (element.typeSpec()) {
            case INT8: {
                return builder.appendByte(((Byte)value).byteValue());
            }
            case INT16: {
                return builder.appendShort(((Short)value).shortValue());
            }
            case INT32: {
                return builder.appendInt(((Integer)value).intValue());
            }
            case INT64: {
                return builder.appendLong(((Long)value).longValue());
            }
            case FLOAT: {
                return builder.appendFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return builder.appendDouble(((Double)value).doubleValue());
            }
            case NUMBER: {
                return builder.appendNumberNotNull((BigInteger)value);
            }
            case DECIMAL: {
                return builder.appendDecimalNotNull((BigDecimal)value, element.decimalScale());
            }
            case UUID: {
                return builder.appendUuidNotNull((UUID)value);
            }
            case BYTES: {
                return builder.appendBytesNotNull((byte[])value);
            }
            case STRING: {
                return builder.appendStringNotNull((String)value);
            }
            case BITMASK: {
                return builder.appendBitmaskNotNull((BitSet)value);
            }
            case DATE: {
                return builder.appendDateNotNull((LocalDate)value);
            }
            case TIME: {
                return builder.appendTimeNotNull((LocalTime)value);
            }
            case DATETIME: {
                return builder.appendDateTimeNotNull((LocalDateTime)value);
            }
            case TIMESTAMP: {
                return builder.appendTimestampNotNull((Instant)value);
            }
        }
        throw new InvalidTypeException("Unexpected type value: " + element.typeSpec());
    }

    private class RowHelper
    extends Row {
        RowHelper(SchemaDescriptor descriptor, BinaryRow row) {
            super(descriptor, row);
        }

        int getLength(int colIdx, NativeTypeSpec spec) {
            return (int)(this.findColumn(colIdx, spec, BinaryConverter.this.descriptor.isKeyColumn(colIdx)) >>> 32);
        }

        void copyData(BinaryTupleBuilder builder, int columnIndex, NativeTypeSpec spec) {
            boolean isKeyCol = BinaryConverter.this.descriptor.isKeyColumn(columnIndex);
            ByteBuffer slice = isKeyCol ? this.keySlice() : this.valueSlice();
            long offLen = this.findColumn(columnIndex, spec, isKeyCol);
            int offset = (int)offLen;
            int length = (int)(offLen >>> 32);
            builder.appendElementBytes(slice, offset, length);
        }
    }
}

