/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.sources;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.ignite.internal.metrics.LongGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public class JvmMetricSource
implements MetricSource {
    private static final String SOURCE_NAME = "jvm";
    private static final long MEMORY_USAGE_CACHE_TIMEOUT = 1000L;
    private final MemoryMXBean memoryMxBean;
    private boolean enabled;

    JvmMetricSource(MemoryMXBean memoryMxBean) {
        this.memoryMxBean = memoryMxBean;
    }

    public JvmMetricSource() {
        this.memoryMxBean = ManagementFactory.getMemoryMXBean();
    }

    @Override
    public String name() {
        return SOURCE_NAME;
    }

    @Override
    @Nullable
    public synchronized MetricSet enable() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        CachedMemoryUsage heapMemoryUsage = new CachedMemoryUsage(this.memoryMxBean::getHeapMemoryUsage, 1000L);
        metrics.put("memory.heap.init", new LongGauge("memory.heap.init", "Initial amount of heap memory", () -> heapMemoryUsage.get().getInit()));
        metrics.put("memory.heap.used", new LongGauge("memory.heap.used", "Current used amount of heap memory", () -> heapMemoryUsage.get().getUsed()));
        metrics.put("memory.heap.committed", new LongGauge("memory.heap.committed", "Committed amount of heap memory", () -> heapMemoryUsage.get().getCommitted()));
        metrics.put("memory.heap.max", new LongGauge("memory.heap.max", "Maximum amount of heap memory", () -> heapMemoryUsage.get().getMax()));
        CachedMemoryUsage nonHeapMemoryUsage = new CachedMemoryUsage(this.memoryMxBean::getNonHeapMemoryUsage, 1000L);
        metrics.put("memory.non-heap.init", new LongGauge("memory.non-heap.init", "Initial amount of non-heap memory", () -> nonHeapMemoryUsage.get().getInit()));
        metrics.put("memory.non-heap.used", new LongGauge("memory.non-heap.used", "Used amount of non-heap memory", () -> nonHeapMemoryUsage.get().getUsed()));
        metrics.put("memory.non-heap.committed", new LongGauge("memory.non-heap.committed", "Committed amount of non-heap memory", () -> nonHeapMemoryUsage.get().getCommitted()));
        metrics.put("memory.non-heap.max", new LongGauge("memory.non-heap.max", "Maximum amount of non-heap memory", () -> nonHeapMemoryUsage.get().getMax()));
        this.enabled = true;
        return new MetricSet(SOURCE_NAME, metrics);
    }

    @Override
    public synchronized void disable() {
        this.enabled = false;
    }

    @Override
    public synchronized boolean enabled() {
        return this.enabled;
    }

    private static class CachedMemoryUsage {
        private final Supplier<MemoryUsage> source;
        private final long timeout;
        private volatile long lastUpdateTime;
        private volatile MemoryUsage currentVal;

        private CachedMemoryUsage(Supplier<MemoryUsage> source, long timeout) {
            this.source = source;
            this.timeout = timeout;
            this.update();
        }

        private MemoryUsage get() {
            if (System.currentTimeMillis() - this.lastUpdateTime > this.timeout) {
                this.update();
            }
            return this.currentVal;
        }

        private synchronized void update() {
            this.currentVal = this.source.get();
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

