/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.ErrorTimestampAwareReplicaResponse;
import org.apache.ignite.internal.replicator.message.ErrorTimestampAwareReplicaResponseBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ErrorTimestampAwareReplicaResponseImpl
implements ErrorTimestampAwareReplicaResponse {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private Object result;
    private byte[] resultByteArray;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;
    @IgniteToStringInclude
    private HybridTimestamp timestamp;
    private byte[] timestampByteArray;

    private ErrorTimestampAwareReplicaResponseImpl(Object result, byte[] resultByteArray, Throwable throwable, byte[] throwableByteArray, HybridTimestamp timestamp, byte[] timestampByteArray) {
        this.result = result;
        this.resultByteArray = resultByteArray;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
        this.timestamp = timestamp;
        this.timestampByteArray = timestampByteArray;
    }

    byte[] resultByteArray() {
        return this.resultByteArray;
    }

    @Override
    public Object result() {
        return this.result;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    byte[] timestampByteArray() {
        return this.timestampByteArray;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(ErrorTimestampAwareReplicaResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ErrorTimestampAwareReplicaResponseImpl otherMessage = (ErrorTimestampAwareReplicaResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result) && Objects.equals(this.throwable, otherMessage.throwable) && Objects.equals(this.timestamp, otherMessage.timestamp);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result, this.throwable, this.timestamp);
        return result;
    }

    public static ErrorTimestampAwareReplicaResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject resultByteArraymo = marshaller.marshal(this.result);
        usedDescriptors.addAll((IntCollection)resultByteArraymo.usedDescriptorIds());
        this.resultByteArray = resultByteArraymo.bytes();
        MarshalledObject throwableByteArraymo = marshaller.marshal((Object)this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
        MarshalledObject timestampByteArraymo = marshaller.marshal((Object)this.timestamp);
        usedDescriptors.addAll((IntCollection)timestampByteArraymo.usedDescriptorIds());
        this.timestampByteArray = timestampByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.result = marshaller.unmarshal(this.resultByteArray, descriptorsObj);
        this.resultByteArray = null;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
        this.timestamp = (HybridTimestamp)marshaller.unmarshal(this.timestampByteArray, descriptorsObj);
        this.timestampByteArray = null;
    }

    private static class Builder
    implements ErrorTimestampAwareReplicaResponseBuilder {
        private Object result;
        private byte[] resultByteArray;
        private Throwable throwable;
        private byte[] throwableByteArray;
        private HybridTimestamp timestamp;
        private byte[] timestampByteArray;

        private Builder() {
        }

        @Override
        public ErrorTimestampAwareReplicaResponseBuilder result(Object result) {
            this.result = result;
            return this;
        }

        @Override
        public ErrorTimestampAwareReplicaResponseBuilder resultByteArray(byte[] resultByteArray) {
            this.resultByteArray = resultByteArray;
            return this;
        }

        @Override
        public ErrorTimestampAwareReplicaResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public ErrorTimestampAwareReplicaResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public ErrorTimestampAwareReplicaResponseBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ErrorTimestampAwareReplicaResponseBuilder timestampByteArray(byte[] timestampByteArray) {
            this.timestampByteArray = timestampByteArray;
            return this;
        }

        @Override
        public Object result() {
            return this.result;
        }

        @Override
        public byte[] resultByteArray() {
            return this.resultByteArray;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] timestampByteArray() {
            return this.timestampByteArray;
        }

        @Override
        public ErrorTimestampAwareReplicaResponse build() {
            return new ErrorTimestampAwareReplicaResponseImpl(this.result, this.resultByteArray, this.throwable, this.throwableByteArray, this.timestamp, this.timestampByteArray);
        }
    }
}

