/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.util.Bits;
import org.apache.ignite.raft.jraft.util.Marshaller;
import org.apache.ignite.raft.jraft.util.Utils;

public class MessageFile {
    private final String path;

    public MessageFile(String path) {
        this.path = path;
    }

    public <T extends Message> T load() throws IOException {
        File file = new File(this.path);
        if (!file.exists()) {
            return null;
        }
        byte[] lenBytes = new byte[4];
        try (FileInputStream fin = new FileInputStream(file);){
            Message message;
            try (BufferedInputStream input = new BufferedInputStream(fin);){
                this.readBytes(lenBytes, input);
                int len = Bits.getInt(lenBytes, 0);
                if (len <= 0) {
                    throw new IOException("Invalid message fullName.");
                }
                byte[] nameBytes = new byte[len];
                this.readBytes(nameBytes, input);
                message = (Message)Marshaller.DEFAULT.unmarshall(nameBytes);
            }
            return (T)message;
        }
    }

    private void readBytes(byte[] bs, InputStream input) throws IOException {
        int read = input.read(bs);
        if (read != bs.length) {
            throw new IOException("Read error, expects " + bs.length + " bytes, but read " + read);
        }
    }

    public boolean save(Message msg, boolean sync) throws IOException {
        File file = new File(this.path + ".tmp");
        try (FileOutputStream fOut = new FileOutputStream(file);
             BufferedOutputStream output = new BufferedOutputStream(fOut);){
            byte[] bytes = Marshaller.DEFAULT.marshall(msg);
            byte[] lenBytes = new byte[4];
            Bits.putInt(lenBytes, 0, bytes.length);
            output.write(lenBytes);
            output.write(bytes);
            output.flush();
        }
        if (sync) {
            Utils.fsync(file);
        }
        return Utils.atomicMoveFile(file, new File(this.path), sync);
    }
}

