/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.tx.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.tx.IgniteTransactions;
import org.apache.ignite.tx.Transaction;

/**
 * Transactions facade implementation.
 */
public class IgniteTransactionsImpl implements IgniteTransactions {
    private final TxManager txManager;

    private boolean readOnly = false;

    /**
     * The constructor.
     *
     * @param txManager The manager.
     */
    public IgniteTransactionsImpl(TxManager txManager) {
        this.txManager = txManager;
    }

    /**
     * The constructor.
     *
     * @param txManager The manager.
     * @param readOnly Read-only
     */
    public IgniteTransactionsImpl(TxManager txManager, boolean readOnly) {
        this(txManager);
        this.readOnly = readOnly;
    }

    /** {@inheritDoc} */
    @Override
    public IgniteTransactions withTimeout(long timeout) {
        // TODO: IGNITE-15936.
        throw new UnsupportedOperationException();
    }

    /** {@inheritDoc} */
    @Override
    public IgniteTransactions readOnly() {
        return new IgniteTransactionsImpl(txManager, true);
    }

    /** {@inheritDoc} */
    @Override
    public Transaction begin() {
        return txManager.begin(readOnly);
    }

    /** {@inheritDoc} */
    @Override
    public CompletableFuture<Transaction> beginAsync() {
        return CompletableFuture.completedFuture(txManager.begin(readOnly));
    }
}
