/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentObservable;

class SegmentLockStorage
extends SegmentObservable {
    private final Map<Long, Integer> locked = new ConcurrentHashMap<Long, Integer>();
    private volatile long minLockIdx = -1L;

    SegmentLockStorage() {
    }

    boolean locked(long absIdx) {
        return this.locked.containsKey(absIdx);
    }

    synchronized boolean lockWorkSegment(long absIdx) {
        if (absIdx > this.minLockIdx) {
            this.locked.merge(absIdx, 1, Integer::sum);
            return true;
        }
        return false;
    }

    void releaseWorkSegment(long absIdx) {
        this.locked.compute(absIdx, (idx, count) -> {
            assert (count != null && count >= 1) : "cur=" + count + ", absIdx=" + absIdx;
            return count == 1 ? null : Integer.valueOf(count - 1);
        });
        this.notifyObservers(absIdx);
    }

    synchronized boolean minLockIndex(long absIdx) {
        if (this.locked(absIdx)) {
            return false;
        }
        this.minLockIdx = Math.max(this.minLockIdx, absIdx);
        return true;
    }
}

