/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DateTimeIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.TimestampIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class TimestampInlineIndexKeyType
extends NullableInlineIndexKeyType<TimestampIndexKey> {
    public TimestampInlineIndexKeyType() {
        super(IndexKeyType.TIMESTAMP, (short)16);
    }

    @Override
    public boolean isComparableTo(IndexKey key) {
        return key instanceof DateTimeIndexKey;
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        return -Integer.signum(((DateTimeIndexKey)key).compareTo(PageUtils.getLong(pageAddr, off + 1), PageUtils.getLong(pageAddr, off + 9)));
    }

    @Override
    protected int put0(long pageAddr, int off, TimestampIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putLong(pageAddr, off + 1, key.dateValue());
        PageUtils.putLong(pageAddr, off + 9, key.nanos());
        return this.keySize + 1;
    }

    @Override
    protected TimestampIndexKey get0(long pageAddr, int off) {
        long dv = PageUtils.getLong(pageAddr, off + 1);
        long nanos = PageUtils.getLong(pageAddr, off + 9);
        if (dv > 511999999903L) {
            dv = 511999999903L;
            nanos = 86399999999999L;
        } else if (dv < -511999999455L) {
            dv = -511999999455L;
            nanos = 0L;
        }
        return new TimestampIndexKey(dv, nanos);
    }

    @Override
    protected int inlineSize0(TimestampIndexKey key) {
        return this.keySize + 1;
    }
}

