/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.jdbc.JdbcUtils;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class AbstractJdbcBenchmark
extends IgniteAbstractBenchmark {
    private final List<Connection> threadConnections = new ArrayList<Connection>();
    public static final String JDBC_THIN_AUTO_FIND_PREFIX = "jdbc:ignite:thin://auto.find";
    protected String url;
    protected ThreadLocal<Connection> conn = new ThreadLocal<Connection>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Connection initialValue() {
            try {
                Connection conn = AbstractJdbcBenchmark.this.connection(AbstractJdbcBenchmark.this.url);
                List<Connection> list = AbstractJdbcBenchmark.this.threadConnections;
                synchronized (list) {
                    AbstractJdbcBenchmark.this.threadConnections.add(conn);
                }
                return conn;
            }
            catch (SQLException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    };

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.ignite().cluster().state(ClusterState.ACTIVE);
        if (this.url == null) {
            if (this.args.jdbcUrl().startsWith(JDBC_THIN_AUTO_FIND_PREFIX)) {
                String addr = this.findThinAddress();
                this.url = "jdbc:ignite:thin://" + addr + "/";
            } else {
                this.url = this.args.jdbcUrl();
            }
        }
        BenchmarkUtils.println((String)("Using jdbc url:" + this.url));
        this.setupData();
        this.ignite().close();
    }

    protected void setupData() throws Exception {
        JdbcUtils.fillData(this.cfg, (IgniteEx)this.ignite(), this.args.range(), this.args.atomicMode());
    }

    private String findThinAddress() {
        for (ClusterNode n : this.ignite().cluster().forClients().nodes()) {
            if (n.isLocal()) continue;
            for (String addr : n.addresses()) {
                if (addr.equals("127.0.0.1") || addr.equals("localhost") || addr.equals("172.17.0.1")) continue;
                BenchmarkUtils.println((String)("Found remote node: " + addr));
                return addr;
            }
            BenchmarkUtils.println((String)"Found another client node on localhost");
            return "127.0.0.1";
        }
        throw new RuntimeException("Setup exception: could not find non-local node, check your setup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        List<Connection> list = this.threadConnections;
        synchronized (list) {
            for (Connection conn : this.threadConnections) {
                U.closeQuiet((AutoCloseable)conn);
            }
            this.threadConnections.clear();
        }
        super.tearDown();
    }

    protected final Connection connection(String url) throws SQLException {
        BenchmarkUtils.println((String)("JDBC connect to: " + url));
        Connection conn = DriverManager.getConnection(url);
        conn.setSchema("PUBLIC");
        return conn;
    }

    final ThreadLocal<PreparedStatement> newStatement(final String sql) {
        return new ThreadLocal<PreparedStatement>(){

            @Override
            protected PreparedStatement initialValue() {
                try {
                    return AbstractJdbcBenchmark.this.conn.get().prepareStatement(sql);
                }
                catch (SQLException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        };
    }
}

