/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.dml;

import java.util.Arrays;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public class IgniteSqlMergeAllBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private Affinity<Integer> aff;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.aff = this.ignite().affinity("query");
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        Object[] vals = new Object[this.args.batch() * 2];
        ClusterNode node = this.args.collocated() ? this.aff.mapKeyToNode((Object)IgniteSqlMergeAllBenchmark.nextRandom(this.args.range())) : null;
        StringBuilder qry = new StringBuilder("merge into Integer(_key, _val) values ");
        int j = 0;
        int i = 0;
        while (i < this.args.batch()) {
            int key = IgniteSqlMergeAllBenchmark.nextRandom(this.args.range());
            if (this.args.collocated() && !this.aff.isPrimary(node, (Object)key)) continue;
            ++i;
            vals[j++] = key;
            vals[j++] = key;
            qry.append("(?, ?),");
        }
        Arrays.sort(vals);
        qry = qry.deleteCharAt(qry.length() - 1);
        this.cache.query(new SqlFieldsQuery(qry.toString()).setArgs(vals));
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query");
    }
}

