/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectAdapter;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class KeyCacheObjectImpl
extends CacheObjectAdapter
implements KeyCacheObject {
    private static final long serialVersionUID = 0L;
    private int part = -1;

    public KeyCacheObjectImpl() {
    }

    public KeyCacheObjectImpl(Object val, byte[] valBytes, int part) {
        assert (val != null);
        this.val = val;
        this.valBytes = valBytes;
        this.part = part;
    }

    @Override
    public KeyCacheObject copy(int part) {
        if (this.part == part) {
            return this;
        }
        return new KeyCacheObjectImpl(this.val, this.valBytes, part);
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public void partition(int part) {
        this.part = part;
    }

    @Override
    public byte[] valueBytes(CacheObjectValueContext ctx) throws IgniteCheckedException {
        if (this.valBytes == null) {
            this.valBytes = ctx.kernalContext().cacheObjects().marshal(ctx, this.val);
        }
        return this.valBytes;
    }

    @Override
    public boolean internal() {
        assert (this.val != null);
        return this.val instanceof GridCacheInternal;
    }

    @Override
    public boolean isPlatformType() {
        return true;
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy) {
        return this.value(ctx, cpy, null);
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy, ClassLoader ldr) {
        assert (this.val != null);
        return (T)this.val;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        return this;
    }

    @Override
    public int hashCode() {
        assert (this.val != null);
        return IgniteUtils.hashCode(this.val);
    }

    @Override
    public short directType() {
        return 90;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 1: {
                this.part = reader.readInt("part");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(KeyCacheObjectImpl.class);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 1: {
                if (!writer.writeInt("part", this.part)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public void prepareMarshal(CacheObjectValueContext ctx) throws IgniteCheckedException {
        if (this.valBytes == null) {
            this.valBytes = ctx.kernalContext().cacheObjects().marshal(ctx, this.val);
        }
    }

    @Override
    public void finishUnmarshal(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (this.val == null) {
            assert (this.valBytes != null);
            this.val = ctx.kernalContext().cacheObjects().unmarshal(ctx, this.valBytes, ldr);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyCacheObjectImpl)) {
            return false;
        }
        KeyCacheObjectImpl other = (KeyCacheObjectImpl)obj;
        return Objects.deepEquals(this.val, other.val);
    }

    @Override
    public String toString() {
        return S.toString(S.includeSensitive() ? this.getClass().getSimpleName() : "KeyCacheObject", "part", (Object)this.part, true, "val", this.val, true, "hasValBytes", (Object)(this.valBytes != null ? 1 : 0), false);
    }
}

