/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.loadbalancer;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeLoadBalancer;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.loadbalancer.GridLoadBalancerAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.loadbalancing.LoadBalancingSpi;
import org.apache.ignite.spi.loadbalancing.roundrobin.RoundRobinLoadBalancingSpi;
import org.jetbrains.annotations.Nullable;

public class GridLoadBalancerManager
extends GridManagerAdapter<LoadBalancingSpi> {
    public GridLoadBalancerManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])ctx.config().getLoadBalancingSpi());
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.startSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public ClusterNode getBalancedNode(GridTaskSessionImpl ses, List<ClusterNode> top, ComputeJob job) throws IgniteException {
        assert (ses != null);
        assert (top != null);
        assert (job != null);
        LoadBalancingSpi spi = (LoadBalancingSpi)this.getSpi(ses.getLoadBalancingSpi());
        if (ses.isInternal() && !(spi instanceof RoundRobinLoadBalancingSpi)) {
            return ((LoadBalancingSpi)this.getSpi(RoundRobinLoadBalancingSpi.class.getSimpleName())).getBalancedNode(ses, top, job);
        }
        return spi.getBalancedNode(ses, top, job);
    }

    public ComputeLoadBalancer getLoadBalancer(final GridTaskSessionImpl ses, final List<ClusterNode> top) {
        assert (ses != null);
        return new GridLoadBalancerAdapter(){

            @Override
            @Nullable
            public ClusterNode getBalancedNode(ComputeJob job, @Nullable Collection<ClusterNode> exclNodes) {
                A.notNull(job, "job");
                if (F.isEmpty(exclNodes)) {
                    return GridLoadBalancerManager.this.getBalancedNode(ses, top, job);
                }
                List<ClusterNode> nodes = F.loseList(top, true, exclNodes);
                if (nodes.isEmpty()) {
                    return null;
                }
                return GridLoadBalancerManager.this.getBalancedNode(ses, nodes, job);
            }
        };
    }
}

