/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.management.cache.CacheIdleVerifyCommandArg;
import org.apache.ignite.internal.management.cache.IdleVerifyException;
import org.apache.ignite.internal.management.cache.IdleVerifyResultV2;
import org.apache.ignite.internal.management.cache.NoMatchingCachesException;
import org.apache.ignite.internal.management.cache.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.verify.GridNotIdleException;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyUtility;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VerifyBackupPartitionsTaskV2
extends ComputeTaskAdapter<CacheIdleVerifyCommandArg, IdleVerifyResultV2> {
    public static final IgniteProductVersion V2_SINCE_VER = IgniteProductVersion.fromString("2.5.3");
    public static final String IDLE_VERIFY_ON_INACTIVE_CLUSTER_ERROR_MESSAGE = "Cannot perform the operation because the cluster is inactive.";
    @LoggerResource
    private IgniteLogger log;
    private static final long serialVersionUID = 0L;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, CacheIdleVerifyCommandArg arg) throws IgniteException {
        HashMap<VerifyBackupPartitionsJobV2, ClusterNode> jobs = new HashMap<VerifyBackupPartitionsJobV2, ClusterNode>();
        for (ClusterNode node : subgrid) {
            jobs.put(new VerifyBackupPartitionsJobV2(arg), node);
        }
        return jobs;
    }

    @Override
    @Nullable
    public IdleVerifyResultV2 reduce(List<ComputeJobResult> results) throws IgniteException {
        return VerifyBackupPartitionsTaskV2.reduce0(results);
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        try {
            ComputeJobResultPolicy superRes = super.result(res, rcvd);
            if (superRes == ComputeJobResultPolicy.FAILOVER) {
                superRes = ComputeJobResultPolicy.WAIT;
                if (this.log != null) {
                    this.log.warning("VerifyBackupPartitionsJobV2 failed on node [consistentId=" + res.getNode().consistentId() + "]", res.getException());
                }
            }
            return superRes;
        }
        catch (IgniteException e) {
            return ComputeJobResultPolicy.WAIT;
        }
    }

    public static IdleVerifyResultV2 reduce0(List<ComputeJobResult> results) {
        HashMap<PartitionKeyV2, List<PartitionHashRecordV2>> clusterHashes = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        HashMap<ClusterNode, Exception> ex = new HashMap<ClusterNode, Exception>();
        for (ComputeJobResult res : results) {
            if (res.getException() != null) {
                ex.put(res.getNode(), res.getException());
                continue;
            }
            Map nodeHashes = (Map)res.getData();
            for (Map.Entry e : nodeHashes.entrySet()) {
                List records = clusterHashes.computeIfAbsent((PartitionKeyV2)e.getKey(), k -> new ArrayList());
                records.add((PartitionHashRecordV2)e.getValue());
            }
        }
        if (results.size() != ex.size()) {
            return new IdleVerifyResultV2(clusterHashes, ex);
        }
        return new IdleVerifyResultV2(ex);
    }

    private static class VerifyBackupPartitionsJobV2
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private CacheIdleVerifyCommandArg arg;
        private final AtomicInteger completionCntr = new AtomicInteger(0);

        public VerifyBackupPartitionsJobV2(CacheIdleVerifyCommandArg arg) {
            this.arg = arg;
        }

        @Override
        public Map<PartitionKeyV2, PartitionHashRecordV2> execute() throws IgniteException {
            if (!this.ignite.context().state().publicApiActiveState(true)) {
                throw new IgniteException(VerifyBackupPartitionsTaskV2.IDLE_VERIFY_ON_INACTIVE_CLUSTER_ERROR_MESSAGE);
            }
            try {
                this.ignite.context().cache().context().database().waitForCheckpoint("VerifyBackupPartitions");
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to wait for checkpoint before executing verify backup partitions task", e);
            }
            Set<Integer> grpIds = this.getGroupIds();
            if (this.log.isInfoEnabled()) {
                this.log.info("Idle verify procedure has started [skipZeros=" + this.arg.skipZeros() + ", checkCrc=" + this.arg.checkCrc() + ", grpIds=" + grpIds + "]");
            }
            this.completionCntr.set(0);
            List<Future<Map<PartitionKeyV2, PartitionHashRecordV2>>> partHashCalcFuts = this.calcPartitionHashAsync(grpIds);
            HashMap<PartitionKeyV2, PartitionHashRecordV2> res = new HashMap<PartitionKeyV2, PartitionHashRecordV2>();
            ArrayList<IgniteException> exceptions = new ArrayList<IgniteException>();
            long lastProgressLogTs = U.currentTimeMillis();
            int i = 0;
            while (i < partHashCalcFuts.size()) {
                Future<Map<PartitionKeyV2, PartitionHashRecordV2>> fut = partHashCalcFuts.get(i);
                try {
                    Map<PartitionKeyV2, PartitionHashRecordV2> partHash = fut.get(100L, TimeUnit.MILLISECONDS);
                    res.putAll(partHash);
                    ++i;
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e.getCause() instanceof IgniteException && !(e.getCause() instanceof GridNotIdleException)) {
                        exceptions.add((IgniteException)e.getCause());
                        ++i;
                        continue;
                    }
                    for (int j = i + 1; j < partHashCalcFuts.size(); ++j) {
                        partHashCalcFuts.get(j).cancel(false);
                    }
                    if (e instanceof InterruptedException) {
                        throw new IgniteInterruptedException((InterruptedException)e);
                    }
                    throw new IgniteException(e.getCause());
                }
                catch (TimeoutException ignored) {
                    if (U.currentTimeMillis() - lastProgressLogTs <= 180000L) continue;
                    lastProgressLogTs = U.currentTimeMillis();
                    this.log.warning("idle_verify is still running, processed " + this.completionCntr.get() + " of " + partHashCalcFuts.size() + " local partitions");
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Idle verify procedure has finished.");
            }
            if (!F.isEmpty(exceptions)) {
                throw new IdleVerifyException(exceptions);
            }
            return res;
        }

        private List<Future<Map<PartitionKeyV2, PartitionHashRecordV2>>> calcPartitionHashAsync(Set<Integer> grpIds) {
            ArrayList<Future<Map<PartitionKeyV2, PartitionHashRecordV2>>> partHashCalcFutures = new ArrayList<Future<Map<PartitionKeyV2, PartitionHashRecordV2>>>();
            for (Integer grpId : grpIds) {
                CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(grpId);
                if (grpCtx == null) continue;
                List<GridDhtLocalPartition> parts = grpCtx.topology().localPartitions();
                for (GridDhtLocalPartition part : parts) {
                    partHashCalcFutures.add(this.calculatePartitionHashAsync(grpCtx, part));
                }
            }
            return partHashCalcFutures;
        }

        private Set<Integer> getGroupIds() {
            Collection<CacheGroupContext> cacheGrps = this.ignite.context().cache().cacheGroups();
            Set<Integer> grpIds = new CachesFiltering(cacheGrps).filter(this::filterByCacheNames).filter(this::filterByCacheFilter).filter(this::filterByExcludeCaches).result();
            if (F.isEmpty(grpIds)) {
                throw new NoMatchingCachesException();
            }
            return grpIds;
        }

        private void filterByExcludeCaches(Set<CacheGroupContext> cachesToFilter) {
            if (!F.isEmpty(this.arg.excludeCaches())) {
                HashSet<Pattern> excludedNamesPatterns = new HashSet<Pattern>();
                for (String excluded : this.arg.excludeCaches()) {
                    excludedNamesPatterns.add(Pattern.compile(excluded));
                }
                cachesToFilter.removeIf(grp -> this.doesGrpMatchOneOfPatterns((CacheGroupContext)grp, (Set<Pattern>)excludedNamesPatterns));
            }
        }

        private void filterByCacheFilter(Set<CacheGroupContext> cachesToFilter) {
            cachesToFilter.removeIf(grp -> !this.doesGrpMatchFilter((CacheGroupContext)grp));
        }

        private void filterByCacheNames(Set<CacheGroupContext> cachesToFilter) {
            if (!F.isEmpty(this.arg.caches())) {
                HashSet<Pattern> cacheNamesPatterns = new HashSet<Pattern>();
                for (String cacheNameRegexp : this.arg.caches()) {
                    cacheNamesPatterns.add(Pattern.compile(cacheNameRegexp));
                }
                cachesToFilter.removeIf(grp -> !this.doesGrpMatchOneOfPatterns((CacheGroupContext)grp, (Set<Pattern>)cacheNamesPatterns));
            }
        }

        private boolean doesGrpMatchFilter(CacheGroupContext grp) {
            for (GridCacheContext<?, ?> cacheCtx : grp.caches()) {
                DynamicCacheDescriptor desc = this.ignite.context().cache().cacheDescriptor(cacheCtx.name());
                if (!this.isCacheMatchFilter(desc)) continue;
                return true;
            }
            return false;
        }

        private boolean doesGrpMatchOneOfPatterns(CacheGroupContext grp, Set<Pattern> patterns) {
            for (Pattern pattern : patterns) {
                if (grp.name() != null && pattern.matcher(grp.name()).matches()) {
                    return true;
                }
                for (GridCacheContext<?, ?> cacheCtx : grp.caches()) {
                    if (cacheCtx.name() == null || !pattern.matcher(cacheCtx.name()).matches()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isCacheMatchFilter(DynamicCacheDescriptor desc) {
            DataStorageConfiguration dsCfg = this.ignite.context().config().getDataStorageConfiguration();
            CacheConfiguration cc = desc.cacheConfiguration();
            switch (this.arg.cacheFilter()) {
                case DEFAULT: {
                    return desc.cacheType().userCache() || !F.isEmpty(this.arg.caches());
                }
                case USER: {
                    return desc.cacheType().userCache();
                }
                case SYSTEM: {
                    return !desc.cacheType().userCache();
                }
                case NOT_PERSISTENT: {
                    return desc.cacheType().userCache() && !GridCacheUtils.isPersistentCache(cc, dsCfg);
                }
                case PERSISTENT: {
                    return desc.cacheType().userCache() && GridCacheUtils.isPersistentCache(cc, dsCfg);
                }
                case ALL: {
                    return true;
                }
            }
            throw new IgniteException("Illegal cache filter: " + this.arg.cacheFilter());
        }

        private Future<Map<PartitionKeyV2, PartitionHashRecordV2>> calculatePartitionHashAsync(CacheGroupContext gctx, GridDhtLocalPartition part) {
            return ForkJoinPool.commonPool().submit(() -> {
                Map<Object, Object> res = Collections.emptyMap();
                if (!part.reserve()) {
                    return res;
                }
                try {
                    PartitionUpdateCounter updateCntrAfter;
                    PartitionKeyV2 key;
                    PartitionHashRecordV2 hash;
                    PartitionUpdateCounter updateCntrBefore;
                    PartitionUpdateCounter updCntr = part.dataStore().partUpdateCounter();
                    PartitionUpdateCounter partitionUpdateCounter = updateCntrBefore = updCntr == null ? null : updCntr.copy();
                    if (this.arg.checkCrc() && gctx.persistenceEnabled()) {
                        FilePageStoreManager pageStoreMgr = (FilePageStoreManager)this.ignite.context().cache().context().pageStore();
                        IdleVerifyUtility.checkPartitionsPageCrcSum(() -> (FilePageStore)pageStoreMgr.getStore(gctx.groupId(), part.id()), part.id(), (byte)1);
                    }
                    if ((hash = IdleVerifyUtility.calculatePartitionHash(key = new PartitionKeyV2(gctx.groupId(), part.id(), gctx.cacheOrGroupName()), updateCntrBefore == null ? Integer.valueOf(0) : updateCntrBefore.comparableState(), this.ignite.context().discovery().localNode().consistentId(), part.state(), part.primary(gctx.topology().readyTopologyVersion()), part.dataStore().fullSize(), gctx.offheap().partitionIterator(part.id()))) != null) {
                        res = Collections.singletonMap(key, hash);
                    }
                    if ((updateCntrAfter = part.dataStore().partUpdateCounter()) != null && !updateCntrAfter.equals(updateCntrBefore)) {
                        throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [grpName=" + gctx.cacheOrGroupName() + ", grpId=" + gctx.groupId() + ", partId=" + part.id() + "] changed during size calculation [updCntrBefore=" + updateCntrBefore + ", updCntrAfter=" + updateCntrAfter + "]");
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Can't calculate partition hash [grpId=" + gctx.groupId() + ", partId=" + part.id() + "]", e);
                    throw new IgniteException("Can't calculate partition hash [grpId=" + gctx.groupId() + ", partId=" + part.id() + "]", e);
                }
                finally {
                    part.release();
                }
                this.completionCntr.incrementAndGet();
                return res;
            });
        }

        private class CachesFiltering {
            private final Set<CacheGroupContext> filteredCacheGroups;

            public CachesFiltering(Collection<CacheGroupContext> cacheGroups) {
                this.filteredCacheGroups = new HashSet<CacheGroupContext>(cacheGroups);
            }

            public CachesFiltering filter(IgniteInClosure<Set<CacheGroupContext>> closure) {
                closure.apply(this.filteredCacheGroups);
                return this;
            }

            public Set<Integer> result() {
                HashSet<Integer> res = new HashSet<Integer>();
                for (CacheGroupContext cacheGrp : this.filteredCacheGroups) {
                    res.add(cacheGrp.groupId());
                }
                return res;
            }
        }
    }
}

