/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.report.jfreechart;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.probes.PercentileProbe;
import org.yardstickframework.probes.ThroughputLatencyProbe;
import org.yardstickframework.report.jfreechart.JFreeChartGenerationMode;
import org.yardstickframework.report.jfreechart.JFreeChartGraphPlotter;
import org.yardstickframework.report.jfreechart.JFreeChartGraphPlotterArguments;
import org.yardstickframework.report.jfreechart.JFreeChartPlotInfo;
import org.yardstickframework.writers.BenchmarkProbePointCsvWriter;

public class JFreeChartResultPageGenerator {
    public static final NumberFormat NUMBER_INSTANCE = NumberFormat.getNumberInstance(Locale.US);

    public static void generate(File inFolder, JFreeChartGraphPlotterArguments args, Map<String, List<JFreeChartPlotInfo>> infoMap) {
        for (File folder : JFreeChartResultPageGenerator.folders(inFolder)) {
            Map<String, List<File>> files = JFreeChartResultPageGenerator.files(folder.listFiles());
            if (files.isEmpty()) continue;
            int i = folder.getName().lastIndexOf(45);
            Date testTime = null;
            if (i != -1) {
                try {
                    testTime = BenchmarkProbePointCsvWriter.FORMAT.parse(folder.getName().substring(0, i));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            JFreeChartResultPageGenerator.generateHtml(testTime, files, folder, args, infoMap);
        }
    }

    private static Collection<File> folders(File folder) {
        File[] dirs = folder.listFiles();
        if (dirs == null || dirs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> res = new ArrayList<File>();
        res.add(folder);
        for (File dir : dirs) {
            if (!dir.isDirectory()) continue;
            res.add(dir);
        }
        return res;
    }

    private static Map<String, List<File>> files(File[] files) {
        TreeMap<String, List<File>> res = new TreeMap<String, List<File>>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                String probe2;
                String probe1 = s1.trim().toLowerCase();
                if (probe1.equals(probe2 = s2.trim().toLowerCase())) {
                    return 0;
                }
                String throughputLatency = ThroughputLatencyProbe.class.getSimpleName().toLowerCase();
                if (probe1.equals(throughputLatency)) {
                    return -1;
                }
                if (probe2.equals(throughputLatency)) {
                    return 1;
                }
                return probe1.compareTo(probe2);
            }
        });
        for (File file : files) {
            if (!file.getName().endsWith(".png")) continue;
            String[] tokens = file.getName().split("_");
            if (tokens.length < 3) {
                JFreeChartGraphPlotter.errorHelp("Incorrect file name: " + file.getAbsolutePath());
                continue;
            }
            ArrayList<File> list = (ArrayList<File>)res.get(tokens[1]);
            if (list == null) {
                list = new ArrayList<File>();
                res.put(tokens[1], list);
            }
            list.add(file);
        }
        for (List list : res.values()) {
            Collections.sort(list, JFreeChartGraphPlotter.FILE_NAME_COMP);
        }
        return res;
    }

    private static void generateHtml(Date testTime, Map<String, List<File>> fileMap, File outFolder, JFreeChartGraphPlotterArguments args, Map<String, List<JFreeChartPlotInfo>> infoMap) {
        File outFile = new File(outFolder, "Results.html");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile)));){
            File f;
            List<JFreeChartPlotInfo> list;
            JFreeChartResultPageGenerator.writeLine(bw, "<!DOCTYPE html>");
            JFreeChartResultPageGenerator.writeLine(bw, "<html lang=\"en\">");
            JFreeChartResultPageGenerator.writeLine(bw, "<head>");
            JFreeChartResultPageGenerator.writeLine(bw, "<meta charset=\"utf-8\">");
            JFreeChartResultPageGenerator.writeLine(bw, "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
            JFreeChartResultPageGenerator.writeLine(bw, "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            JFreeChartResultPageGenerator.writeLine(bw, "<link rel=\"stylesheet\" href=\"http://netdna.bootstrapcdn.com/bootstrap/3.1.1/css/bootstrap.min.css\">");
            JFreeChartResultPageGenerator.writeLine(bw, "<link rel=\"stylesheet\" href=\"http://netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css\">");
            JFreeChartResultPageGenerator.writeLine(bw, "<script src=\"http://code.jquery.com/jquery-1.11.0.min.js\"></script>");
            JFreeChartResultPageGenerator.writeLine(bw, "<script src=\"http://netdna.bootstrapcdn.com/bootstrap/3.1.1/js/bootstrap.min.js\"></script>");
            JFreeChartResultPageGenerator.writeLine(bw, "</head>");
            JFreeChartResultPageGenerator.writeLine(bw, "<body>");
            JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"container-fluid\">");
            JFreeChartResultPageGenerator.writeLine(bw, "<img src=\"http://www.gridgain.com/images/yardstick/yardstick-logo-no-background-200x85px-rgb.png\"/>");
            JFreeChartGenerationMode mode = JFreeChartResultPageGenerator.generationMode(fileMap, infoMap);
            String modeAsString = mode == null || mode == JFreeChartGenerationMode.STANDARD ? "" : mode.name().charAt(0) + mode.name().substring(1, mode.name().length()).toLowerCase() + ' ';
            String timeAsString = testTime == null ? "" : "<small> on " + testTime + "</small>";
            JFreeChartResultPageGenerator.writeLine(bw, "<h3>Benchmark " + modeAsString + "Results" + timeAsString + "</h3>");
            Iterator<List<File>> iter = fileMap.values().iterator();
            if (iter.hasNext() && (list = infoMap.get((f = iter.next().get(0)).getAbsolutePath())) != null) {
                JFreeChartResultPageGenerator.writeLine(bw, "<table class=\"table\" style=\"width:auto;\">");
                JFreeChartResultPageGenerator.writeLine(bw, "<thead><tr><th>Color</th><th>Benchmark</th><th>Configurations</th></tr></thead>");
                JFreeChartResultPageGenerator.writeLine(bw, "<tbody>");
                for (JFreeChartPlotInfo info : list) {
                    String t = JFreeChartGraphPlotter.parseTime(info.name());
                    String b = t == null ? info.name() : info.name().substring(t.length() + 1);
                    StringBuilder cfgSb = new StringBuilder();
                    for (String cfg : info.configuration()) {
                        t = JFreeChartGraphPlotter.parseTime(cfg);
                        if (t != null) {
                            cfg = cfg.substring(t.length() + 1);
                        }
                        cfgSb.append(cfg).append("<br>");
                    }
                    JFreeChartResultPageGenerator.writeLine(bw, "<tr>");
                    JFreeChartResultPageGenerator.writeLine(bw, "<td><i style=\"color:#" + info.color() + ";\" class=\"fa fa-square\"></i></td>");
                    JFreeChartResultPageGenerator.writeLine(bw, "<td>" + b.replaceAll(",", "<br>") + "</td>");
                    JFreeChartResultPageGenerator.writeLine(bw, "<td>" + cfgSb + "</td>");
                    JFreeChartResultPageGenerator.writeLine(bw, "</tr>");
                }
                JFreeChartResultPageGenerator.writeLine(bw, "</tbody>");
                JFreeChartResultPageGenerator.writeLine(bw, "</table>");
            }
            int id = 0;
            for (Map.Entry<String, List<File>> entry : fileMap.entrySet()) {
                List<File> files = entry.getValue();
                int columnCount = args.chartColumns();
                JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"panel panel-default\">");
                JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"panel-heading\"><h2 class=\"panel-title\">" + entry.getKey() + "</h2></div>");
                JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"panel-body\">");
                for (int start = 0; start < files.size(); start += columnCount) {
                    int end = Math.min(start + columnCount, files.size());
                    List<File> sublist = files.subList(start, end);
                    JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"row\">");
                    for (File file : sublist) {
                        JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"col-md-4\">");
                        JFreeChartResultPageGenerator.writeLine(bw, "<a data-toggle=\"modal\" data-target=\"#" + id + "\" href=\"#\"><img src=\"" + file.getName() + "\" class=\"img-thumbnail\"/></a>");
                        JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"modal\" id=\"" + id + "\" tabindex=\"-1\" role=\"dialog\" aria-hidden=\"true\">");
                        JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"modal-dialog modal-lg\">");
                        JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"modal-content\">");
                        JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"modal-body text-center\">");
                        JFreeChartResultPageGenerator.writeLine(bw, "<img src=\"" + file.getName() + "\" class=\"img-thumbnail\"/>");
                        JFreeChartResultPageGenerator.writeLine(bw, "<p>&nbsp;</p>");
                        if (!file.getName().contains(PercentileProbe.class.getSimpleName())) {
                            JFreeChartResultPageGenerator.buildGraphDetailTable(infoMap, bw, file);
                        }
                        JFreeChartResultPageGenerator.writeLine(bw, "</div>");
                        JFreeChartResultPageGenerator.writeLine(bw, "<div class=\"modal-footer\">");
                        JFreeChartResultPageGenerator.writeLine(bw, "<button type=\"button\" class=\"btn btn-primary\" data-dismiss=\"modal\">Close</button>");
                        JFreeChartResultPageGenerator.writeLine(bw, "</div>");
                        JFreeChartResultPageGenerator.writeLine(bw, "</div>");
                        JFreeChartResultPageGenerator.writeLine(bw, "</div>");
                        JFreeChartResultPageGenerator.writeLine(bw, "</div>");
                        if (!file.getName().contains(PercentileProbe.class.getSimpleName())) {
                            JFreeChartResultPageGenerator.buildGraphDetailTable(infoMap, bw, file);
                        }
                        JFreeChartResultPageGenerator.writeLine(bw, "</div>");
                        ++id;
                    }
                    JFreeChartResultPageGenerator.writeLine(bw, "</div>");
                }
                JFreeChartResultPageGenerator.writeLine(bw, "</div>");
                JFreeChartResultPageGenerator.writeLine(bw, "</div>");
            }
            JFreeChartResultPageGenerator.writeLine(bw, "</div>");
            JFreeChartResultPageGenerator.writeLine(bw, "</body>");
            JFreeChartResultPageGenerator.writeLine(bw, "</html>");
            BenchmarkUtils.println("Html file is generated: ", outFile);
        }
        catch (Exception e) {
            JFreeChartGraphPlotter.errorHelp("Exception is raised during file processing: " + outFile.getAbsolutePath(), e);
        }
    }

    private static void buildGraphDetailTable(Map<String, List<JFreeChartPlotInfo>> infoMap, BufferedWriter bw, File file) throws IOException {
        JFreeChartResultPageGenerator.writeLine(bw, "<table class=\"table table-condensed\">");
        JFreeChartResultPageGenerator.writeLine(bw, "<thead>");
        JFreeChartResultPageGenerator.writeLine(bw, "<tr>");
        JFreeChartResultPageGenerator.writeLine(bw, "<th></th>");
        JFreeChartResultPageGenerator.writeLine(bw, "<th class=\"text-left\">Avg</th>");
        JFreeChartResultPageGenerator.writeLine(bw, "<th class=\"text-left\">Min</th>");
        JFreeChartResultPageGenerator.writeLine(bw, "<th class=\"text-left\">Max</th>");
        JFreeChartResultPageGenerator.writeLine(bw, "<th class=\"text-left\">SD</th>");
        JFreeChartResultPageGenerator.writeLine(bw, "</tr>");
        JFreeChartResultPageGenerator.writeLine(bw, "</thead>");
        JFreeChartResultPageGenerator.writeLine(bw, "<tbody>");
        List<JFreeChartPlotInfo> list = infoMap.get(file.getAbsolutePath());
        if (list != null) {
            for (JFreeChartPlotInfo info : list) {
                JFreeChartResultPageGenerator.writeLine(bw, "<tr>");
                JFreeChartResultPageGenerator.writeLine(bw, "<td><i style=\"color:#" + info.color() + ";\" class=\"fa fa-square\"></i></td>");
                JFreeChartResultPageGenerator.writeValueToTable(bw, info.average());
                JFreeChartResultPageGenerator.writeValueToTable(bw, info.minimum());
                JFreeChartResultPageGenerator.writeValueToTable(bw, info.maximum());
                JFreeChartResultPageGenerator.writeValueToTable(bw, info.standardDeviation());
                JFreeChartResultPageGenerator.writeLine(bw, "</tr>");
            }
        }
        JFreeChartResultPageGenerator.writeLine(bw, "</tbody>");
        JFreeChartResultPageGenerator.writeLine(bw, "</table>");
    }

    private static JFreeChartGenerationMode generationMode(Map<String, List<File>> fileMap, Map<String, List<JFreeChartPlotInfo>> infoMap) {
        File f;
        List<JFreeChartPlotInfo> list;
        Iterator<List<File>> iter = fileMap.values().iterator();
        if (iter.hasNext() && (list = infoMap.get((f = iter.next().get(0)).getAbsolutePath())) != null && !list.isEmpty()) {
            return list.get(0).mode();
        }
        return null;
    }

    private static void writeValueToTable(BufferedWriter bw, double val) throws IOException {
        String s = Double.isNaN(val) ? "NaN" : (Double.isInfinite(val) ? "Inf" : NUMBER_INSTANCE.format(val));
        JFreeChartResultPageGenerator.writeLine(bw, "<td class=\"text-left\">" + s + "</td>");
    }

    private static void writeLine(BufferedWriter bw, String line) throws IOException {
        bw.write(line);
        bw.newLine();
    }

    static {
        NUMBER_INSTANCE.setMaximumFractionDigits(2);
        NUMBER_INSTANCE.setMinimumFractionDigits(2);
    }
}

