/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FreeSpaceBitSet;
import org.h2.mvstore.cache.FilePathCache;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathDisk;
import org.h2.store.fs.FilePathEncrypt;
import org.h2.store.fs.FilePathNio;

public class FileStore {
    protected final AtomicLong readCount = new AtomicLong(0L);
    protected final AtomicLong readBytes = new AtomicLong(0L);
    protected final AtomicLong writeCount = new AtomicLong(0L);
    protected final AtomicLong writeBytes = new AtomicLong(0L);
    protected final FreeSpaceBitSet freeSpace = new FreeSpaceBitSet(2, 4096);
    protected String fileName;
    protected boolean readOnly;
    protected long fileSize;
    protected FileChannel file;
    protected FileChannel encryptedFile;
    protected FileLock fileLock;

    public String toString() {
        return this.fileName;
    }

    public ByteBuffer readFully(long l, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        DataUtils.readFully(this.file, l, byteBuffer);
        this.readCount.incrementAndGet();
        this.readBytes.addAndGet(n);
        return byteBuffer;
    }

    public void writeFully(long l, ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.fileSize = Math.max(this.fileSize, l + (long)n);
        DataUtils.writeFully(this.file, l, byteBuffer);
        this.writeCount.incrementAndGet();
        this.writeBytes.addAndGet(n);
    }

    public void open(String string, boolean bl, char[] cArray) {
        FilePath filePath;
        if (this.file != null) {
            return;
        }
        if (string != null) {
            FilePathCache.INSTANCE.getScheme();
            filePath = FilePath.get(string);
            if (filePath instanceof FilePathDisk && !string.startsWith(filePath.getScheme() + ":")) {
                FilePathNio.class.getName();
                string = "nio:" + string;
            }
        }
        this.fileName = string;
        filePath = FilePath.get(string);
        FilePath filePath2 = filePath.getParent();
        if (filePath2 != null && !filePath2.exists()) {
            throw DataUtils.newIllegalArgumentException("Directory does not exist: {0}", filePath2);
        }
        if (filePath.exists() && !filePath.canWrite()) {
            bl = true;
        }
        this.readOnly = bl;
        try {
            this.file = filePath.open(bl ? "r" : "rw");
            if (cArray != null) {
                byte[] byArray = FilePathEncrypt.getPasswordBytes(cArray);
                this.encryptedFile = this.file;
                this.file = new FilePathEncrypt.FileEncrypt(string, byArray, this.file);
            }
            try {
                this.fileLock = bl ? this.file.tryLock(0L, Long.MAX_VALUE, true) : this.file.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", string, overlappingFileLockException);
            }
            if (this.fileLock == null) {
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", string);
            }
            this.fileSize = this.file.size();
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(1, "Could not open file {0}", string, iOException);
        }
    }

    public void close() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
            this.file.close();
            this.freeSpace.clear();
        }
        catch (Exception exception) {
            throw DataUtils.newIllegalStateException(2, "Closing failed for file {0}", this.fileName, exception);
        }
        finally {
            this.file = null;
        }
    }

    public void sync() {
        try {
            this.file.force(true);
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(2, "Could not sync file {0}", this.fileName, iOException);
        }
    }

    public long size() {
        return this.fileSize;
    }

    public void truncate(long l) {
        try {
            this.writeCount.incrementAndGet();
            this.file.truncate(l);
            this.fileSize = Math.min(this.fileSize, l);
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(2, "Could not truncate file {0} to size {1}", this.fileName, l, iOException);
        }
    }

    public FileChannel getFile() {
        return this.file;
    }

    public FileChannel getEncryptedFile() {
        return this.encryptedFile;
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public long getWriteBytes() {
        return this.writeBytes.get();
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getDefaultRetentionTime() {
        return 45000;
    }

    public void markUsed(long l, int n) {
        this.freeSpace.markUsed(l, n);
    }

    public long allocate(int n) {
        return this.freeSpace.allocate(n);
    }

    public void free(long l, int n) {
        this.freeSpace.free(l, n);
    }

    public int getFillRate() {
        return this.freeSpace.getFillRate();
    }

    long getFirstFree() {
        return this.freeSpace.getFirstFree();
    }

    long getFileLengthInUse() {
        return this.freeSpace.getLastFree();
    }

    public void clear() {
        this.freeSpace.clear();
    }

    public String getFileName() {
        return this.fileName;
    }
}

