/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.Utils;

public final class MethodInfo {
    private int access_flags;
    private int loc = -1;
    private String name;
    private String descriptor;

    public void read(ConstantPool constantPool, DataInputStream dis) throws IOException {
        this.access_flags = dis.readShort();
        short name_index = dis.readShort();
        this.name = Utils.getUTF8Value(constantPool, name_index);
        short descriptor_index = dis.readShort();
        this.descriptor = Utils.getUTF8Value(constantPool, descriptor_index);
        int attributes_count = dis.readUnsignedShort();
        int i = 0;
        while (i < attributes_count) {
            short attr_id = dis.readShort();
            String attr_name = Utils.getUTF8Value(constantPool, attr_id);
            int len = dis.readInt();
            if ("Code".equals(attr_name)) {
                this.readCode(constantPool, dis);
            } else {
                dis.skipBytes(len);
            }
            ++i;
        }
    }

    protected void readCode(ConstantPool constantPool, DataInputStream dis) throws IOException {
        dis.skipBytes(4);
        int bytecode_len = dis.readInt();
        dis.skip(bytecode_len);
        short exception_count = dis.readShort();
        dis.skipBytes(exception_count * 4 * 2);
        int attributes_count = dis.readUnsignedShort();
        int i = 0;
        while (i < attributes_count) {
            short attr_id = dis.readShort();
            String attr_name = Utils.getUTF8Value(constantPool, attr_id);
            int len = dis.readInt();
            if ("LineNumberTable".equals(attr_name)) {
                this.loc = dis.readShort();
                dis.skip(this.loc * 2 * 2);
            } else {
                dis.skipBytes(len);
            }
            ++i;
        }
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getFullSignature() {
        return this.getReturnType() + " " + this.getShortSignature();
    }

    public String getShortSignature() {
        StringBuffer buf = new StringBuffer(this.getName());
        buf.append("(");
        String[] params = this.getParametersType();
        int i = 0;
        while (i < params.length) {
            buf.append(params[i]);
            if (i != params.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public String getReturnType() {
        return Utils.getMethodReturnType(this.getDescriptor());
    }

    public String[] getParametersType() {
        return Utils.getMethodParams(this.getDescriptor());
    }

    public int getNumberOfLines() {
        return this.loc;
    }

    public String getAccess() {
        return Utils.getMethodAccess(this.access_flags);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Method: ").append(this.getAccess()).append(" ");
        sb.append(this.getFullSignature());
        return sb.toString();
    }
}

