/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.antcontrib.property.AbstractPropertySetterTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.util.regexp.Regexp;

public class PropertySelector
extends AbstractPropertySetterTask {
    private RegularExpression match;
    private String select = "\\0";
    private char delim = (char)44;
    private boolean caseSensitive = true;
    private boolean distinct = false;

    public void setMatch(String match) {
        this.match = new RegularExpression();
        this.match.setPattern(match);
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setDelimiter(char delim) {
        this.delim = delim;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    protected void validate() {
        super.validate();
        if (this.match == null) {
            throw new BuildException("No match expression specified.");
        }
    }

    public void execute() throws BuildException {
        this.validate();
        int options = 0;
        if (!this.caseSensitive) {
            options |= 0x100;
        }
        Regexp regex = this.match.getRegexp(((ProjectComponent)this).project);
        Hashtable props = ((ProjectComponent)this).project.getProperties();
        Enumeration e = props.keys();
        StringBuffer buf = new StringBuffer();
        int cnt = 0;
        Vector<String> used = new Vector<String>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!regex.matches(key, options)) continue;
            String output = this.select;
            Vector groups = regex.getGroups(key, options);
            int sz = groups.size();
            for (int i = 0; i < sz; ++i) {
                String s = (String)groups.elementAt(i);
                RegularExpression result = null;
                result = new RegularExpression();
                result.setPattern("\\\\" + i);
                Regexp sregex = result.getRegexp(((ProjectComponent)this).project);
                output = sregex.substitute(output, s, 0);
            }
            if (this.distinct && used.contains(output)) continue;
            used.addElement(output);
            if (cnt != 0) {
                buf.append(this.delim);
            }
            buf.append(output);
            ++cnt;
        }
        if (buf.length() > 0) {
            this.setPropertyValue(buf.toString());
        }
    }
}

