/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.benchmark;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.hc.core5.benchmark.Results;

public class ResultFormatter {
    static final NumberFormat nf2 = NumberFormat.getInstance(Locale.ROOT);
    static final NumberFormat nf3 = NumberFormat.getInstance(Locale.ROOT);
    static final NumberFormat nf6 = NumberFormat.getInstance(Locale.ROOT);

    private ResultFormatter() {
    }

    public static void print(PrintStream printStream, Results results) {
        printStream.println("Server Software:\t\t" + results.getServerName());
        printStream.println("Protocol version:\t\t" + results.getProtocolVersion());
        printStream.println("Server Hostname:\t\t" + results.getHostName());
        printStream.println("Server Port:\t\t\t" + results.getHostPort());
        printStream.println("Document Path:\t\t\t" + results.getDocumentPath());
        printStream.println("Document Length:\t\t" + results.getContentLength() + " bytes\n");
        printStream.println("Concurrency Level:\t\t" + results.getConcurrencyLevel());
        printStream.println("Time taken for tests:\t" + nf6.format((double)results.getTotalTimeMillis() / 1000.0) + " seconds");
        printStream.println("Complete requests:\t\t" + results.getSuccessCount());
        printStream.println("Failed requests:\t\t" + results.getFailureCount());
        printStream.println("Kept alive:\t\t\t\t" + results.getKeepAliveCount());
        printStream.println("Total transferred:\t\t" + results.getTotalBytesRcvd() + " bytes");
        printStream.println("Content transferred:\t" + results.getTotalContentBytesRecvd() + " bytes");
        printStream.println("Requests per second:\t" + nf2.format((double)results.getSuccessCount() / ((double)results.getTotalTimeMillis() / 1000.0)) + " [#/sec] (mean)");
        printStream.println("Time per request:\t\t" + nf3.format((double)results.getTotalTimeMillis() * (double)results.getConcurrencyLevel() / (double)results.getSuccessCount()) + " [ms] (mean)");
        printStream.println("Time per request:\t\t" + nf3.format((double)results.getTotalTimeMillis() / (double)results.getSuccessCount()) + " [ms] (mean, across all concurrent requests)");
        printStream.println("Transfer rate:\t\t\t" + nf2.format((double)results.getTotalBytesRcvd() / 1024.0 / ((double)results.getTotalTimeMillis() / 1000.0)) + " [Kbytes/sec] received");
    }

    static {
        nf2.setMaximumFractionDigits(2);
        nf2.setMinimumFractionDigits(2);
        nf3.setMaximumFractionDigits(3);
        nf3.setMinimumFractionDigits(3);
        nf6.setMaximumFractionDigits(6);
        nf6.setMinimumFractionDigits(6);
    }
}

