/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkSubmitUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.IvyProperties;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DependencyUtils$
implements Logging {
    public static DependencyUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DependencyUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public IvyProperties getIvyProperties() {
        Seq seq = (Seq)((TraversableLike)new .colon.colon((Object)package$.MODULE$.JAR_PACKAGES_EXCLUSIONS().key(), (List)new .colon.colon((Object)package$.MODULE$.JAR_PACKAGES().key(), (List)new .colon.colon((Object)package$.MODULE$.JAR_REPOSITORIES().key(), (List)new .colon.colon((Object)package$.MODULE$.JAR_IVY_REPO_PATH().key(), (List)new .colon.colon((Object)package$.MODULE$.JAR_IVY_SETTING_PATH().key(), (List)Nil$.MODULE$)))))).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)scala.sys.package$.MODULE$.props().get(x$1).orNull(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom());
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) {
            throw new MatchError((Object)seq);
        }
        String packagesExclusions = (String)((SeqLike)some.get()).apply(0);
        String packages = (String)((SeqLike)some.get()).apply(1);
        String repositories = (String)((SeqLike)some.get()).apply(2);
        String ivyRepoPath = (String)((SeqLike)some.get()).apply(3);
        String ivySettingsPath = (String)((SeqLike)some.get()).apply(4);
        Tuple5 tuple5 = new Tuple5((Object)packagesExclusions, (Object)packages, (Object)repositories, (Object)ivyRepoPath, (Object)ivySettingsPath);
        String packagesExclusions2 = (String)tuple5._1();
        String packages2 = (String)tuple5._2();
        String repositories2 = (String)tuple5._3();
        String ivyRepoPath2 = (String)tuple5._4();
        String ivySettingsPath2 = (String)tuple5._5();
        return new IvyProperties(packagesExclusions2, packages2, repositories2, ivyRepoPath2, ivySettingsPath2);
    }

    private boolean isInvalidQueryString(String[] tokens) {
        return tokens.length != 2 || StringUtils.isBlank((CharSequence)tokens[0]) || StringUtils.isBlank((CharSequence)tokens[1]);
    }

    private Tuple2<Object, String> parseQueryParams(URI uri) {
        String uriQuery = uri.getQuery();
        if (uriQuery == null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
        }
        String[][] mapTokens = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uriQuery.split("&"))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.split("="), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapTokens)).exists((Function1 & Serializable & scala.Serializable)tokens -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.MODULE$.isInvalidQueryString(tokens)))) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Invalid query string in Ivy URI ").append(uri.toString()).append(": ").append(uriQuery).toString());
        }
        Map groupedParams = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapTokens)).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)kv[0], (Object)kv[1]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).groupBy((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._1());
        Option transitiveParams = groupedParams.get((Object)"transitive");
        if (BoxesRunTime.unboxToInt((Object)transitiveParams.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)DependencyUtils$.$anonfun$parseQueryParams$5(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) > 1) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "It's best to specify `transitive` parameter in ivy URI query only once. If there are multiple `transitive` parameter, we will select the last one");
        }
        boolean transitive = BoxesRunTime.unboxToBoolean((Object)transitiveParams.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps((boolean[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6)).takeRight(1))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$parseQueryParams$9(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())))).headOption()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        String exclusionList = (String)groupedParams.get((Object)"exclude").map((Function1 & Serializable & scala.Serializable)params -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params)).map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).flatMap((Function1 & Serializable & scala.Serializable)excludeString -> new ArrayOps.ofRef(DependencyUtils$.$anonfun$parseQueryParams$13(uri, excludeString)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Set validParams = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transitive", "exclude"}));
        Seq invalidParams = ((TraversableOnce)groupedParams.keys().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validParams.contains((Object)elem)))).toSeq();
        if (invalidParams.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Invalid parameters `").append(((TraversableOnce)invalidParams.sorted((Ordering)Ordering.String$.MODULE$)).mkString(",")).append("` found ").append("in Ivy URI query `").append(uriQuery).append("`.").toString());
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)transitive), (Object)exclusionList);
    }

    public Seq<String> resolveMavenDependencies(URI uri) {
        IvyProperties ivyProperties = this.getIvyProperties();
        String authority = uri.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(new StringBuilder(77).append("Invalid Ivy URI authority in uri ").append(uri.toString()).append(":").append(" Expected 'org:module:version', found null.").toString());
        }
        if (authority.split(":").length != 3) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Invalid Ivy URI authority in uri ").append(uri.toString()).append(":").append(" Expected 'org:module:version', found ").append(authority).append(".").toString());
        }
        Tuple2<Object, String> tuple2 = this.parseQueryParams(uri);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean transitive = tuple2._1$mcZ$sp();
        String exclusionList = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)transitive), (Object)exclusionList);
        boolean transitive2 = tuple22._1$mcZ$sp();
        String exclusionList2 = (String)tuple22._2();
        return this.resolveMavenDependencies(transitive2, exclusionList2, authority, ivyProperties.repositories(), ivyProperties.ivyRepoPath(), (Option<String>)Option$.MODULE$.apply((Object)ivyProperties.ivySettingsPath()));
    }

    public Seq<String> resolveMavenDependencies(boolean packagesTransitive, String packagesExclusions, String packages, String repositories, String ivyRepoPath, Option<String> ivySettingsPath) {
        IvySettings ivySettings;
        Nil$ exclusions = !StringUtils.isBlank((CharSequence)packagesExclusions) ? Predef$.MODULE$.wrapRefArray((Object[])packagesExclusions.split(",")) : Nil$.MODULE$;
        Option<String> option = ivySettingsPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            ivySettings = SparkSubmitUtils$.MODULE$.loadIvySettings(path, (Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath));
        } else if (None$.MODULE$.equals(option)) {
            ivySettings = SparkSubmitUtils$.MODULE$.buildIvySettings((Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath), SparkSubmitUtils$.MODULE$.buildIvySettings$default$3());
        } else {
            throw new MatchError(option);
        }
        IvySettings ivySettings2 = ivySettings;
        String x$1 = packages;
        IvySettings x$2 = ivySettings2;
        boolean x$3 = packagesTransitive;
        Nil$ x$4 = exclusions;
        Option<IvySettings> x$5 = SparkSubmitUtils$.MODULE$.resolveMavenCoordinates$default$3();
        boolean x$6 = SparkSubmitUtils$.MODULE$.resolveMavenCoordinates$default$6();
        return SparkSubmitUtils$.MODULE$.resolveMavenCoordinates(x$1, x$2, x$5, x$3, (Seq<String>)x$4, x$6);
    }

    public String resolveAndDownloadJars(String jars, String userJar, SparkConf sparkConf, Configuration hadoopConf) {
        File targetDir = Utils$.MODULE$.createTempDir();
        String userJarName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(userJar)).split(File.separatorChar))).last();
        return (String)Option$.MODULE$.apply((Object)jars).map((Function1 & Serializable & scala.Serializable)x$11 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.resolveGlobPaths((String)x$11, hadoopConf).split(","))).filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.contains(userJarName))))).mkString(",")).filterNot((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$resolveAndDownloadJars$3(x$13))).map((Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.downloadFileList((String)x$14, targetDir, sparkConf, hadoopConf)).orNull(Predef$.MODULE$.$conforms());
    }

    public void addJarsToClassPath(String jars, MutableURLClassLoader loader) {
        if (jars != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars.split(","))).foreach((Function1 & Serializable & scala.Serializable)jar -> {
                DependencyUtils$.MODULE$.addJarToClasspath(jar, loader);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public String downloadFileList(String fileList, File targetDir, SparkConf sparkConf, Configuration hadoopConf) {
        Predef$.MODULE$.require(fileList != null, (Function0 & Serializable & scala.Serializable)() -> "fileList cannot be null.");
        return ((TraversableOnce)Utils$.MODULE$.stringToSeq(fileList).map((Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.downloadFile((String)x$15, targetDir, sparkConf, hadoopConf), Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public String downloadFile(String path, File targetDir, SparkConf sparkConf, Configuration hadoopConf) {
        Predef$.MODULE$.require(path != null, (Function0 & Serializable & scala.Serializable)() -> "path cannot be null.");
        URI uri = Utils$.MODULE$.resolveURI(path);
        String string = uri.getScheme();
        if ("file".equals(string) ? true : "local".equals(string)) {
            return path;
        }
        if (("http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string))) && Utils$.MODULE$.isTesting()) {
            File file = new File(uri.getPath());
            return new File(targetDir, file.getName()).toURI().toString();
        }
        String fname = new Path(uri).getName();
        File localFile = Utils$.MODULE$.doFetchFile(uri.toString(), targetDir, fname, sparkConf, hadoopConf);
        return localFile.toURI().toString();
    }

    public String resolveGlobPaths(String paths, Configuration hadoopConf) {
        Predef$.MODULE$.require(paths != null, (Function0 & Serializable & scala.Serializable)() -> "paths cannot be null.");
        return ((TraversableOnce)Utils$.MODULE$.stringToSeq(paths).flatMap((Function1 & Serializable & scala.Serializable)path -> new ArrayOps.ofRef(DependencyUtils$.$anonfun$resolveGlobPaths$2(hadoopConf, path)), Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public void addJarToClasspath(String localJar, MutableURLClassLoader loader) {
        URI uri = Utils$.MODULE$.resolveURI(localJar);
        String string = uri.getScheme();
        if ("file".equals(string) ? true : "local".equals(string)) {
            File file = new File(uri.getPath());
            if (file.exists()) {
                loader.addURL(file.toURI().toURL());
                return;
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Local jar ").append(file).append(" does not exist, skipping.").toString());
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Skip remote jar ").append(uri).append(".").toString());
    }

    public String mergeFileLists(Seq<String> lists) {
        Seq merged = (Seq)((TraversableLike)lists.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$mergeFileLists$1(x$1)))).flatMap((Function1 & Serializable & scala.Serializable)str -> Utils$.MODULE$.stringToSeq((String)str), Seq$.MODULE$.canBuildFrom());
        if (merged.nonEmpty()) {
            return merged.mkString(",");
        }
        return null;
    }

    private Tuple2<URI, Option<String>> splitOnFragment(String path) {
        URI uri = Utils$.MODULE$.resolveURI(path);
        URI withoutFragment = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
        return new Tuple2((Object)withoutFragment, (Object)Option$.MODULE$.apply((Object)uri.getFragment()));
    }

    private String[] resolveGlobPath(URI uri, Configuration hadoopConf) {
        String string = uri.getScheme();
        if ("local".equals(string) ? true : ("http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string)))) {
            return (String[])((Object[])new String[]{uri.toString()});
        }
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConf);
        return (String[])Option$.MODULE$.apply((Object)fs.globStatus(new Path(uri))).map((Function1 & Serializable & scala.Serializable)status -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])status)).filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isFile())))).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getPath().toUri().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])((Object[])new String[]{uri.toString()}));
    }

    public static final /* synthetic */ int $anonfun$parseQueryParams$5(Tuple2[] x$5) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5)).size();
    }

    public static final /* synthetic */ boolean $anonfun$parseQueryParams$9(Tuple2 x$7) {
        return ((String)x$7._2()).equalsIgnoreCase("true");
    }

    public static final /* synthetic */ Object[] $anonfun$parseQueryParams$13(URI uri$1, String excludeString) {
        String[] excludes = excludeString.split(",");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])excludes)).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).exists((Function1 & Serializable & scala.Serializable)tokens -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.MODULE$.isInvalidQueryString(tokens)))) {
            throw new IllegalArgumentException(new StringBuilder(79).append("Invalid exclude string in Ivy URI ").append(uri$1.toString()).append(":").append(" expected 'org:module,org:module,..', found ").append(excludeString).toString());
        }
        return Predef$.MODULE$.refArrayOps((Object[])excludes);
    }

    public static final /* synthetic */ boolean $anonfun$resolveAndDownloadJars$3(String x$13) {
        String string = x$13;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Object[] $anonfun$resolveGlobPaths$2(Configuration hadoopConf$3, String path) {
        Tuple2<URI, Option<String>> tuple2 = MODULE$.splitOnFragment(path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        URI base = (URI)tuple2._1();
        Option fragment = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)base, (Object)fragment);
        URI base2 = (URI)tuple22._1();
        Option fragment2 = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)MODULE$.resolveGlobPath(base2, hadoopConf$3), (Object)fragment2);
        if (tuple23 != null) {
            String[] resolved = (String[])tuple23._1();
            Option option = (Option)tuple23._2();
            if (option instanceof Some && resolved.length > 1) {
                throw new SparkException(new StringBuilder(41).append(base2.toString()).append(" resolves ambiguously to multiple files: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolved)).mkString(",")).toString());
            }
        }
        if (tuple23 != null) {
            String[] resolved = (String[])tuple23._1();
            Option option = (Option)tuple23._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String namedAs = (String)some.value();
                return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolved)).map((Function1 & Serializable & scala.Serializable)x$17 -> new StringBuilder(1).append((String)x$17).append("#").append(namedAs).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
        }
        if (tuple23 != null) {
            String[] resolved = (String[])tuple23._1();
            return Predef$.MODULE$.refArrayOps((Object[])resolved);
        }
        throw new MatchError((Object)tuple23);
    }

    public static final /* synthetic */ boolean $anonfun$mergeFileLists$1(CharSequence x$1) {
        return StringUtils.isBlank((CharSequence)x$1);
    }

    private DependencyUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

