/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GrowableOffsetRangeTracker
extends OffsetRangeTracker {
    private final @UnknownKeyFor @NonNull @Initialized RangeEndEstimator rangeEndEstimator;

    public GrowableOffsetRangeTracker(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized RangeEndEstimator rangeEndEstimator) {
        super(new OffsetRange(start, Long.MAX_VALUE));
        this.rangeEndEstimator = Preconditions.checkNotNull(rangeEndEstimator);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized OffsetRange> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        BigDecimal estimateRangeEnd;
        if (this.range.getTo() != Long.MAX_VALUE || this.range.getTo() == this.range.getFrom()) {
            return super.trySplit(fractionOfRemainder);
        }
        if (this.lastAttemptedOffset != null && this.lastAttemptedOffset == Long.MAX_VALUE) {
            return null;
        }
        BigDecimal cur = this.lastAttemptedOffset == null ? BigDecimal.valueOf(this.range.getFrom()).subtract(BigDecimal.ONE, MathContext.DECIMAL128) : BigDecimal.valueOf(this.lastAttemptedOffset);
        BigDecimal splitPos = cur.add((estimateRangeEnd = BigDecimal.valueOf(this.rangeEndEstimator.estimate()).max(cur.add(BigDecimal.ONE, MathContext.DECIMAL128))).subtract(cur, MathContext.DECIMAL128).multiply(BigDecimal.valueOf(fractionOfRemainder), MathContext.DECIMAL128).max(BigDecimal.ONE), MathContext.DECIMAL128);
        long split = splitPos.longValue();
        if (split > estimateRangeEnd.longValue()) {
            return null;
        }
        OffsetRange res = new OffsetRange(split, this.range.getTo());
        this.range = new OffsetRange(this.range.getFrom(), split);
        return SplitResult.of(this.range, res);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
        if (this.range.getTo() != Long.MAX_VALUE || this.range.getTo() == this.range.getFrom()) {
            return super.getProgress();
        }
        BigDecimal estimateRangeEnd = BigDecimal.valueOf(this.rangeEndEstimator.estimate());
        if (this.lastAttemptedOffset == null) {
            return RestrictionTracker.Progress.from(0.0, estimateRangeEnd.subtract(BigDecimal.valueOf(this.range.getFrom()), MathContext.DECIMAL128).max(BigDecimal.ZERO).doubleValue());
        }
        BigDecimal workRemaining = estimateRangeEnd.subtract(BigDecimal.valueOf(this.lastAttemptedOffset), MathContext.DECIMAL128).max(BigDecimal.ZERO);
        BigDecimal totalWork = estimateRangeEnd.max(BigDecimal.valueOf(this.lastAttemptedOffset)).subtract(BigDecimal.valueOf(this.range.getFrom()), MathContext.DECIMAL128);
        return RestrictionTracker.Progress.from(totalWork.subtract(workRemaining, MathContext.DECIMAL128).doubleValue(), workRemaining.doubleValue());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
        if (this.lastAttemptedOffset != null && this.lastAttemptedOffset == Long.MAX_VALUE) {
            return RestrictionTracker.IsBounded.BOUNDED;
        }
        return this.range.getTo() == Long.MAX_VALUE ? RestrictionTracker.IsBounded.UNBOUNDED : RestrictionTracker.IsBounded.BOUNDED;
    }

    @FunctionalInterface
    public static interface RangeEndEstimator {
        public @UnknownKeyFor @NonNull @Initialized long estimate();
    }
}

