/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms.providers;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.AutoValue_LoggingTransformProvider_Configuration;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@AutoService(value={SchemaTransformProvider.class})
public class LoggingTransformProvider
extends TypedSchemaTransformProvider<Configuration> {
    protected static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    protected static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_ROWS_TAG = "output";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Configuration> configurationClass() {
        return Configuration.class;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        return new LoggingTransform(configuration);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:yaml:log_for_testing:v1";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_ROWS_TAG);
    }

    protected static class LoggingTransform
    extends SchemaTransform {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(LoggingTransform.class);
        private final @UnknownKeyFor @NonNull @Initialized Configuration configuration;

        LoggingTransform(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Schema inputSchema = input.get(LoggingTransformProvider.INPUT_ROWS_TAG).getSchema();
            PCollection<Row> result = ((PCollection)((Object)input.get(LoggingTransformProvider.INPUT_ROWS_TAG).apply("LogAsJson", ParDo.of(LoggingTransform.createDoFn(this.configuration.getLogLevel(), this.configuration.getNonNullPrefix(), inputSchema))))).setRowSchema(inputSchema);
            return PCollectionRowTuple.of(LoggingTransformProvider.OUTPUT_ROWS_TAG, result);
        }

        private static @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> createDoFn(final @UnknownKeyFor @NonNull @Initialized Level logLevel, final @UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
            final SimpleFunction<Row, byte[]> fn = JsonUtils.getRowToJsonBytesFunction(rowSchema);
            return new DoFn<Row, Row>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
                    String msg = prefix + new String((byte[])fn.apply(row), Charsets.UTF_8);
                    switch (logLevel) {
                        case DEBUG: {
                            LOG.debug(msg);
                            break;
                        }
                        case INFO: {
                            LOG.info(msg);
                            break;
                        }
                        default: {
                            LOG.error(msg);
                        }
                    }
                    out.output(row);
                }
            };
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Configuration {
        private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Level> SUPPORTED_LOG_LEVELS = ImmutableMap.of("ERROR", Level.ERROR, "INFO", Level.INFO, "DEBUG", Level.DEBUG);

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getLevel();

        public @UnknownKeyFor @NonNull @Initialized Level getLogLevel() {
            if (this.getLevel() == null) {
                return Level.INFO;
            }
            if (SUPPORTED_LOG_LEVELS.containsKey(this.getLevel())) {
                return SUPPORTED_LOG_LEVELS.get(this.getLevel());
            }
            throw new IllegalArgumentException("Unknown log level " + this.getLevel() + ". Valid log levels are " + ImmutableList.copyOf(SUPPORTED_LOG_LEVELS.keySet()));
        }

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getPrefix();

        public @UnknownKeyFor @NonNull @Initialized String getNonNullPrefix() {
            String prefix = this.getPrefix();
            return prefix == null ? "" : prefix;
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_LoggingTransformProvider_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLevel(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setPrefix(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Configuration build();
        }
    }
}

