/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io.payloads;

import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.Providers;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public final class PayloadSerializers {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PayloadSerializerProvider> PROVIDERS = Providers.loadProviders(PayloadSerializerProvider.class);

    private PayloadSerializers() {
    }

    public static @UnknownKeyFor @NonNull @Initialized PayloadSerializer getSerializer(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> tableParams) {
        PayloadSerializerProvider provider = PROVIDERS.get(id);
        Preconditions.checkArgument(provider != null, "Invalid config, no serializer provider exists with identifier `%s`.", (Object)id);
        return provider.getSerializer(schema, tableParams);
    }
}

