/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptionSpec;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PipelineOptionsReflector {
    private PipelineOptionsReflector() {
    }

    static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineOptionSpec> getOptionSpecs(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> optionsInterface, @UnknownKeyFor @NonNull @Initialized boolean skipHidden) {
        Iterable<Method> methods = ReflectHelpers.getClosureOfMethodsOnInterface(optionsInterface);
        Multimap<String, Method> propsToGetters = PipelineOptionsReflector.getPropertyNamesToGetters(methods);
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Map.Entry<String, Method> propAndGetter : propsToGetters.entries()) {
            String prop = propAndGetter.getKey();
            Method getter = propAndGetter.getValue();
            Class<?> declaringClass = getter.getDeclaringClass();
            if (!PipelineOptions.class.isAssignableFrom(declaringClass) || skipHidden && declaringClass.isAnnotationPresent(Hidden.class)) continue;
            setBuilder.add(PipelineOptionSpec.of(declaringClass, prop, getter));
        }
        return setBuilder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineOptionSpec> getOptionSpecs(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> optionsInterfaces) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Class<? extends PipelineOptions> optionsInterface : optionsInterfaces) {
            setBuilder.addAll(PipelineOptionsReflector.getOptionSpecs(optionsInterface, true));
        }
        return setBuilder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Method> getPropertyNamesToGetters(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Method> methods) {
        HashMultimap<String, Method> propertyNamesToGetters = HashMultimap.create();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("is") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            String propertyName = Introspector.decapitalize(methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3));
            propertyNamesToGetters.put(propertyName, method);
        }
        return propertyNamesToGetters;
    }
}

