/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.construction.PipelineOptionsTranslation;
import org.apache.beam.sdk.util.construction.graph.ExecutableStage;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceCountingExecutableStageContextFactory
implements ExecutableStageContext.Factory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ReferenceCountingExecutableStageContextFactory.class);
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_RETRY = 3;
    private final @UnknownKeyFor @NonNull @Initialized Creator creator;
    private volatile transient @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService executor;
    private volatile transient @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ReferenceCountingExecutableStageContextFactory. @UnknownKeyFor @NonNull @Initialized WrappedContext> keyRegistry;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Boolean> isReleaseSynchronous;

    public static @UnknownKeyFor @NonNull @Initialized ReferenceCountingExecutableStageContextFactory create(@UnknownKeyFor @NonNull @Initialized Creator creator, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Boolean> isReleaseSynchronous) {
        return new ReferenceCountingExecutableStageContextFactory(creator, isReleaseSynchronous);
    }

    private ReferenceCountingExecutableStageContextFactory(@UnknownKeyFor @NonNull @Initialized Creator creator, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Boolean> isReleaseSynchronous) {
        this.creator = creator;
        this.isReleaseSynchronous = isReleaseSynchronous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized ExecutableStageContext get(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        for (int retry = 0; retry < 3; ++retry) {
            WrappedContext wrapper;
            WrappedContext wrappedContext = wrapper = this.getCache().computeIfAbsent(jobInfo.jobId(), jobId -> {
                try {
                    return new WrappedContext(jobInfo, (ExecutableStageContext)this.creator.apply(jobInfo));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create context for job " + jobInfo.jobId(), e);
                }
            });
            synchronized (wrappedContext) {
                if (wrapper.referenceCount != null) {
                    wrapper.referenceCount.incrementAndGet();
                    return wrapper;
                }
                continue;
            }
        }
        throw new RuntimeException(String.format("Max retry %s exhausted while creating Context for job %s", 3, jobInfo.jobId()));
    }

    private void scheduleRelease(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        WrappedContext wrapper = this.getCache().get(jobInfo.jobId());
        Preconditions.checkState(wrapper != null, "Releasing context for unknown job: " + jobInfo.jobId());
        PipelineOptions pipelineOptions = PipelineOptionsTranslation.fromProto(jobInfo.pipelineOptions());
        int environmentCacheTTLMillis = pipelineOptions.as(PortablePipelineOptions.class).getEnvironmentCacheMillis();
        if (environmentCacheTTLMillis > 0) {
            if (this.isReleaseSynchronous.apply(this).booleanValue()) {
                this.release(wrapper);
            } else {
                this.getExecutor().schedule(() -> this.release(wrapper), (long)environmentCacheTTLMillis, TimeUnit.MILLISECONDS);
            }
        } else {
            this.release(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ReferenceCountingExecutableStageContextFactory. @UnknownKeyFor @NonNull @Initialized WrappedContext> getCache() {
        if (this.keyRegistry != null) {
            return this.keyRegistry;
        }
        ReferenceCountingExecutableStageContextFactory referenceCountingExecutableStageContextFactory = this;
        synchronized (referenceCountingExecutableStageContextFactory) {
            if (this.keyRegistry == null) {
                this.keyRegistry = new ConcurrentHashMap();
            }
            return this.keyRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        ReferenceCountingExecutableStageContextFactory referenceCountingExecutableStageContextFactory = this;
        synchronized (referenceCountingExecutableStageContextFactory) {
            if (this.executor == null) {
                this.executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ScheduledExecutor-thread").setDaemon(true).build());
            }
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void release(@UnknownKeyFor @NonNull @Initialized ExecutableStageContext context) {
        WrappedContext wrapper;
        WrappedContext wrappedContext = wrapper = (WrappedContext)context;
        synchronized (wrappedContext) {
            if (wrapper.referenceCount.decrementAndGet() == 0) {
                wrapper.referenceCount = null;
                if (this.getCache().remove(wrapper.jobInfo.jobId(), wrapper)) {
                    try {
                        wrapper.closeActual();
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to close ExecutableStageContext.", t);
                    }
                }
            }
        }
    }

    public static interface Creator
    extends ThrowingFunction<JobInfo, ExecutableStageContext>,
    Serializable {
    }

    @VisibleForTesting
    class WrappedContext
    implements ExecutableStageContext {
        private @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
        private @UnknownKeyFor @NonNull @Initialized AtomicInteger referenceCount;
        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized ExecutableStageContext context;

        WrappedContext(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, ExecutableStageContext context) {
            this.jobInfo = jobInfo;
            this.context = context;
            this.referenceCount = new AtomicInteger(0);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StageBundleFactory getStageBundleFactory(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage) {
            return this.context.getStageBundleFactory(executableStage);
        }

        @Override
        public void close() {
            ReferenceCountingExecutableStageContextFactory.this.scheduleRelease(this.jobInfo);
        }

        private void closeActual() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.context.close();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedContext that = (WrappedContext)o;
            return Objects.equals(this.jobInfo.jobId(), that.jobInfo.jobId());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.jobInfo);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "ContextWrapper{jobId='" + this.jobInfo + '\'' + ", referenceCount=" + this.referenceCount + '}';
        }
    }
}

