/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.io.kafka.ConfluentSchemaRegistryDeserializerProvider;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.transforms.kafka.ConfigOption;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamKafkaInputTransform
extends PTransform<PBegin, PCollection<HopRow>> {
    private String transformName;
    private String bootstrapServers;
    private String topics;
    private String groupId;
    private boolean usingProcessingTime;
    private boolean usingLogAppendTime;
    private boolean usingCreateTime;
    private boolean restrictedToCommitted;
    private boolean allowingCommitOnConsumedOffset;
    private List<ConfigOption> configOptions;
    private String messageType;
    private String schemaRegistryUrl;
    private String schemaRegistrySubject;
    private String rowMetaJson;
    private static final Logger LOG = LoggerFactory.getLogger(BeamKafkaInputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamKafkaInputError");
    private transient IRowMeta rowMeta;

    public BeamKafkaInputTransform() {
    }

    public BeamKafkaInputTransform(@Nullable String name, String transformName, String bootstrapServers, String topics, String groupId, boolean usingProcessingTime, boolean usingLogAppendTime, boolean usingCreateTime, boolean restrictedToCommitted, boolean allowingCommitOnConsumedOffset, String[] configOptionParameters, String[] configOptionValues, String[] configOptionTypes, String messageType, String schemaRegistryUrl, String schemaRegistrySubject, String rowMetaJson) {
        super(name);
        this.transformName = transformName;
        this.bootstrapServers = bootstrapServers;
        this.topics = topics;
        this.groupId = groupId;
        this.usingProcessingTime = usingProcessingTime;
        this.usingLogAppendTime = usingLogAppendTime;
        this.usingCreateTime = usingCreateTime;
        this.restrictedToCommitted = restrictedToCommitted;
        this.allowingCommitOnConsumedOffset = allowingCommitOnConsumedOffset;
        this.configOptions = new ArrayList<ConfigOption>();
        for (int i = 0; i < configOptionParameters.length; ++i) {
            this.configOptions.add(new ConfigOption(configOptionParameters[i], configOptionValues[i], ConfigOption.Type.getTypeFromName(configOptionTypes[i])));
        }
        this.messageType = messageType;
        this.schemaRegistryUrl = schemaRegistryUrl;
        this.schemaRegistrySubject = schemaRegistrySubject;
        this.rowMetaJson = rowMetaJson;
    }

    public PCollection<HopRow> expand(PBegin input) {
        try {
            KafkaIO.Read io;
            PCollection output;
            BeamHop.init();
            ArrayList<String> topicList = new ArrayList<String>();
            for (String topic : this.topics.split(",")) {
                topicList.add(Const.trim((String)topic));
            }
            HashMap<String, Object> consumerConfigUpdates = new HashMap<String, Object>();
            consumerConfigUpdates.put("group.id", this.groupId);
            for (ConfigOption configOption : this.configOptions) {
                Object value;
                String optionValue = configOption.getValue();
                switch (configOption.getType()) {
                    case String: {
                        value = optionValue;
                        break;
                    }
                    case Short: {
                        value = Short.valueOf(optionValue);
                        break;
                    }
                    case Int: {
                        value = Integer.valueOf(optionValue);
                        break;
                    }
                    case Long: {
                        value = Long.valueOf(optionValue);
                        break;
                    }
                    case Double: {
                        value = Double.valueOf(optionValue);
                        break;
                    }
                    case Boolean: {
                        value = Boolean.valueOf(optionValue);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Config option parameter " + configOption.getParameter() + " uses unsupported type " + configOption.getType().name());
                    }
                }
                consumerConfigUpdates.put(configOption.getParameter(), value);
            }
            if ("Avro Record".equalsIgnoreCase(this.messageType)) {
                ConfluentSchemaRegistryDeserializerProvider provider = ConfluentSchemaRegistryDeserializerProvider.of((String)this.schemaRegistryUrl, (String)this.schemaRegistrySubject, null, consumerConfigUpdates);
                KafkaIO.Read io2 = KafkaIO.read().withBootstrapServers(this.bootstrapServers).withConsumerConfigUpdates(consumerConfigUpdates).withTopics(topicList).withKeyDeserializer(StringDeserializer.class).withValueDeserializer((DeserializerProvider)provider);
                if (this.usingProcessingTime) {
                    io2 = io2.withProcessingTime();
                }
                if (this.usingLogAppendTime) {
                    io2 = io2.withLogAppendTime();
                }
                if (this.usingCreateTime) {
                    io2 = io2.withCreateTime(Duration.ZERO);
                }
                if (this.restrictedToCommitted) {
                    io2 = io2.withReadCommitted();
                }
                if (this.allowingCommitOnConsumedOffset) {
                    io2 = io2.commitOffsetsInFinalize();
                }
                PCollection kafkaConsumerOutput = (PCollection)input.apply(io2.withoutMetadata());
                output = (PCollection)kafkaConsumerOutput.apply((PTransform)ParDo.of((DoFn)new KVStringGenericRecordToHopRowFn(this.transformName, this.rowMetaJson)));
                return output;
            }
            if ("String".equalsIgnoreCase(this.messageType)) {
                io = KafkaIO.read().withBootstrapServers(this.bootstrapServers).withConsumerConfigUpdates(consumerConfigUpdates).withTopics(topicList).withKeyDeserializer(StringDeserializer.class).withValueDeserializer(StringDeserializer.class);
                if (this.usingProcessingTime) {
                    io = io.withProcessingTime();
                }
                if (this.usingLogAppendTime) {
                    io = io.withLogAppendTime();
                }
                if (this.usingCreateTime) {
                    io = io.withCreateTime(Duration.ZERO);
                }
                if (this.restrictedToCommitted) {
                    io = io.withReadCommitted();
                }
                if (this.allowingCommitOnConsumedOffset) {
                    io = io.commitOffsetsInFinalize();
                }
            } else {
                throw new HopException("Only parsing String or Avro Record messages is supported at this time");
            }
            PCollection kafkaConsumerOutput = (PCollection)input.apply(io.withoutMetadata());
            output = (PCollection)kafkaConsumerOutput.apply((PTransform)ParDo.of((DoFn)new KVStringStringToHopRowFn(this.transformName, this.rowMetaJson)));
            return output;
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in Kafka input transform", (Throwable)e);
            throw new RuntimeException("Error in Kafka input transform", e);
        }
    }

    public static final class KVStringGenericRecordToHopRowFn
    extends DoFn<KV<String, GenericRecord>, HopRow> {
        private final String rowMetaJson;
        private final String transformName;
        private final Logger LOG = LoggerFactory.getLogger(KVStringGenericRecordToHopRowFn.class);
        private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamSubscribeTransformErrors");
        private IRowMeta rowMeta;
        private transient Counter inputCounter;
        private transient Counter writtenCounter;

        public KVStringGenericRecordToHopRowFn(String transformName, String rowMetaJson) {
            this.transformName = transformName;
            this.rowMetaJson = rowMetaJson;
        }

        @DoFn.Setup
        public void setUp() {
            try {
                this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
                this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                BeamHop.init();
                this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                Metrics.counter((String)"init", (String)this.transformName).inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                this.LOG.error("Error in setup of KV<String,GenericRecord> to Hop Row conversion function", (Throwable)e);
                throw new RuntimeException("Error in setup of KV<String,GenericRecord> to Hop Row conversion function", e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext processContext) {
            try {
                KV kv = (KV)processContext.element();
                this.inputCounter.inc();
                Object[] outputRow = new Object[this.rowMeta.size()];
                outputRow[0] = kv.getKey();
                outputRow[1] = kv.getValue();
                processContext.output((Object)new HopRow(outputRow));
                this.writtenCounter.inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                this.LOG.error("Error in KV<String,GenericRecord> to Hop Row conversion function", (Throwable)e);
                throw new RuntimeException("Error in KV<String,GenericRecord> to Hop Row conversion function", e);
            }
        }
    }

    public static final class KVStringStringToHopRowFn
    extends DoFn<KV<String, String>, HopRow> {
        private final String rowMetaJson;
        private final String transformName;
        private final Logger LOG = LoggerFactory.getLogger(KVStringStringToHopRowFn.class);
        private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamSubscribeTransformErrors");
        private IRowMeta rowMeta;
        private transient Counter inputCounter;
        private transient Counter writtenCounter;

        public KVStringStringToHopRowFn(String transformName, String rowMetaJson) {
            this.transformName = transformName;
            this.rowMetaJson = rowMetaJson;
        }

        @DoFn.Setup
        public void setUp() {
            try {
                this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
                this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                BeamHop.init();
                this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                Metrics.counter((String)"init", (String)this.transformName).inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                this.LOG.error("Error in setup of KV<String,String> to Hop Row conversion function", (Throwable)e);
                throw new RuntimeException("Error in setup of KV<String,String> to Hop Row conversion function", e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext processContext) {
            try {
                KV kv = (KV)processContext.element();
                this.inputCounter.inc();
                Object[] outputRow = new Object[this.rowMeta.size()];
                outputRow[0] = kv.getKey();
                outputRow[1] = kv.getValue();
                processContext.output((Object)new HopRow(outputRow));
                this.writtenCounter.inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                this.LOG.error("Error in KV<String,String> to Hop Row conversion function", (Throwable)e);
                throw new RuntimeException("Error in KV<String,String> to Hop Row conversion function", e);
            }
        }
    }
}

