/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.combinationlookup;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.combinationlookup.CFields;
import org.apache.hop.pipeline.transforms.combinationlookup.CombinationLookup;
import org.apache.hop.pipeline.transforms.combinationlookup.CombinationLookupData;
import org.apache.hop.pipeline.transforms.combinationlookup.KeyField;

@Transform(id="CombinationLookup", image="combinationlookup.svg", name="i18n::CombinationLookup.Name", description="i18n::CombinationLookup.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.DataWarehouse", keywords={"i18n::CombinationLookupMeta.keyword"}, documentationUrl="/pipeline/transforms/combinationlookup.html")
public class CombinationLookupMeta
extends BaseTransformMeta<CombinationLookup, CombinationLookupData> {
    private static final Class<?> PKG = CombinationLookupMeta.class;
    public static final int DEFAULT_CACHE_SIZE = 9999;
    @HopMetadataProperty(key="schema", injectionKey="SCHEMA_NAME", injectionKeyDescription="CombinationLookup.Injection.SCHEMA_NAME")
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKey="TABLE_NAME", injectionKeyDescription="CombinationLookup.Injection.TABLE_NAME")
    private String tableName;
    @HopMetadataProperty(key="connection", storeWithName=true, injectionKey="CONNECTIONNAME", injectionKeyDescription="CombinationLookup.Injection.CONNECTION_NAME")
    private DatabaseMeta databaseMeta;
    @HopMetadataProperty(key="replace", injectionKey="REPLACE_FIELDS", injectionKeyDescription="CombinationLookup.Injection.REPLACE_FIELDS")
    private boolean replaceFields;
    @HopMetadataProperty(key="crc", injectionKey="USE_HASH", injectionKeyDescription="CombinationLookup.Injection.USE_HASH")
    private boolean useHash;
    @HopMetadataProperty(key="crcfield", injectionKey="HASH_FIELD", injectionKeyDescription="CombinationLookup.Injection.HASH_FIELD")
    private String hashField;
    @HopMetadataProperty(key="commit", injectionKey="COMMIT_SIZE", injectionKeyDescription="CombinationLookup.Injection.COMMIT_SIZE")
    private int commitSize;
    @HopMetadataProperty(key="preloadCache", injectionKey="PRELOAD_CACHE", injectionKeyDescription="CombinationLookup.Injection.PRELOAD_CACHE")
    private boolean preloadCache = false;
    @HopMetadataProperty(key="cache_size", injectionKey="CACHE_SIZE", injectionKeyDescription="CombinationLookup.Injection.CACHE_SIZE")
    private int cacheSize;
    @HopMetadataProperty
    private CFields fields = new CFields();
    public static final String CREATION_METHOD_AUTOINC = "autoinc";
    public static final String CREATION_METHOD_SEQUENCE = "sequence";
    public static final String CREATION_METHOD_TABLEMAX = "tablemax";

    public CombinationLookupMeta() {
    }

    public CombinationLookupMeta(CombinationLookupMeta m) {
    }

    public CombinationLookupMeta clone() {
        return new CombinationLookupMeta(this);
    }

    public void setDefault() {
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"CombinationLookupMeta.DimensionTableName.Label", (String[])new String[0]);
        this.databaseMeta = null;
        this.commitSize = 100;
        this.cacheSize = 9999;
        this.replaceFields = false;
        this.preloadCache = false;
        this.useHash = false;
        this.hashField = "hashcode";
        this.fields = new CFields();
        this.fields.getReturnFields().setTechnicalKeyField("technical/surrogate key field");
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaInteger v = new ValueMetaInteger(this.fields.getReturnFields().getTechnicalKeyField());
        v.setLength(10);
        v.setPrecision(0);
        v.setOrigin(origin);
        row.addValueMeta((IValueMeta)v);
        if (this.replaceFields) {
            for (int i = 0; i < this.fields.getKeyFields().size(); ++i) {
                KeyField keyField = this.fields.getKeyFields().get(i);
                int idx = row.indexOfValue(keyField.getName());
                if (idx < 0) continue;
                row.removeValueMeta(idx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        errorMessage = "";
        if (this.databaseMeta != null) {
            db = new Database(CombinationLookupMeta.loggingObject, variables, this.databaseMeta);
            try {
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                    r = db.getTableFields(schemaTable);
                    if (r != null) {
                        for (i = 0; i < this.fields.getKeyFields().size(); ++i) {
                            keyField = this.fields.getKeyFields().get(i);
                            lookupField = keyField.getLookup();
                            v = r.searchValueMeta(lookupField);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.MissingCompareFields", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + lookupField + Const.CR;
                        }
                        cr = errorFound != false ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        technicalKeyField = this.fields.getReturnFields().getTechnicalKeyField();
                        if (r.indexOfValue(technicalKeyField) < 0) {
                            errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.TechnicalKeyNotFound", (String[])new String[]{technicalKeyField}) + Const.CR;
                            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        } else {
                            errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.TechnicalKeyFound", (String[])new String[]{technicalKeyField}) + Const.CR;
                            cr = new CheckResult(1, (String)errorMessage, (ICheckResultSource)transformMeta);
                        }
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (i = 0; i < this.fields.getKeyFields().size(); ++i) {
                        keyField = this.fields.getKeyFields().get(i);
                        v = prev.searchValueMeta(keyField.getName());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.MissingFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + keyField.getName() + Const.CR;
                    }
                    cr = errorFound != false ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.AllFieldsFoundInInputStream", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.CouldNotReadFields", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                techKeyCreation = this.fields.getReturnFields().getTechKeyCreation();
                sequenceFrom = this.fields.getSequenceFrom();
                if (this.databaseMeta.supportsSequences() && "sequence".equals(techKeyCreation)) {
                    if (Utils.isEmpty((CharSequence)sequenceFrom)) {
                        errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorNoSequenceName", (String[])new String[0]) + "!";
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else if (db.checkSequenceExists(sequenceFrom)) {
                        errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ReadingSequenceOK", (String[])new String[]{sequenceFrom});
                        cr = new CheckResult(1, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorReadingSequence", (String[])new String[0]) + sequenceFrom + "!";
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (techKeyCreation == null || "autoinc".equals(techKeyCreation) || "sequence".equals(techKeyCreation) || "tablemax".equals(techKeyCreation)) ** GOTO lbl101
                errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorTechKeyCreation", (String[])new String[0]) + ": " + techKeyCreation + "!";
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
lbl101:
        // 4 sources

        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        SqlStatement retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                    Database db = new Database(loggingObject, variables, this.databaseMeta);
                    try {
                        String[] techKeyArr;
                        IValueMeta v;
                        int i;
                        boolean doHash = false;
                        String crTable = null;
                        db.connect();
                        RowMeta fields = new RowMeta();
                        String technicalKeyField = this.fields.getReturnFields().getTechnicalKeyField();
                        String sequenceFrom = this.fields.getSequenceFrom();
                        String lastUpdateField = this.fields.getReturnFields().getLastUpdateField();
                        ValueMetaInteger vkeyfield = new ValueMetaInteger(technicalKeyField);
                        vkeyfield.setLength(10);
                        vkeyfield.setPrecision(0);
                        ValueMetaInteger vhashfield = null;
                        if (this.useHash && !Utils.isEmpty((CharSequence)this.hashField)) {
                            vhashfield = new ValueMetaInteger(this.hashField);
                            vhashfield.setLength(15);
                            vhashfield.setPrecision(0);
                            doHash = true;
                        }
                        ValueMetaDate vLastUpdateField = null;
                        if (!Utils.isEmpty((CharSequence)lastUpdateField)) {
                            vLastUpdateField = new ValueMetaDate(lastUpdateField);
                        }
                        if (!db.checkTableExists(variables.resolve(this.schemaName), variables.resolve(this.tableName))) {
                            fields.addValueMeta((IValueMeta)vkeyfield);
                            int cnt = this.fields.getKeyFields().size();
                            for (i = 0; i < cnt; ++i) {
                                KeyField keyField = this.fields.getKeyFields().get(i);
                                Object errorField = "";
                                v = prev.searchValueMeta(keyField.getName());
                                if (v == null) continue;
                                String name = keyField.getLookup();
                                IValueMeta newValue = v.clone();
                                newValue.setName(name);
                                if (name.equals(vkeyfield.getName()) || doHash && name.equals(vhashfield.getName())) {
                                    errorField = (String)errorField + name;
                                }
                                if (((String)errorField).length() > 0) {
                                    retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NameCollision", (String[])new String[]{errorField}));
                                    continue;
                                }
                                fields.addValueMeta(newValue);
                            }
                            if (doHash) {
                                fields.addValueMeta((IValueMeta)vhashfield);
                            }
                            if (vLastUpdateField != null) {
                                fields.addValueMeta((IValueMeta)vLastUpdateField);
                            }
                        } else {
                            IRowMeta tabFields = db.getTableFields(schemaTable);
                            this.databaseMeta.quoteReservedWords(tabFields);
                            if (tabFields.searchValueMeta(vkeyfield.getName()) == null) {
                                fields.addValueMeta((IValueMeta)vkeyfield);
                            }
                            int cnt = tabFields.size();
                            for (i = 0; i < cnt; ++i) {
                                IValueMeta v2 = tabFields.getValueMeta(i);
                                fields.addValueMeta(v2);
                            }
                            for (i = 0; i < this.fields.getKeyFields().size(); ++i) {
                                KeyField keyField = this.fields.getKeyFields().get(i);
                                v = prev.searchValueMeta(keyField.getName());
                                if (v == null) continue;
                                IValueMeta newValue = v.clone();
                                newValue.setName(keyField.getLookup());
                                if (tabFields.searchValueMeta(newValue.getName()) != null) continue;
                                fields.addValueMeta(newValue);
                            }
                            if (doHash && tabFields.searchValueMeta(vhashfield.getName()) == null) {
                                fields.addValueMeta((IValueMeta)vhashfield);
                            }
                            if (vLastUpdateField != null && tabFields.searchValueMeta(vLastUpdateField.getName()) == null) {
                                fields.addValueMeta((IValueMeta)vLastUpdateField);
                            }
                        }
                        crTable = db.getDDL(schemaTable, (IRowMeta)fields, (String)(CREATION_METHOD_SEQUENCE.equals(technicalKeyField) && sequenceFrom != null && sequenceFrom.length() != 0 ? null : technicalKeyField), CREATION_METHOD_AUTOINC.equals(technicalKeyField), null, true);
                        Object crIndex = "";
                        Object crUniqIndex = "";
                        CharSequence[] idxFields = null;
                        if (this.useHash) {
                            if (this.hashField != null && this.hashField.length() > 0) {
                                idxFields = new String[]{this.hashField};
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotHashFieldSpecified", (String[])new String[0]));
                            }
                        } else if (!this.fields.getKeyFields().isEmpty()) {
                            int nrFields = this.fields.getKeyFields().size();
                            int maxFields = this.databaseMeta.getMaxColumnsInIndex();
                            if (maxFields > 0 && nrFields > maxFields) {
                                nrFields = maxFields;
                            }
                            idxFields = new String[nrFields];
                            for (i = 0; i < nrFields; ++i) {
                                KeyField keyField = this.fields.getKeyFields().get(i);
                                idxFields[i] = keyField.getLookup();
                            }
                        } else {
                            retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotFieldsSpecified", (String[])new String[0]));
                        }
                        if (!Utils.isEmpty((CharSequence)technicalKeyField) && !db.checkIndexExists(schemaTable, techKeyArr = new String[]{technicalKeyField})) {
                            String indexname = "idx_" + this.tableName + "_pk";
                            crUniqIndex = db.getCreateIndexStatement(schemaTable, indexname, techKeyArr, true, true, false, true);
                            crUniqIndex = (String)crUniqIndex + Const.CR;
                        }
                        if (!Utils.isEmpty((CharSequence[])idxFields) && !db.checkIndexExists(schemaTable, (String[])idxFields)) {
                            String indexname = "idx_" + this.tableName + "_lookup";
                            crIndex = db.getCreateIndexStatement(schemaTable, indexname, (String[])idxFields, false, false, false, true);
                            crIndex = (String)crIndex + Const.CR;
                        }
                        Object crSeq = "";
                        if (this.databaseMeta.supportsSequences() && !Utils.isEmpty((CharSequence)sequenceFrom) && !db.checkSequenceExists(this.schemaName, sequenceFrom)) {
                            crSeq = (String)crSeq + db.getCreateSequenceStatement(this.schemaName, sequenceFrom, 1L, 1L, -1L, true);
                            crSeq = (String)crSeq + Const.CR;
                        }
                        retval.setSql(variables.resolve(crTable + (String)crUniqIndex + (String)crIndex + (String)crSeq));
                    }
                    catch (HopException e) {
                        retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage());
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotTableDefined", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotReceivingField", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotConnectionDefined", (String[])new String[0]));
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) {
        for (int i = 0; i < this.fields.getKeyFields().size(); ++i) {
            KeyField keyField = this.fields.getKeyFields().get(i);
            IValueMeta v = prev.searchValueMeta(keyField.getName());
            DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, keyField.getLookup(), keyField.getName(), v != null ? v.getOrigin() : "?", "", this.useHash ? BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReadAndInsert.Label", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"CombinationLookupMeta.LookupAndInsert.Label", (String[])new String[0]));
            impact.add(ii);
        }
        if (this.useHash) {
            DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.hashField, "", "", "", BaseMessages.getString(PKG, (String)"CombinationLookupMeta.KeyLookup.Label", (String[])new String[0]));
            impact.add(ii);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    protected IRowMeta getDatabaseTableFields(Database db, String schemaName, String tableName) throws HopDatabaseException {
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination((IVariables)db, schemaName, tableName);
        IRowMeta extraFields = db.getTableFields(schemaTable);
        if (extraFields == null) {
            db.connect();
            extraFields = db.getTableFields(schemaTable);
        }
        return extraFields;
    }

    Database createDatabaseObject(IVariables variables) {
        return new Database(loggingObject, variables, this.databaseMeta);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public boolean isReplaceFields() {
        return this.replaceFields;
    }

    public void setReplaceFields(boolean replaceFields) {
        this.replaceFields = replaceFields;
    }

    public boolean isUseHash() {
        return this.useHash;
    }

    public void setUseHash(boolean useHash) {
        this.useHash = useHash;
    }

    public String getHashField() {
        return this.hashField;
    }

    public void setHashField(String hashField) {
        this.hashField = hashField;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public boolean isPreloadCache() {
        return this.preloadCache;
    }

    public void setPreloadCache(boolean preloadCache) {
        this.preloadCache = preloadCache;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public CFields getFields() {
        return this.fields;
    }

    public void setFields(CFields fields) {
        this.fields = fields;
    }
}

