/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.util.ZipFiles;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.DefaultArtifactResolver;
import org.apache.beam.sdk.util.construction.ModelCoders;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environments {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Environments.class);
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_DOCKER = "DOCKER";
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_PROCESS = "PROCESS";
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_EXTERNAL = "EXTERNAL";
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_EMBEDDED = "EMBEDDED";
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_LOOPBACK = "LOOPBACK";
    private static final @UnknownKeyFor @NonNull @Initialized String dockerContainerImageOption = "docker_container_image";
    private static final @UnknownKeyFor @NonNull @Initialized String externalServiceAddressOption = "external_service_address";
    private static final @UnknownKeyFor @NonNull @Initialized String processCommandOption = "process_command";
    private static final @UnknownKeyFor @NonNull @Initialized String processVariablesOption = "process_variables";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> allowedEnvironmentOptions = ImmutableMap.builder().put((Object)"DOCKER", (Object)ImmutableSet.of((Object)"docker_container_image")).put((Object)"EXTERNAL", (Object)ImmutableSet.of((Object)"external_service_address")).put((Object)"PROCESS", (Object)ImmutableSet.of((Object)"process_command", (Object)"process_variables")).build();
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String JAVA_SDK_HARNESS_CONTAINER_URL = Environments.getDefaultJavaSdkHarnessContainerUrl();
    public static final  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment JAVA_SDK_HARNESS_ENVIRONMENT = Environments.createDockerEnvironment(JAVA_SDK_HARNESS_CONTAINER_URL);

    private Environments() {
    }

    public static  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createOrGetDefaultEnvironment(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        RunnerApi.Environment defaultEnvironment;
        Environments.verifyEnvironmentOptions(options);
        String type = options.getDefaultEnvironmentType();
        String config = options.getDefaultEnvironmentConfig();
        if (Strings.isNullOrEmpty((String)type)) {
            defaultEnvironment = JAVA_SDK_HARNESS_ENVIRONMENT;
        } else {
            switch (type) {
                case "EMBEDDED": {
                    defaultEnvironment = Environments.createEmbeddedEnvironment(config);
                    break;
                }
                case "EXTERNAL": 
                case "LOOPBACK": {
                    defaultEnvironment = Environments.createExternalEnvironment(Environments.getExternalServiceAddress(options));
                    break;
                }
                case "PROCESS": {
                    defaultEnvironment = Environments.createProcessEnvironment(options);
                    break;
                }
                default: {
                    defaultEnvironment = Environments.createDockerEnvironment(Environments.getDockerContainerImage(options));
                }
            }
        }
        return defaultEnvironment.toBuilder().addAllDependencies(Environments.getDeferredArtifacts(options)).addAllCapabilities(Environments.getJavaCapabilities()).build();
    }

    public static  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createDockerEnvironment(@UnknownKeyFor @NonNull @Initialized String dockerImageUrl) {
        if (dockerImageUrl.isEmpty()) {
            return JAVA_SDK_HARNESS_ENVIRONMENT;
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn(RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(dockerImageUrl).build().toByteString()).build();
    }

    private static  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createExternalEnvironment(@UnknownKeyFor @NonNull @Initialized String externalServiceAddress) {
        if (externalServiceAddress.isEmpty()) {
            throw new IllegalArgumentException(String.format("External service address must not be empty (set it using '--environmentOptions=%s=...'?).", externalServiceAddressOption));
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn(RunnerApi.StandardEnvironments.Environments.EXTERNAL)).setPayload(RunnerApi.ExternalPayload.newBuilder().setEndpoint(Endpoints.ApiServiceDescriptor.newBuilder().setUrl(externalServiceAddress).build()).build().toByteString()).build();
    }

    private static  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createEmbeddedEnvironment(@UnknownKeyFor @NonNull @Initialized String config) {
        return RunnerApi.Environment.newBuilder().setUrn(ENVIRONMENT_EMBEDDED).setPayload(ByteString.copyFromUtf8((String)((String)MoreObjects.firstNonNull((Object)config, (Object)"")))).build();
    }

    private static  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createProcessEnvironment(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        if (options.getEnvironmentOptions() != null) {
            String processCommand = PortablePipelineOptions.getEnvironmentOption(options, processCommandOption);
            if (processCommand.isEmpty()) {
                throw new IllegalArgumentException(String.format("Environment option '%s' must be set for process environment.", processCommandOption));
            }
            return Environments.createProcessEnvironment("", "", processCommand, Environments.getProcessVariables(options));
        }
        try {
            ProcessPayloadReferenceJSON payloadReferenceJSON = (ProcessPayloadReferenceJSON)MAPPER.readValue(options.getDefaultEnvironmentConfig(), ProcessPayloadReferenceJSON.class);
            return Environments.createProcessEnvironment(payloadReferenceJSON.getOs(), payloadReferenceJSON.getArch(), payloadReferenceJSON.getCommand(), payloadReferenceJSON.getEnv());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to parse process environment config: %s", options.getDefaultEnvironmentConfig()), e);
        }
    }

    public static  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createProcessEnvironment(@UnknownKeyFor @NonNull @Initialized String os, @UnknownKeyFor @NonNull @Initialized String arch, @UnknownKeyFor @NonNull @Initialized String command, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> env) {
        RunnerApi.ProcessPayload.Builder builder = RunnerApi.ProcessPayload.newBuilder();
        if (!Strings.isNullOrEmpty((String)os)) {
            builder.setOs(os);
        }
        if (!Strings.isNullOrEmpty((String)arch)) {
            builder.setArch(arch);
        }
        if (!Strings.isNullOrEmpty((String)command)) {
            builder.setCommand(command);
        }
        if (env != null) {
            builder.putAllEnv(env);
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn(RunnerApi.StandardEnvironments.Environments.PROCESS)).setPayload(builder.build().toByteString()).build();
    }

    public static  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createAnyOfEnvironment(RunnerApi.Environment ... environments) {
        RunnerApi.AnyOfEnvironmentPayload.Builder payload = RunnerApi.AnyOfEnvironmentPayload.newBuilder();
        for (RunnerApi.Environment environment : environments) {
            payload.addEnvironments(environment);
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn(RunnerApi.StandardEnvironments.Environments.ANYOF)).setPayload(payload.build().toByteString()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment> expandAnyOfEnvironments( @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment) {
        return Stream.of(environment).flatMap(env -> {
            if (BeamUrns.getUrn(RunnerApi.StandardEnvironments.Environments.ANYOF).equals(environment.getUrn())) {
                try {
                    return RunnerApi.AnyOfEnvironmentPayload.parseFrom(environment.getPayload()).getEnvironmentsList().stream().flatMap(subenv -> Environments.expandAnyOfEnvironments(subenv).stream());
                }
                catch (InvalidProtocolBufferException exn) {
                    throw new RuntimeException(exn);
                }
            }
            return Stream.of(env);
        }).collect(Collectors.toList());
    }

    public static  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment resolveAnyOfEnvironment( @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment, String ... preferredEnvironmentTypes) {
        List<RunnerApi.Environment> allEnvironments = Environments.expandAnyOfEnvironments(environment);
        for (String urn : preferredEnvironmentTypes) {
            for (RunnerApi.Environment env : allEnvironments) {
                if (!urn.equals(env.getUrn())) continue;
                return env;
            }
        }
        return allEnvironments.iterator().next();
    }

    public static @UnknownKeyFor @NonNull @Initialized Optional< @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment> getEnvironment(@UnknownKeyFor @NonNull @Initialized String ptransformId,  @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        RunnerApi.PTransform ptransform = components.getTransformsOrThrow(ptransformId);
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironmentsOrThrow(envId));
    }

    public static @UnknownKeyFor @NonNull @Initialized Optional< @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment> getEnvironment( @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform ptransform, @UnknownKeyFor @NonNull @Initialized RehydratedComponents components) {
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironment(envId));
    }

    public static @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> getArtifacts(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> stagingFiles) {
        ImmutableList.Builder artifactsBuilder = ImmutableList.builder();
        LinkedHashSet<String> deduplicatedStagingFiles = new LinkedHashSet<String>(stagingFiles);
        for (String path : deduplicatedStagingFiles) {
            HashCode hashCode;
            File file;
            String stagedName = null;
            if (path.contains("=")) {
                String[] components = path.split("=", 2);
                file = new File(components[1]);
                stagedName = components[0];
            } else {
                file = new File(path);
            }
            if (!file.exists()) {
                if (stagedName != null) {
                    LOG.warn("Stage Artifact '{}' with the name '{}' was not found, staging will be ignored.", (Object)file, stagedName);
                    continue;
                }
                LOG.info("Stage Artifact '{}' was not found, staging will be ignored.", (Object)file);
                continue;
            }
            RunnerApi.ArtifactInformation.Builder artifactBuilder = RunnerApi.ArtifactInformation.newBuilder();
            artifactBuilder.setTypeUrn(BeamUrns.getUrn(RunnerApi.StandardArtifacts.Types.FILE));
            artifactBuilder.setRoleUrn(BeamUrns.getUrn(RunnerApi.StandardArtifacts.Roles.STAGING_TO));
            if (file.isDirectory()) {
                File zippedFile;
                try {
                    zippedFile = Environments.zipDirectory(file);
                    hashCode = Files.asByteSource((File)zippedFile).hash(Hashing.sha256());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                artifactBuilder.setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(zippedFile.getPath()).setSha256(hashCode.toString()).build().toByteString());
            } else {
                try {
                    hashCode = Files.asByteSource((File)file).hash(Hashing.sha256());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                artifactBuilder.setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(file.getPath()).setSha256(hashCode.toString()).build().toByteString());
            }
            if (stagedName == null) {
                stagedName = Environments.createStagingFileName(file, hashCode);
            }
            artifactBuilder.setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName(stagedName).build().toByteString());
            artifactsBuilder.add((Object)artifactBuilder.build());
        }
        return artifactsBuilder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> getDeferredArtifacts(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        List<String> stagingFiles = options.as(PortablePipelineOptions.class).getFilesToStage();
        if (stagingFiles == null || stagingFiles.isEmpty()) {
            return ImmutableList.of();
        }
        String key = UUID.randomUUID().toString();
        DefaultArtifactResolver.INSTANCE.register(info -> {
            if (BeamUrns.getUrn(RunnerApi.StandardArtifacts.Types.DEFERRED).equals(info.getTypeUrn())) {
                RunnerApi.DeferredArtifactPayload deferredArtifactPayload;
                try {
                    deferredArtifactPayload = RunnerApi.DeferredArtifactPayload.parseFrom(info.getTypePayload());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Error parsing deferred artifact payload.", e);
                }
                if (key.equals(deferredArtifactPayload.getKey())) {
                    return Optional.of(Environments.getArtifacts(stagingFiles));
                }
                return Optional.empty();
            }
            return Optional.empty();
        });
        return ImmutableList.of((Object)RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn(RunnerApi.StandardArtifacts.Types.DEFERRED)).setTypePayload(RunnerApi.DeferredArtifactPayload.newBuilder().setKey(key).build().toByteString()).build());
    }

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getJavaCapabilities() {
        ImmutableSet.Builder capabilities = ImmutableSet.builder();
        capabilities.addAll(ModelCoders.urns());
        capabilities.add((Object)BeamUrns.getUrn(RunnerApi.StandardProtocols.Enum.MULTI_CORE_BUNDLE_PROCESSING));
        capabilities.add((Object)BeamUrns.getUrn(RunnerApi.StandardProtocols.Enum.PROGRESS_REPORTING));
        capabilities.add((Object)BeamUrns.getUrn(RunnerApi.StandardProtocols.Enum.HARNESS_MONITORING_INFOS));
        capabilities.add((Object)BeamUrns.getUrn(RunnerApi.StandardProtocols.Enum.CONTROL_REQUEST_ELEMENTS_EMBEDDING));
        capabilities.add((Object)BeamUrns.getUrn(RunnerApi.StandardProtocols.Enum.STATE_CACHING));
        capabilities.add((Object)("beam:version:sdk_base:" + JAVA_SDK_HARNESS_CONTAINER_URL));
        capabilities.add((Object)BeamUrns.getUrn(RunnerApi.StandardPTransforms.SplittableParDoComponents.TRUNCATE_SIZED_RESTRICTION));
        capabilities.add((Object)BeamUrns.getUrn(RunnerApi.StandardPTransforms.Primitives.TO_STRING));
        capabilities.add((Object)BeamUrns.getUrn(RunnerApi.StandardProtocols.Enum.DATA_SAMPLING));
        return capabilities.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized JavaVersion getJavaVersion() {
        return JavaVersion.forSpecification(System.getProperty("java.specification.version"));
    }

    public static @UnknownKeyFor @NonNull @Initialized String createStagingFileName(@UnknownKeyFor @NonNull @Initialized File path, @UnknownKeyFor @NonNull @Initialized HashCode hash) {
        String encodedHash = Base64Variants.MODIFIED_FOR_URL.encode(hash.asBytes());
        String fileName = Files.getNameWithoutExtension((String)path.getAbsolutePath());
        String ext = path.isDirectory() ? "jar" : Files.getFileExtension((String)path.getAbsolutePath());
        String suffix = Strings.isNullOrEmpty((String)ext) ? "" : "." + ext;
        return String.format("%s-%s%s", fileName, encodedHash, suffix);
    }

    public static @UnknownKeyFor @NonNull @Initialized String getExternalServiceAddress(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        String environmentConfig = options.getDefaultEnvironmentConfig();
        String environmentOption = PortablePipelineOptions.getEnvironmentOption(options, externalServiceAddressOption);
        if (environmentConfig != null && !environmentConfig.isEmpty()) {
            return environmentConfig;
        }
        return environmentOption;
    }

    private static @UnknownKeyFor @NonNull @Initialized File zipDirectory(@UnknownKeyFor @NonNull @Initialized File directory) throws @UnknownKeyFor @NonNull @Initialized IOException {
        File zipFile = File.createTempFile(directory.getName(), ".zip");
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            ZipFiles.zipDirectory(directory, fos);
        }
        return zipFile;
    }

    private static @UnknownKeyFor @NonNull @Initialized String getDefaultJavaSdkHarnessContainerUrl() {
        return String.format("%s/%s%s_sdk:%s", ReleaseInfo.getReleaseInfo().getDefaultDockerRepoRoot(), ReleaseInfo.getReleaseInfo().getDefaultDockerRepoPrefix(), Environments.getJavaVersion().toString(), ReleaseInfo.getReleaseInfo().getSdkVersion());
    }

    private static @UnknownKeyFor @NonNull @Initialized String getDockerContainerImage(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        String environmentConfig = options.getDefaultEnvironmentConfig();
        String environmentOption = PortablePipelineOptions.getEnvironmentOption(options, dockerContainerImageOption);
        if (environmentConfig != null && !environmentConfig.isEmpty()) {
            return environmentConfig;
        }
        return environmentOption;
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getProcessVariables(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        ImmutableMap.Builder variables = ImmutableMap.builder();
        String assignments = PortablePipelineOptions.getEnvironmentOption(options, processVariablesOption);
        for (String assignment : assignments.split(",", -1)) {
            String[] tokens = assignment.split("=", -1);
            if (tokens.length == 1) {
                throw new IllegalArgumentException(String.format("Process environment variable '%s' is not assigned a value.", tokens[0]));
            }
            variables.put((Object)tokens[0], (Object)tokens[1]);
        }
        return variables.build();
    }

    private static void verifyEnvironmentOptions(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        if (options.getEnvironmentOptions() == null || options.getEnvironmentOptions().isEmpty()) {
            return;
        }
        if (!Strings.isNullOrEmpty((String)options.getDefaultEnvironmentConfig())) {
            throw new IllegalArgumentException("Pipeline options defaultEnvironmentConfig and environmentOptions are mutually exclusive.");
        }
        Set<String> allowedOptions = allowedEnvironmentOptions.getOrDefault(options.getDefaultEnvironmentType(), (Set<String>)ImmutableSet.of());
        for (String option : options.getEnvironmentOptions()) {
            String optionName = option.split("=", -1)[0];
            if (allowedOptions.contains(optionName)) continue;
            throw new IllegalArgumentException(String.format("Environment option '%s' is incompatible with environment type '%s'.", option, options.getDefaultEnvironmentType()));
        }
    }

    private static class ProcessPayloadReferenceJSON {
        private @Nullable @UnknownKeyFor @Initialized String os;
        private @Nullable @UnknownKeyFor @Initialized String arch;
        private @Nullable @UnknownKeyFor @Initialized String command;
        private @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> env;

        private ProcessPayloadReferenceJSON() {
        }

        public @Nullable @UnknownKeyFor @Initialized String getOs() {
            return this.os;
        }

        public @Nullable @UnknownKeyFor @Initialized String getArch() {
            return this.arch;
        }

        public @Nullable @UnknownKeyFor @Initialized String getCommand() {
            return this.command;
        }

        public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getEnv() {
            return this.env;
        }
    }

    public static enum JavaVersion {
        java8("java", "1.8", 8),
        java11("java11", "11", 11),
        java17("java17", "17", 17),
        java21("java21", "21", 21);

        private final @UnknownKeyFor @NonNull @Initialized String legacyName;
        private final @UnknownKeyFor @NonNull @Initialized String specification;
        private final @UnknownKeyFor @NonNull @Initialized int specificationInt;

        private JavaVersion(@UnknownKeyFor @NonNull @Initialized String legacyName, String specification, int specificationInt) {
            this.legacyName = legacyName;
            this.specification = specification;
            this.specificationInt = specificationInt;
        }

        public @UnknownKeyFor @NonNull @Initialized String legacyName() {
            return this.legacyName;
        }

        public @UnknownKeyFor @NonNull @Initialized String specification() {
            return this.specification;
        }

        public static @UnknownKeyFor @NonNull @Initialized JavaVersion forSpecification(@UnknownKeyFor @NonNull @Initialized String specification) {
            for (JavaVersion ver : JavaVersion.values()) {
                if (!ver.specification.equals(specification)) continue;
                return ver;
            }
            JavaVersion fallback = null;
            int specificationInt = Integer.parseInt(specification);
            int minDistance = Integer.MAX_VALUE;
            for (JavaVersion candidate : JavaVersion.values()) {
                int distance = Math.abs(candidate.specificationInt - specificationInt);
                if (distance > minDistance) continue;
                fallback = candidate;
                minDistance = distance;
            }
            LOG.warn("Unsupported Java version: {}, falling back to: {}", (Object)specification, (Object)fallback.specification);
            return fallback;
        }

        public static @UnknownKeyFor @NonNull @Initialized JavaVersion forSpecificationStrict(@UnknownKeyFor @NonNull @Initialized String specification) {
            for (JavaVersion ver : JavaVersion.values()) {
                if (!ver.specification.equals(specification)) continue;
                return ver;
            }
            throw new UnsupportedOperationException(String.format("unsupported Java version: %s", specification));
        }
    }
}

