/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class RowData
implements Serializable {
    static final long serialVersionUID = -5356418530948608994L;
    protected Vector rows_ = new Vector();
    protected Vector rowProperties_ = new Vector();
    transient int maxLoad_;
    transient int position_;
    transient PropertyChangeSupport changes_;
    transient VetoableChangeSupport vetos_;

    public RowData() {
        this.initializeTransient();
    }

    public boolean absolute(int rowIndex) {
        if (this.length() == 0 || rowIndex < 0) {
            this.position_ = -1;
            return false;
        }
        if (rowIndex >= this.length()) {
            this.position_ = this.length();
            return false;
        }
        this.position_ = rowIndex;
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public void afterLast() {
        this.position_ = this.length();
    }

    public void beforeFirst() {
        this.position_ = -1;
    }

    public boolean first() {
        if (this.length() != 0) {
            this.position_ = 0;
            return true;
        }
        return false;
    }

    public int getCurrentPosition() {
        return this.position_;
    }

    public abstract RowMetaData getMetaData() throws RowDataException;

    public Object getObject(int columnIndex) throws RowDataException {
        this.validateRowList("Attempting to get the column object");
        this.validateListPosition("Attempting to get the current object");
        Object[] row = (Object[])this.rows_.elementAt(this.position_);
        if (columnIndex < 0 || columnIndex >= row.length) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        return row[columnIndex];
    }

    public Vector getObjectProperties(int columnIndex) {
        this.validateRowList("Attempting to get the column object's properties");
        this.validateListPosition("Attempting to get the current object's properties");
        Vector[] propertyList = (Vector[])this.rowProperties_.elementAt(this.position_);
        if (columnIndex < 0 || columnIndex >= propertyList.length) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        return propertyList[columnIndex];
    }

    public Vector[] getRowProperties() {
        this.validateRowList("Attempting to get the row's property list");
        this.validateListPosition("Attempting to get the row's property list");
        return (Vector[])this.rowProperties_.elementAt(this.position_);
    }

    private void initializeTransient() {
        this.maxLoad_ = 0;
        this.position_ = -1;
    }

    public boolean isAfterLast() {
        return this.position_ == this.length();
    }

    public boolean isBeforeFirst() {
        return this.length() != 0 && this.position_ == -1;
    }

    public boolean isFirst() {
        return this.position_ == 0;
    }

    public boolean isLast() {
        return this.length() != 0 && this.position_ == this.length() - 1;
    }

    public boolean last() {
        if (this.length() != 0) {
            this.position_ = this.length() - 1;
            return true;
        }
        return false;
    }

    public int length() {
        return this.rows_.size();
    }

    public boolean next() {
        if (this.length() == 0) {
            return false;
        }
        if (this.position_ < this.length()) {
            ++this.position_;
        }
        return this.position_ != this.length();
    }

    public boolean previous() {
        if (this.position_ - 1 >= -1) {
            --this.position_;
        }
        return this.position_ != -1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, RowDataException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public boolean relative(int numberOfRows) {
        int temp = this.position_ + numberOfRows;
        if (this.length() == 0 || temp < 0) {
            this.position_ = -1;
            return false;
        }
        if (temp >= this.length()) {
            this.position_ = this.length();
            return false;
        }
        this.position_ = temp;
        return true;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setObjectProperties(Vector properties, int columnIndex) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Setting the column object's properties.");
        }
        this.validateRowList("Attempting to set a column object's properties");
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.validateListPosition("Attempting to set a column object's properties");
        Vector[] propertyList = (Vector[])this.rowProperties_.elementAt(this.position_);
        if (columnIndex < 0 || columnIndex >= propertyList.length) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        propertyList[columnIndex] = properties;
        this.rowProperties_.setElementAt(propertyList, this.position_);
    }

    void validateListPosition(String attemptedAction) {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            Trace.log(2, attemptedAction + " when the position in the list is invalid.");
            throw new ExtendedIllegalStateException("position", 4);
        }
    }

    void validateRowList(String attemptedAction) {
        if (this.length() == 0) {
            Trace.log(2, attemptedAction + " before adding a row to the list.");
            throw new ExtendedIllegalStateException("rows", 4);
        }
    }
}

