/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPool;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.AuthenticationServlet;
import com.ibm.as400.util.servlet.ResourceBundleLoader_s;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Properties;

public abstract class AS400Servlet
extends AuthenticationServlet {
    static final long serialVersionUID = 8682226107563431693L;
    private String head_ = "<html>\n<body>\n";
    private String end_ = "</body>\n</html>\n";
    private boolean useConnectionPool_ = false;
    private static ResourceBundleLoader_s loader_;
    private static AS400ConnectionPool connectionPool_;

    public void destroy() {
        this.log(ResourceBundleLoader_s.getText("PROP_DESC_SHUTDOWN"));
        if (this.useConnectionPool_) {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_CLEANUP"));
            connectionPool_.close();
        }
        this.log(ResourceBundleLoader_s.getText("PROP_DESC_SHUTDOWNCOMP"));
    }

    public AS400Servlet() {
    }

    public AS400Servlet(boolean useConnectionPool) {
        this.setUseConnectionPool(useConnectionPool);
    }

    public AS400ConnectionPool getConnectionPool() {
        return connectionPool_;
    }

    public String getDocumentEnd() {
        return this.end_;
    }

    public String getDocumentHead() {
        return this.head_;
    }

    public AS400 getSystem() throws ConnectionPoolException {
        Thread currentThread = Thread.currentThread();
        String threadId = currentThread.getName();
        Properties p = (Properties)this.getSessionData().get(threadId);
        String sysName = p.getProperty("realm");
        String uid = p.getProperty("uid");
        String pwd = p.getProperty("pwd");
        AS400 sys = connectionPool_ != null ? connectionPool_.getConnection(sysName, uid, pwd) : new AS400(sysName, uid, pwd);
        try {
            sys.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return sys;
    }

    public AS400 getSystem(String systemName) throws ConnectionPoolException {
        Thread currentThread = Thread.currentThread();
        String threadId = currentThread.getName();
        Properties p = (Properties)this.getSessionData().get(threadId);
        String uid = p.getProperty("uid");
        String pwd = p.getProperty("pwd");
        AS400 sys = connectionPool_ != null ? connectionPool_.getConnection(systemName, uid, pwd) : new AS400(systemName, uid, pwd);
        try {
            sys.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return sys;
    }

    public AS400 getSystem(int service) throws AS400SecurityException, IOException, ConnectionPoolException {
        Thread currentThread = Thread.currentThread();
        String threadId = currentThread.getName();
        Properties p = (Properties)this.getSessionData().get(threadId);
        String sysName = p.getProperty("realm");
        String uid = p.getProperty("uid");
        String pwd = p.getProperty("pwd");
        AS400 sys = null;
        try {
            if (connectionPool_ != null) {
                sys = connectionPool_.getConnection(sysName, uid, pwd, service);
                sys.setGuiAvailable(false);
            } else {
                sys = new AS400(sysName, uid, pwd);
                sys.setGuiAvailable(false);
                sys.connectService(service);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return sys;
    }

    public AS400 getSystem(String systemName, int service) throws AS400SecurityException, IOException, ConnectionPoolException {
        Thread currentThread = Thread.currentThread();
        String threadId = currentThread.getName();
        Properties p = (Properties)this.getSessionData().get(threadId);
        String uid = p.getProperty("uid");
        String pwd = p.getProperty("pwd");
        AS400 sys = null;
        try {
            if (connectionPool_ != null) {
                sys = connectionPool_.getConnection(systemName, uid, pwd, service);
                sys.setGuiAvailable(false);
            } else {
                sys = new AS400(systemName, uid, pwd);
                sys.setGuiAvailable(false);
                sys.connectService(service);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return sys;
    }

    public AS400 getSystem(String systemName, String userId, String password) throws ConnectionPoolException {
        AS400 sys = null;
        sys = connectionPool_ != null ? connectionPool_.getConnection(systemName, userId, password) : new AS400(systemName, userId, password);
        try {
            sys.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return sys;
    }

    public AS400 getSystem(String systemName, String userId, char[] password) throws ConnectionPoolException {
        AS400 sys = null;
        sys = connectionPool_ != null ? connectionPool_.getConnection(systemName, userId, password) : new AS400(systemName, userId, password);
        try {
            sys.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return sys;
    }

    public AS400 getSystem(String systemName, String userId, String password, int service) throws AS400SecurityException, IOException, ConnectionPoolException {
        AS400 sys = null;
        try {
            if (connectionPool_ != null) {
                this.log(ResourceBundleLoader_s.getText("PROP_DESC_USEPOOL"));
                sys = connectionPool_.getConnection(systemName, userId, password, service);
                sys.setGuiAvailable(false);
            } else {
                sys = new AS400(systemName, userId, password);
                sys.setGuiAvailable(false);
                sys.connectService(service);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return sys;
    }

    public boolean isUseConnectionPool() {
        return this.useConnectionPool_;
    }

    public void setDocumentEnd(String end) {
        if (end == null) {
            throw new NullPointerException("end");
        }
        this.end_ = end;
    }

    public void setDocumentHead(String head) {
        if (head == null) {
            throw new NullPointerException("head");
        }
        this.head_ = head;
    }

    public void setUseConnectionPool(boolean useConnectionPool) {
        this.useConnectionPool_ = useConnectionPool;
        if (this.useConnectionPool_) {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_USEPOOL"));
            if (connectionPool_ == null) {
                this.log(ResourceBundleLoader_s.getText("PROP_DESC_CREATEPOOL"));
                connectionPool_ = new AS400ConnectionPool();
            }
            connectionPool_.setLog(this.getLog());
        } else {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_NOTUSEPOOL"));
            if (connectionPool_ != null) {
                this.log(ResourceBundleLoader_s.getText("PROP_DESC_CLEANUPEXT"));
                connectionPool_.close();
                connectionPool_ = null;
            }
        }
    }

    public void returnSystem(AS400 system) {
        if (connectionPool_ == null) {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_NOTUSEPOOL"));
        } else {
            connectionPool_.returnConnectionToPool(system);
        }
    }

    @Override
    public final boolean validateAuthority(String realm, String uid, String pw) throws SecurityException, IOException {
        try {
            this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_AUTHENTICATE"), new String[]{uid, realm}));
            uid = uid.toUpperCase();
            realm = realm.toUpperCase();
            AS400 sys = new AS400(realm, uid, pw);
            sys.validateSignon();
            return true;
        }
        catch (ExtendedIllegalArgumentException e) {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_AUTHFAILED"));
            if (Trace.isTraceOn()) {
                Trace.log(2, e);
            }
            throw new SecurityException(e.getMessage());
        }
        catch (AS400SecurityException e) {
            int rtncode;
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_AUTHFAILED"));
            if (Trace.isTraceOn()) {
                Trace.log(2, e);
            }
            if (connectionPool_ != null && ((rtncode = e.getReturnCode()) == 32 || rtncode == 8 || rtncode == 31)) {
                connectionPool_.removeFromPool(realm, uid);
            }
            throw new SecurityException(e.getMessage());
        }
    }

    static {
        connectionPool_ = null;
    }
}

