/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.FileListRenderer;
import com.ibm.as400.util.html.HTMLTable;
import com.ibm.as400.util.servlet.HTMLTableConverter;
import com.ibm.as400.util.servlet.ListRowData;
import com.ibm.as400.util.servlet.RowDataException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Collator;
import javax.servlet.http.HttpServletRequest;

public class FileListElement
implements Serializable {
    static final long serialVersionUID = 6247154241289547698L;
    private AS400 system_;
    private HTMLTable table_;
    private HttpServletRequest request_;
    private FileListRenderer renderer_;
    private StringBuffer sharePath_;
    private StringBuffer shareName_;
    private String parameterPathInfo_;
    private boolean sort_ = true;
    private transient Collator collator_ = null;
    private transient PropertyChangeSupport changes_;
    private int patternMatching_ = -1;

    public FileListElement() {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception e) {
            this.collator_ = null;
        }
        this.renderer_ = null;
        this.system_ = null;
        this.request_ = null;
        this.shareName_ = null;
        this.sharePath_ = null;
    }

    public FileListElement(HttpServletRequest request) {
        this();
        this.setHttpServletRequest(request);
        this.setRenderer(new FileListRenderer(request));
    }

    public FileListElement(AS400 system, HttpServletRequest request) {
        this();
        this.setSystem(system);
        this.setHttpServletRequest(request);
        this.setRenderer(new FileListRenderer(request));
    }

    public FileListElement(AS400 system, HttpServletRequest request, String parameterPathInfo) {
        this();
        this.setSystem(system);
        this.setHttpServletRequest(request);
        this.setRenderer(new FileListRenderer(request));
        this.parameterPathInfo_ = parameterPathInfo;
    }

    public FileListElement(AS400 system, HttpServletRequest request, HTMLTable table) {
        this();
        this.setSystem(system);
        this.setHttpServletRequest(request);
        this.setTable(table);
        this.setRenderer(new FileListRenderer(request));
    }

    public FileListElement(AS400 system, HttpServletRequest request, String shareName, String sharePath) {
        this();
        this.setSystem(system);
        this.setHttpServletRequest(request);
        this.setRenderer(new FileListRenderer(request, shareName, sharePath));
        this.setShareName(shareName);
        this.setSharePath(sharePath);
    }

    public FileListElement(AS400 system, HttpServletRequest request, String shareName, String sharePath, String parameterPathInfo) {
        this();
        this.setSystem(system);
        this.setHttpServletRequest(request);
        this.setRenderer(new FileListRenderer(request, shareName, sharePath));
        this.setShareName(shareName);
        this.setSharePath(sharePath);
        this.parameterPathInfo_ = parameterPathInfo;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public Collator getCollator() {
        return this.collator_;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request_;
    }

    public FileListRenderer getRenderer() {
        return this.renderer_;
    }

    public String getSharePath() {
        if (this.sharePath_ == null) {
            return null;
        }
        return this.sharePath_.toString();
    }

    public String getShareName() {
        if (this.shareName_ == null) {
            return null;
        }
        return this.shareName_.toString();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public HTMLTable getTable() {
        return this.table_;
    }

    public String list() {
        return this.list(new HTMLTableConverter());
    }

    public String list(HTMLTableConverter conv) {
        block23: {
            if (conv == null) {
                throw new NullPointerException("conv");
            }
            if (this.request_ == null) {
                throw new ExtendedIllegalStateException("request", 4);
            }
            String path = null;
            path = this.parameterPathInfo_ == null ? this.request_.getPathInfo() : this.parameterPathInfo_;
            if (path == null) {
                path = "/";
            }
            if (this.sharePath_ != null) {
                try {
                    path = this.sharePath_.append(path.substring(path.indexOf(47, 1), path.length())).toString();
                }
                catch (StringIndexOutOfBoundsException e) {
                    path = this.sharePath_.insert(0, "/").toString();
                }
            }
            try {
                ListRowData rowData;
                File rootFile = null;
                if (this.system_ != null) {
                    rootFile = new IFSJavaFile(this.system_, path.replace('\\', '/'));
                    if (this.patternMatching_ != -1) {
                        try {
                            ((IFSJavaFile)rootFile).setPatternMatching(this.patternMatching_);
                        }
                        catch (IOException e) {
                            if (Trace.isTraceOn()) {
                                Trace.log(2, e);
                            }
                        }
                    }
                } else {
                    rootFile = new File(path);
                }
                if (Trace.isTraceOn()) {
                    Trace.log(3, "FileListElement path: " + path);
                }
                if (this.table_ == null) {
                    this.table_ = new HTMLTable();
                    this.table_.setCellPadding(7);
                    conv.setUseMetaData(true);
                } else if (this.table_.getHeader() == null) {
                    conv.setUseMetaData(true);
                }
                conv.setTable(this.table_);
                if (this.renderer_ == null) {
                    this.renderer_ = new FileListRenderer(this.request_);
                }
                if ((rowData = this.renderer_.getRowData(rootFile, this.sort_, this.collator_)).length() > 0) {
                    HTMLTable[] tables = conv.convertToTables(rowData);
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < tables.length; ++i) {
                        buf.append(tables[i].getTag());
                    }
                    return buf.toString();
                }
            }
            catch (PropertyVetoException rootFile) {
            }
            catch (RowDataException rde) {
                if (!Trace.isTraceOn()) break block23;
                Trace.log(2, rde);
            }
        }
        return "";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception e) {
            this.collator_ = null;
        }
        in.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void setCollator(Collator collator) {
        if (collator == null) {
            throw new NullPointerException("collator");
        }
        Collator old = this.collator_;
        this.collator_ = collator;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("collator", old, this.collator_);
        }
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        HttpServletRequest old = this.request_;
        this.request_ = request;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("request", old, this.request_);
        }
    }

    public void setRenderer(FileListRenderer renderer) {
        if (renderer == null) {
            throw new NullPointerException("renderer");
        }
        FileListRenderer old = this.renderer_;
        this.renderer_ = renderer;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("renderer", old, this.renderer_);
        }
    }

    public void setSharePath(String sharePath) {
        if (sharePath == null) {
            throw new NullPointerException("sharePath");
        }
        StringBuffer old = this.sharePath_;
        this.sharePath_ = new StringBuffer(sharePath);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("sharePath", old == null ? null : old.toString(), this.sharePath_.toString());
        }
    }

    public void setShareName(String shareName) {
        if (shareName == null) {
            throw new NullPointerException("shareName");
        }
        StringBuffer old = this.shareName_;
        this.shareName_ = new StringBuffer(shareName);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("shareName", old == null ? null : old.toString(), this.shareName_.toString());
        }
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        AS400 old = this.system_;
        this.system_ = system;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("system", old, this.system_);
        }
    }

    public void setTable(HTMLTable table) {
        if (table == null) {
            throw new NullPointerException("table");
        }
        HTMLTable old = table;
        this.table_ = table;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("table", old, this.table_);
        }
    }

    public void sort(boolean sort) {
        this.sort_ = sort;
    }

    public void setPatternMatching(int patternMatching) {
        if (patternMatching < 0 || patternMatching > 2) {
            throw new ExtendedIllegalArgumentException("patternMatching", 2);
        }
        this.patternMatching_ = patternMatching;
    }
}

