/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

public class OdfTextExtractor
extends DefaultElementVisitor {
    protected StringBuilder mTextBuilder;
    OdfElement mElement;
    protected static final char NewLineChar = '\r';
    protected static final char TabChar = '\t';

    protected OdfTextExtractor() {
    }

    protected OdfTextExtractor(OdfElement element) {
        this.mTextBuilder = new StringBuilder();
        this.mElement = element;
    }

    protected void appendElementText(OdfElement ele) {
        for (Node node = ele.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 3) {
                this.mTextBuilder.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            OdfElement element = (OdfElement)((Object)node);
            element.accept(this);
        }
    }

    public static OdfTextExtractor newOdfTextExtractor(OdfElement element) {
        return new OdfTextExtractor(element);
    }

    public void visit(OdfElement element) {
        if (element.getNamespaceURI().equals(OdfDocumentNamespace.META.getUri()) || element.getNamespaceURI().equals(OdfDocumentNamespace.DC.getUri())) {
            this.mTextBuilder.append('\r');
        }
        this.appendElementText(element);
    }

    public void visit(TextPElement ele) {
        this.mTextBuilder.append('\r');
        this.appendElementText(ele);
    }

    public void visit(TextHElement ele) {
        this.mTextBuilder.append('\r');
        this.appendElementText(ele);
    }

    public void visit(TextSElement ele) {
        Integer count = ele.getTextCAttribute();
        if (count == null) {
            count = 1;
        }
        for (int i = 0; i < count; ++i) {
            this.mTextBuilder.append(' ');
        }
    }

    public void visit(TextTabElement ele) {
        this.mTextBuilder.append('\t');
    }

    public void visit(TextLineBreakElement ele) {
        this.mTextBuilder.append('\r');
        this.appendElementText(ele);
    }

    public String getText() {
        this.visit(this.mElement);
        return this.mTextBuilder.toString();
    }
}

