/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.kafka.common.errors.SerializationException;

public class AvroSchemaUtils {
    private static final EncoderFactory encoderFactory = EncoderFactory.get();
    private static final DecoderFactory decoderFactory = DecoderFactory.get();
    private static final ObjectMapper jsonMapper = JacksonMapper.INSTANCE;
    private static final ObjectMapper jsonMapperWithOrderedProps = ((JsonMapper.Builder)JsonMapper.builder().nodeFactory((JsonNodeFactory)new SortingNodeFactory(false))).build();
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    private static final Map<String, Schema> primitiveSchemas;
    private static final Map<Schema, Schema> transformedSchemas;

    private static Schema createPrimitiveSchema(String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return new AvroSchema(schemaString).rawSchema();
    }

    public static AvroSchema copyOf(AvroSchema schema) {
        return schema.copy();
    }

    public static Map<String, Schema> getPrimitiveSchemas() {
        return Collections.unmodifiableMap(primitiveSchemas);
    }

    public static Schema getSchema(Object object) {
        return AvroSchemaUtils.getSchema(object, false, false, false);
    }

    public static Schema getSchema(Object object, boolean useReflection, boolean reflectionAllowNull, boolean removeJavaProperties) {
        if (object == null) {
            return primitiveSchemas.get("Null");
        }
        if (object instanceof Boolean) {
            return primitiveSchemas.get("Boolean");
        }
        if (object instanceof Integer) {
            return primitiveSchemas.get("Integer");
        }
        if (object instanceof Long) {
            return primitiveSchemas.get("Long");
        }
        if (object instanceof Float) {
            return primitiveSchemas.get("Float");
        }
        if (object instanceof Double) {
            return primitiveSchemas.get("Double");
        }
        if (object instanceof CharSequence) {
            return primitiveSchemas.get("String");
        }
        if (object instanceof byte[] || object instanceof ByteBuffer) {
            return primitiveSchemas.get("Bytes");
        }
        if (useReflection) {
            Schema schema;
            Schema schema2 = schema = reflectionAllowNull ? ReflectData.AllowNull.get().getSchema(object.getClass()) : ReflectData.get().getSchema(object.getClass());
            if (schema == null) {
                throw new SerializationException("Schema is null for object of class " + object.getClass().getCanonicalName());
            }
            return schema;
        }
        if (object instanceof GenericContainer) {
            Schema schema = ((GenericContainer)object).getSchema();
            if (removeJavaProperties) {
                Schema s = schema;
                schema = transformedSchemas.computeIfAbsent(s, k -> AvroSchemaUtils.removeJavaProperties(s));
            }
            return schema;
        }
        if (object instanceof Map) {
            Map mapValue = (Map)object;
            if (mapValue.isEmpty()) {
                return Schema.createMap((Schema)primitiveSchemas.get("Null"));
            }
            Schema valueSchema = AvroSchemaUtils.getSchema(mapValue.values().iterator().next());
            return Schema.createMap((Schema)valueSchema);
        }
        throw new IllegalArgumentException("Unsupported Avro type. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[] and IndexedRecord");
    }

    private static Schema removeJavaProperties(Schema schema) {
        try {
            JsonNode node = jsonMapper.readTree(schema.toString());
            AvroSchemaUtils.removeProperty(node, "avro.java.string");
            AvroSchema avroSchema = new AvroSchema(node.toString());
            return avroSchema.rawSchema();
        }
        catch (IOException e) {
            throw new SerializationException("Could not parse schema: " + schema.toString());
        }
    }

    private static void removeProperty(JsonNode node, String propertyName) {
        block3: {
            block2: {
                if (!node.isObject()) break block2;
                ObjectNode objectNode = (ObjectNode)node;
                objectNode.remove(propertyName);
                Iterator elements = objectNode.elements();
                while (elements.hasNext()) {
                    AvroSchemaUtils.removeProperty((JsonNode)elements.next(), propertyName);
                }
                break block3;
            }
            if (!node.isArray()) break block3;
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator elements = arrayNode.elements();
            while (elements.hasNext()) {
                AvroSchemaUtils.removeProperty((JsonNode)elements.next(), propertyName);
            }
        }
    }

    public static Object toObject(JsonNode value, AvroSchema schema) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            Schema rawSchema = schema.rawSchema();
            jsonMapper.writeValue((OutputStream)out, (Object)value);
            GenericDatumReader reader = new GenericDatumReader(rawSchema);
            Object object2 = object = reader.read(null, (Decoder)decoderFactory.jsonDecoder(rawSchema, (InputStream)new ByteArrayInputStream(out.toByteArray())));
            return object2;
        }
    }

    public static Object toObject(String value, AvroSchema schema) throws IOException {
        Schema rawSchema = schema.rawSchema();
        GenericDatumReader reader = new GenericDatumReader(rawSchema);
        Object object = reader.read(null, (Decoder)decoderFactory.jsonDecoder(rawSchema, value));
        return object;
    }

    public static byte[] toJson(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            AvroSchemaUtils.toJson(value, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void toJson(Object value, OutputStream out) throws IOException {
        Schema schema = AvroSchemaUtils.getSchema(value);
        JsonEncoder encoder = encoderFactory.jsonEncoder(schema, out);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        Object wrappedValue = value;
        if (value instanceof byte[]) {
            wrappedValue = ByteBuffer.wrap((byte[])value);
        }
        writer.write(wrappedValue, (Encoder)encoder);
        encoder.flush();
    }

    protected static String toNormalizedString(AvroSchema schema) {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            Schema.Parser parser = schema.getParser();
            for (String resolvedRef : schema.resolvedReferences().values()) {
                Schema schemaRef = parser.parse(resolvedRef);
                String fullName = schemaRef.getFullName();
                env.put(fullName, "\"" + fullName + "\"");
            }
            return AvroSchemaUtils.build(env, schema.rawSchema(), new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Appendable build(Map<String, String> env, Schema s, Appendable o) throws IOException {
        boolean firstTime = true;
        Schema.Type st = s.getType();
        LogicalType lt = s.getLogicalType();
        switch (st) {
            case UNION: {
                o.append('[');
                for (Schema b : s.getTypes()) {
                    if (!firstTime) {
                        o.append(',');
                    } else {
                        firstTime = false;
                    }
                    AvroSchemaUtils.build(env, b, o);
                }
                return o.append(']');
            }
            case ARRAY: 
            case MAP: {
                o.append("{\"type\":\"").append(st.getName()).append("\"");
                if (st == Schema.Type.ARRAY) {
                    AvroSchemaUtils.build(env, s.getElementType(), o.append(",\"items\":"));
                } else {
                    AvroSchemaUtils.build(env, s.getValueType(), o.append(",\"values\":"));
                }
                AvroSchemaUtils.setSimpleProps(o, s.getObjectProps());
                return o.append("}");
            }
            case ENUM: 
            case FIXED: 
            case RECORD: {
                String name = s.getFullName();
                if (env.get(name) != null) {
                    return o.append(env.get(name));
                }
                String qname = "\"" + name + "\"";
                env.put(name, qname);
                o.append("{\"name\":").append(qname);
                o.append(",\"type\":\"").append(st.getName()).append("\"");
                if (st == Schema.Type.ENUM) {
                    o.append(",\"symbols\":[");
                    for (String enumSymbol : s.getEnumSymbols()) {
                        if (!firstTime) {
                            o.append(',');
                        } else {
                            firstTime = false;
                        }
                        o.append('\"').append(enumSymbol).append('\"');
                    }
                    o.append("]");
                } else if (st == Schema.Type.FIXED) {
                    o.append(",\"size\":").append(Integer.toString(s.getFixedSize()));
                    lt = s.getLogicalType();
                    if (lt != null) {
                        AvroSchemaUtils.setLogicalProps(o, lt);
                    }
                } else {
                    o.append(",\"fields\":[");
                    for (Schema.Field f : s.getFields()) {
                        if (!firstTime) {
                            o.append(',');
                        } else {
                            firstTime = false;
                        }
                        o.append("{\"name\":\"").append(f.name()).append("\"");
                        AvroSchemaUtils.build(env, f.schema(), o.append(",\"type\":"));
                        AvroSchemaUtils.setFieldProps(o, f);
                        o.append("}");
                    }
                    o.append("]");
                }
                AvroSchemaUtils.setComplexProps(o, s);
                AvroSchemaUtils.setSimpleProps(o, s.getObjectProps());
                return o.append("}");
            }
        }
        if (lt != null) {
            return AvroSchemaUtils.writeLogicalType(s, lt, o);
        }
        return o.append('\"').append(st.getName()).append('\"');
    }

    private static Appendable writeLogicalType(Schema s, LogicalType lt, Appendable o) throws IOException {
        o.append("{\"type\":\"").append(s.getType().getName()).append("\"");
        AvroSchemaUtils.setLogicalProps(o, lt);
        AvroSchemaUtils.setSimpleProps(o, s.getObjectProps());
        return o.append("}");
    }

    private static void setLogicalProps(Appendable o, LogicalType lt) throws IOException {
        o.append(",\"").append("logicalType").append("\":\"").append(lt.getName()).append("\"");
        if (lt.getName().equals("decimal")) {
            LogicalTypes.Decimal dlt = (LogicalTypes.Decimal)lt;
            o.append(",\"precision\":").append(Integer.toString(dlt.getPrecision()));
            if (dlt.getScale() != 0) {
                o.append(",\"scale\":").append(Integer.toString(dlt.getScale()));
            }
        }
    }

    private static void setSimpleProps(Appendable o, Map<String, Object> schemaProps) throws IOException {
        TreeMap<String, Object> sortedProps = new TreeMap<String, Object>(schemaProps);
        for (Map.Entry entry : sortedProps.entrySet()) {
            String propKey = (String)entry.getKey();
            String propValue = AvroSchemaUtils.toJsonNode(entry.getValue()).toString();
            o.append(",\"").append(propKey).append("\":").append(propValue);
        }
    }

    private static void setComplexProps(Appendable o, Schema s) throws IOException {
        Set aliases;
        if (s.getDoc() != null && !s.getDoc().isEmpty()) {
            o.append(",\"doc\":").append(AvroSchemaUtils.toJsonNode(s.getDoc()).toString());
        }
        if (!(aliases = s.getAliases()).isEmpty()) {
            o.append(",\"aliases\":").append(AvroSchemaUtils.toJsonNode(new TreeSet(aliases)).toString());
        }
        if (s.getType() == Schema.Type.ENUM && s.getEnumDefault() != null) {
            o.append(",\"default\":").append(AvroSchemaUtils.toJsonNode(s.getEnumDefault()).toString());
        }
    }

    private static void setFieldProps(Appendable o, Schema.Field f) throws IOException {
        Set aliases;
        if (f.order() != null) {
            o.append(",\"order\":\"").append(f.order().toString()).append("\"");
        }
        if (f.doc() != null) {
            o.append(",\"doc\":").append(AvroSchemaUtils.toJsonNode(f.doc()).toString());
        }
        if (!(aliases = f.aliases()).isEmpty()) {
            o.append(",\"aliases\":").append(AvroSchemaUtils.toJsonNode(new TreeSet(aliases)).toString());
        }
        if (f.defaultVal() != null) {
            o.append(",\"default\":").append(AvroSchemaUtils.toJsonNode(f.defaultVal()).toString());
        }
        AvroSchemaUtils.setSimpleProps(o, f.getObjectProps());
    }

    static JsonNode toJsonNode(Object datum) {
        if (datum == null) {
            return null;
        }
        try {
            TokenBuffer generator = new TokenBuffer((ObjectCodec)jsonMapperWithOrderedProps, false);
            AvroSchemaUtils.genJson(datum, (JsonGenerator)generator);
            return (JsonNode)jsonMapperWithOrderedProps.readTree(generator.asParser());
        }
        catch (IOException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    static void genJson(Object datum, JsonGenerator generator) throws IOException {
        if (datum == JsonProperties.NULL_VALUE) {
            generator.writeNull();
        } else if (datum instanceof Map) {
            generator.writeStartObject();
            for (Map.Entry entry : ((Map)datum).entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                AvroSchemaUtils.genJson(entry.getValue(), generator);
            }
            generator.writeEndObject();
        } else if (datum instanceof Collection) {
            generator.writeStartArray();
            for (Object element : (Collection)datum) {
                AvroSchemaUtils.genJson(element, generator);
            }
            generator.writeEndArray();
        } else if (datum instanceof byte[]) {
            generator.writeString(new String((byte[])datum, StandardCharsets.ISO_8859_1));
        } else if (datum instanceof CharSequence || datum instanceof Enum) {
            generator.writeString(datum.toString());
        } else if (datum instanceof Double) {
            generator.writeNumber(((Double)datum).doubleValue());
        } else if (datum instanceof Float) {
            generator.writeNumber(((Float)datum).floatValue());
        } else if (datum instanceof Long) {
            generator.writeNumber(((Long)datum).longValue());
        } else if (datum instanceof Integer) {
            generator.writeNumber(((Integer)datum).intValue());
        } else if (datum instanceof Boolean) {
            generator.writeBoolean(((Boolean)datum).booleanValue());
        } else if (datum instanceof BigInteger) {
            generator.writeNumber((BigInteger)datum);
        } else if (datum instanceof BigDecimal) {
            generator.writeNumber((BigDecimal)datum);
        } else {
            throw new AvroRuntimeException("Unknown datum class: " + datum.getClass());
        }
    }

    static {
        transformedSchemas = new BoundedConcurrentHashMap<Schema, Schema>(DEFAULT_CACHE_CAPACITY);
        primitiveSchemas = new HashMap<String, Schema>();
        primitiveSchemas.put("Null", AvroSchemaUtils.createPrimitiveSchema("null"));
        primitiveSchemas.put("Boolean", AvroSchemaUtils.createPrimitiveSchema("boolean"));
        primitiveSchemas.put("Integer", AvroSchemaUtils.createPrimitiveSchema("int"));
        primitiveSchemas.put("Long", AvroSchemaUtils.createPrimitiveSchema("long"));
        primitiveSchemas.put("Float", AvroSchemaUtils.createPrimitiveSchema("float"));
        primitiveSchemas.put("Double", AvroSchemaUtils.createPrimitiveSchema("double"));
        primitiveSchemas.put("String", AvroSchemaUtils.createPrimitiveSchema("string"));
        primitiveSchemas.put("Bytes", AvroSchemaUtils.createPrimitiveSchema("bytes"));
    }

    static class SortingNodeFactory
    extends JsonNodeFactory {
        public SortingNodeFactory(boolean bigDecimalExact) {
            super(bigDecimalExact);
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

