/*
 * Decompiled with CFR 0.152.
 */
package jflex.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import jflex.core.LexParse;
import jflex.dfa.DFA;
import jflex.generator.Emitter;
import jflex.logging.Out;
import jflex.option.Options;

public final class Emitters {
    private Emitters() {
    }

    public static Emitter createFileEmitter(File inputLexFile, LexParse parser, DFA dfa) throws IOException {
        String name = Emitter.getBaseName(parser.scanner.className()) + ".java";
        File outputFile = Emitter.normalize(name, inputLexFile);
        String outputFileName = outputFile.getAbsolutePath();
        Out.println("Writing code to \"" + outputFile + "\"");
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Options.encoding)));
        return new Emitter(outputFileName, inputLexFile, parser, dfa, out);
    }

    public static Emitter createPrintWriterEmitter(LexParse parser, DFA dfa, PrintWriter writer) {
        return new Emitter(null, new File(""), parser, dfa, writer);
    }
}

