/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.cassandra.db.virtual.VirtualKeyspace;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;

public final class VirtualKeyspaceRegistry {
    public static final VirtualKeyspaceRegistry instance = new VirtualKeyspaceRegistry();
    private final Map<String, VirtualKeyspace> virtualKeyspaces = new ConcurrentHashMap<String, VirtualKeyspace>();
    private final Map<TableId, VirtualTable> virtualTables = new ConcurrentHashMap<TableId, VirtualTable>();

    private VirtualKeyspaceRegistry() {
    }

    public void register(VirtualKeyspace keyspace) {
        VirtualKeyspace previous = this.virtualKeyspaces.put(keyspace.name(), keyspace);
        if (previous != null) {
            previous.tables().forEach(t -> this.virtualTables.remove(t));
        }
        keyspace.tables().forEach(t -> this.virtualTables.put(t.metadata().id, (VirtualTable)t));
    }

    @Nullable
    public VirtualKeyspace getKeyspaceNullable(String name) {
        return this.virtualKeyspaces.get(name);
    }

    @Nullable
    public VirtualTable getTableNullable(TableId id) {
        return this.virtualTables.get(id);
    }

    @Nullable
    public KeyspaceMetadata getKeyspaceMetadataNullable(String name) {
        VirtualKeyspace keyspace = this.virtualKeyspaces.get(name);
        return null != keyspace ? keyspace.metadata() : null;
    }

    @Nullable
    public TableMetadata getTableMetadataNullable(TableId id) {
        VirtualTable table = this.virtualTables.get(id);
        return null != table ? table.metadata() : null;
    }

    public Iterable<KeyspaceMetadata> virtualKeyspacesMetadata() {
        return Iterables.transform(this.virtualKeyspaces.values(), VirtualKeyspace::metadata);
    }
}

