/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LdapUtils.class);

    public static String extractBaseDn(String dn) {
        int indexOfFirstDelimiter = dn.indexOf(",");
        if (indexOfFirstDelimiter > -1) {
            return dn.substring(indexOfFirstDelimiter + 1);
        }
        return null;
    }

    public static String extractFirstRdn(String dn) {
        return dn.substring(0, dn.indexOf(","));
    }

    public static String extractUserName(String userDn) {
        if (!LdapUtils.isDn(userDn) && !LdapUtils.hasDomain(userDn)) {
            return userDn;
        }
        int domainIdx = ServiceUtils.indexOfDomainMatch(userDn);
        if (domainIdx > 0) {
            return userDn.substring(0, domainIdx);
        }
        if (userDn.contains("=")) {
            return userDn.substring(userDn.indexOf("=") + 1, userDn.indexOf(","));
        }
        return userDn;
    }

    public static String getShortName(String rdn) {
        return rdn.split(",")[0].split("=")[1];
    }

    public static boolean hasDomain(String userName) {
        return ServiceUtils.indexOfDomainMatch(userName) > 0;
    }

    public static boolean isDn(String name) {
        return name.contains("=");
    }

    public static List<String> parseDnPatterns(HiveConf conf, HiveConf.ConfVars var) {
        String patternsString = conf.getVar(var);
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isBlank((String)patternsString)) {
            String defaultBaseDn = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN);
            String guidAttr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GUIDKEY);
            if (StringUtils.isNotBlank((String)defaultBaseDn)) {
                result.add(guidAttr + "=%s," + defaultBaseDn);
            }
        } else {
            String[] patterns;
            for (String pattern : patterns = patternsString.split(":")) {
                if (pattern.contains(",") && pattern.contains("=")) {
                    result.add(pattern);
                    continue;
                }
                LOG.warn("Unexpected format for " + var + "..ignoring " + pattern);
            }
        }
        return result;
    }

    private static String patternToBaseDn(String pattern) {
        if (pattern.contains("=%s")) {
            return pattern.split(",", 2)[1];
        }
        return pattern;
    }

    public static List<String> patternsToBaseDns(Collection<String> patterns) {
        ArrayList<String> result = new ArrayList<String>();
        for (String pattern : patterns) {
            result.add(LdapUtils.patternToBaseDn(pattern));
        }
        return result;
    }

    public static List<String> createCandidatePrincipals(HiveConf conf, String user) {
        if (LdapUtils.hasDomain(user) || LdapUtils.isDn(user)) {
            return Collections.singletonList(user);
        }
        String ldapDomain = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_DOMAIN);
        if (StringUtils.isNotBlank((String)ldapDomain)) {
            return Collections.singletonList(user + "@" + ldapDomain);
        }
        List<String> userPatterns = LdapUtils.parseDnPatterns(conf, HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN);
        if (userPatterns.isEmpty()) {
            return Collections.singletonList(user);
        }
        ArrayList<String> candidatePrincipals = new ArrayList<String>();
        for (String userPattern : userPatterns) {
            candidatePrincipals.add(userPattern.replaceAll("%s", user));
        }
        return candidatePrincipals;
    }

    private LdapUtils() {
    }
}

