/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceListEvent;
import com.ibm.as400.resource.ResourceListListener;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListDataEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class ResourceListModel
implements ListModel,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean exceptionOccured_ = false;
    private transient boolean loaded_ = false;
    private ResourceList resourceList_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    transient ListDataEventSupport listDataEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient ResourceListListener resourceListListener_;
    private transient WorkingEventSupport workingEventSupport_;

    public ResourceListModel() {
        this.initializeTransient();
    }

    public ResourceListModel(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        this.resourceList_ = resourceList;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listDataEventSupport_.addListDataListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Object getElementAt(int rowIndex) {
        if (this.resourceList_ == null || !this.loaded_ || this.exceptionOccured_) {
            return null;
        }
        try {
            if (rowIndex < 0 || this.resourceList_.isComplete() && (long)rowIndex > this.resourceList_.getListLength()) {
                return null;
            }
            return this.resourceList_.resourceAt(rowIndex);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
            this.exceptionOccured_ = true;
            return null;
        }
    }

    public ResourceList getResourceList() {
        return this.resourceList_;
    }

    @Override
    public int getSize() {
        if (this.resourceList_ == null || !this.loaded_ || this.exceptionOccured_) {
            return 0;
        }
        try {
            if (!this.resourceList_.isComplete()) {
                this.resourceList_.refreshStatus();
            }
            long listLength = this.resourceList_.getListLength();
            return (int)listLength;
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
            this.exceptionOccured_ = true;
            return 0;
        }
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listDataEventSupport_ = new ListDataEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.resourceListListener_ = new ResourceListListener_();
        this.workingEventSupport_ = new WorkingEventSupport(this);
        if (this.resourceList_ != null) {
            this.resourceList_.addActiveStatusListener(this.workingEventSupport_);
            this.resourceList_.addResourceListListener(this.resourceListListener_);
        }
    }

    public void load() {
        int previousLength = this.getSize();
        if (this.loaded_ && this.resourceList_ != null && !this.exceptionOccured_) {
            try {
                this.resourceList_.refreshContents();
            }
            catch (Exception e) {
                this.errorEventSupport_.fireError(e);
                this.exceptionOccured_ = true;
            }
        } else {
            this.loaded_ = true;
        }
        this.listDataEventSupport_.fireContentsChanged(0, previousLength);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listDataEventSupport_.removeListDataListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setResourceList(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        ResourceList oldValue = this.resourceList_;
        if (oldValue != resourceList) {
            int previousLength = this.getSize();
            if (oldValue != null) {
                oldValue.removeActiveStatusListener(this.workingEventSupport_);
                oldValue.removeResourceListListener(this.resourceListListener_);
            }
            resourceList.addActiveStatusListener(this.workingEventSupport_);
            resourceList.addResourceListListener(this.resourceListListener_);
            this.resourceList_ = resourceList;
            this.exceptionOccured_ = false;
            this.listDataEventSupport_.fireContentsChanged(0, previousLength);
        }
        this.propertyChangeSupport_.firePropertyChange("resourceList", oldValue, this.resourceList_);
    }

    private class ResourceListListener_
    implements ResourceListListener {
        private long length_ = 0L;

        private ResourceListListener_() {
        }

        @Override
        public void lengthChanged(ResourceListEvent event) {
            long newLength = event.getLength();
            ResourceListModel.this.listDataEventSupport_.fireIntervalAdded((int)this.length_, (int)newLength);
            this.length_ = newLength;
        }

        @Override
        public void listClosed(ResourceListEvent event) {
        }

        @Override
        public void listCompleted(ResourceListEvent event) {
        }

        @Override
        public void listInError(ResourceListEvent event) {
        }

        @Override
        public void listOpened(ResourceListEvent event) {
        }

        @Override
        public void resourceAdded(ResourceListEvent event) {
        }
    }
}

