/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HiddenFormInput;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class HTMLForm
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7610016051219431008L;
    public static final int METHOD_GET = 0;
    public static final int METHOD_POST = 1;
    private Vector list_ = new Vector();
    private String url_;
    private String target_;
    private Properties parms_;
    private boolean useGet_ = true;
    private int method_ = 0;
    private String lang_;
    private String dir_;
    private transient VetoableChangeSupport vetos_;
    private transient Vector elementListeners;

    public HTMLForm() {
    }

    public HTMLForm(String url) {
        this();
        try {
            this.setURL(url);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addElement(HTMLTagElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.list_.addElement(element);
        this.fireElementEvent(0);
    }

    public void addElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    public Properties getHiddenParameterList() {
        return this.parms_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public int getMethod() {
        return this.method_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLForm was here -->";
    }

    @Override
    public String getTag() {
        if (this.url_ == null) {
            Trace.log(2, "Attempting to get tag before setting the action URL address.");
            throw new ExtendedIllegalStateException("url", 4);
        }
        StringBuffer s = new StringBuffer("<form action=\"");
        s.append(this.url_);
        s.append("\"");
        if (this.method_ == 1) {
            s.append(" method=\"post\"");
        } else {
            s.append(" method=\"get\"");
        }
        if (this.target_ != null) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using target frame.");
            }
            s.append(" target=\"");
            s.append(this.target_);
            s.append("\"");
        }
        if (this.lang_ != null) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using language attribute.");
            }
            s.append(" lang=\"");
            s.append(this.lang_);
            s.append("\"");
        }
        if (this.dir_ != null) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using direction attribute.");
            }
            s.append(" dir=\"");
            s.append(this.dir_);
            s.append("\"");
        }
        s.append(this.getAttributeString());
        s.append(">\n");
        if (this.parms_ != null) {
            Enumeration<?> names = this.parms_.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = this.parms_.getProperty(name);
                HiddenFormInput h = new HiddenFormInput();
                try {
                    h.setName(name);
                    h.setValue(value);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                s.append(h.getTag());
                s.append("\n");
            }
        }
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement formElement = (HTMLTagElement)this.list_.elementAt(i);
            s.append(formElement.getTag());
            s.append("\n");
        }
        s.append("</form>");
        return s.toString();
    }

    public String getTarget() {
        return this.target_;
    }

    public String getURL() {
        return this.url_;
    }

    public boolean isUseGet() {
        return this.method_ == 0;
    }

    public boolean isUsePost() {
        return this.method_ == 1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeElement(HTMLTagElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (this.list_.removeElement(element)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setHiddenParameterList(Properties parameterList) throws PropertyVetoException {
        if (parameterList == null) {
            throw new NullPointerException("parameterList");
        }
        Properties old = this.parms_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("parameterList", old, parameterList);
        }
        this.parms_ = parameterList;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("parameterList", old, parameterList);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setMethod(int method) throws PropertyVetoException {
        if (method < 0 || method > 1) {
            throw new ExtendedIllegalArgumentException("method", 2);
        }
        int old = this.method_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("method", (Object)old, (Object)method);
        }
        this.method_ = method;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("method", (Object)old, (Object)method);
        }
    }

    public void setTarget(String target) throws PropertyVetoException {
        if (target == null) {
            throw new NullPointerException("target");
        }
        String old = this.target_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("target", old, target);
        }
        this.target_ = target;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("target", old, target);
        }
    }

    public void setURL(String url) throws PropertyVetoException {
        if (url == null) {
            throw new NullPointerException("url");
        }
        String old = this.url_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("url", old, url);
        }
        this.url_ = url;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("url", old, url);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

